/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import org.springframework.mail.SimpleMailMessage;

public final class MailMessageBuilder {
    private final SimpleMailMessage message = new SimpleMailMessage();

    public MailMessageBuilder to(String to) {
        this.message.setTo(to);
        return this;
    }

    public MailMessageBuilder subject(String subject) {
        this.message.setSubject(subject);
        return this;
    }

    public MailMessageBuilder cc(String ccVal) {
        this.message.setCc(ccVal);
        return this;
    }

    public MailMessageBuilder bcc(String bccVal) {
        this.message.setBcc(bccVal);
        return this;
    }

    public MailMessageBuilder text(String textVal) {
        this.message.setText(textVal);
        return this;
    }

    public SimpleMailMessage build() {
        if (this.message.getTo() == null || this.message.getSubject() == null || this.message.getText() == null) {
            SchedulerRuntimeException.logDontThrow("Null Values in one or more of the fields 'to','subject','text'");
        }
        return this.message;
    }
}

