/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="study_subject")
public class StudySubject
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Study study;
    private SubjectMrn subjectMrn;
    private boolean active;

    public StudySubject() {
        super(null);
    }

    public StudySubject(Study study, SubjectMrn subjectMrn, boolean active) {
        super(null);
        this.study = study;
        this.subjectMrn = subjectMrn;
        this.active = active;
    }

    @JoinColumn(name="study", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Study getStudy() {
        return this.study;
    }

    public void setStudy(Study study) {
        this.study = study;
    }

    @JoinColumn(name="subject_mrn", referencedColumnName="id")
    @ManyToOne(optional=false, cascade={CascadeType.ALL})
    public SubjectMrn getSubjectMrn() {
        return this.subjectMrn;
    }

    public void setSubjectMrn(SubjectMrn subjectMrn) {
        this.subjectMrn = subjectMrn;
    }

    @Column(name="active")
    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Transient
    public Subject getSubject() {
        return this.subjectMrn.getSubject();
    }

    public void setSubject(Subject subject) {
        this.subjectMrn.setSubject(subject);
    }

    @Transient
    public String getMrn() {
        return this.subjectMrn.getMrn();
    }

    @Transient
    public String getDecryptedMrn() {
        return SubjectDataEncryptor.decrypt(this.getMrn());
    }

    public String toString() {
        return "StudySubject [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

