/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.response.GetUsersResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDetailResponse;
import edu.harvard.catalyst.scheduler.entity.CentersAndInstitutions;
import edu.harvard.catalyst.scheduler.entity.Credential;
import edu.harvard.catalyst.scheduler.entity.Department;
import edu.harvard.catalyst.scheduler.entity.Division;
import edu.harvard.catalyst.scheduler.entity.FacultyRank;
import edu.harvard.catalyst.scheduler.entity.FundingSource;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Role;
import edu.harvard.catalyst.scheduler.entity.RoleType;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.UserSession;
import edu.harvard.catalyst.scheduler.persistence.CriteriaQueryHelper;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.util.OneWayPasswordEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class AuthDAO
extends SiteDAO {
    private static final Logger LOG = LogManager.getLogger(AuthDAO.class);

    public UserSession createUserSession(String httpSession, String ipAddress, User user) {
        UserSession userSession = new UserSession();
        userSession.setUser(user);
        userSession.setSessionId(httpSession);
        userSession.setIpAddress(ipAddress);
        userSession.setLastAccessTime(new Date());
        this.createEntity(userSession);
        return userSession;
    }

    public User authenticate(String username, String password, String httpSession) {
        User userFromEcommonsId = this.findUserByEcommonsId(username);
        if (userFromEcommonsId == null) {
            return null;
        }
        String encodedPassword = OneWayPasswordEncoder.getInstance().encode(password, userFromEcommonsId.getSalt());
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), User.class);
        criteriaHelper.whereEquals("ecommonsId", username);
        criteriaHelper.whereEquals("password", encodedPassword);
        User user = (User)criteriaHelper.getQuery().uniqueResult();
        if (user == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("EEE, MMM d, yyyy h:mm a");
        user.setPreviousLoginTime(user.getLastLoginTime() != null ? df.format(user.getLastLoginTime().getTime()) : "");
        user.setLastLoginTime(new Date());
        user.setSessionId(httpSession);
        user.setBookedVisits(null);
        this.updateEntity(user);
        return user;
    }

    public User findUserById(int id) {
        return this.findById(User.class, id);
    }

    public UserDetailResponse getUserData(int id) {
        User user = this.findById(User.class, id);
        return new UserDetailResponse(user);
    }

    public User findUserByEcommonsId(String id) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), User.class);
        criteriaHelper.whereEquals("ecommonsId", id);
        return (User)criteriaHelper.getQuery().uniqueResult();
    }

    public User findUserByEmail(String email) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), User.class);
        criteriaHelper.whereEquals("email", email);
        return (User)criteriaHelper.getQuery().uniqueResult();
    }

    public UserSession findUserSessionBySessionId(String sessionId) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), UserSession.class);
        criteriaHelper.whereEquals("sessionId", sessionId);
        return (UserSession)criteriaHelper.getQuery().uniqueResult();
    }

    public boolean checkEcommonsId(String ecommonsId) {
        LOG.info("testing ecommonsId: " + ecommonsId);
        return this.checkForUserByField("ecommonsId", ecommonsId);
    }

    public boolean checkEmail(String email) {
        LOG.info("testing email: " + email);
        return this.checkForUserByField("email", email);
    }

    private boolean checkForUserByField(String columnName, String columnValue) {
        CriteriaQueryHelper criteriaHelper = new CriteriaQueryHelper(this.session(), User.class);
        criteriaHelper.whereEquals(columnName, columnValue);
        User user = (User)criteriaHelper.getQuery().uniqueResult();
        return user == null;
    }

    public List<Credential> getCredentials() {
        return this.findAll(Credential.class);
    }

    public List<Division> getDivisions() {
        return this.findAll(Division.class);
    }

    public List<Department> getDepartments() {
        return this.findAll(Department.class);
    }

    public List<FacultyRank> getFacultyRanks() {
        return this.findAll(FacultyRank.class);
    }

    public List<Role> getRoles() {
        return this.findAll(Role.class);
    }

    public Credential findCredentialById(int id) {
        return this.findById(Credential.class, id);
    }

    public Department findDepartmentById(int id) {
        return this.findById(Department.class, id);
    }

    public Division findDivisionById(int id) {
        return this.findById(Division.class, id);
    }

    public FacultyRank findFacultyRankById(int id) {
        return this.findById(FacultyRank.class, id);
    }

    public List<FundingSource> getFundingSources() {
        return this.findAll(FundingSource.class);
    }

    public List<CentersAndInstitutions> getCentersAndInstitutions() {
        return this.findAll(CentersAndInstitutions.class);
    }

    private List<User> findUsersByInstitutionRole(InstitutionRoleType type) {
        String hql = "select u from User u where u.institutionRole = (select r from InstitutionRole r where r.type = :type)";
        Query query = this.newQuery("select u from User u where u.institutionRole = (select r from InstitutionRole r where r.type = :type)").setParameter("type", (Object)type);
        return query.list();
    }

    public List<Role> getRolesExceptFinalApprover() {
        String hql = "select r from Role r where r.type != :roleType";
        Query query = this.newQuery("select r from Role r where r.type != :roleType").setParameter("roleType", (Object)RoleType.ROLE_FINAL_APPROVER);
        return query.list();
    }

    public List<User> findSuperAdminByInstitutionRole() {
        return this.findUsersByInstitutionRole(InstitutionRoleType.ROLE_SUPER_ADMIN);
    }

    private List<User> findUserByRole(RoleType roleType) {
        String hql = "select u from User u where u.role = (select r from Role r where r.type = :roleType)";
        Query query = this.newQuery("select u from User u where u.role = (select r from Role r where r.type = :roleType)").setParameter("roleType", (Object)roleType);
        return query.list();
    }

    public List<User> findFinalApproverByRole() {
        return this.findUserByRole(RoleType.ROLE_FINAL_APPROVER);
    }

    public List<User> findAdminDirectorUserByRole() {
        return this.findUserByRole(RoleType.ROLE_ADMINISTRATIVE_DIRECTOR);
    }

    public List<User> findSchedulerUserByInstitutionRole() {
        return this.findUsersByInstitutionRole(InstitutionRoleType.ROLE_SCHEDULER);
    }

    public List<User> findNurseManagerUserByRole() {
        return this.findUserByRole(RoleType.ROLE_NURSE_MANAGER_DIRECTOR);
    }

    public List<User> findNutritionManagerUserByRole() {
        return this.findUserByRole(RoleType.ROLE_NUTRITION_MANAGER);
    }

    public List<User> findCRCAdminByRole() {
        return this.findUserByRole(RoleType.ROLE_CRC_ADMINISTRATION);
    }

    public List<UserDataResponse> getAddStudyMemberList(String filterString, String sortBy, String orderBy) {
        Query mainQuery = this.getUserListQueryUsingCustomFilterString(filterString, sortBy, orderBy);
        Long total = mainQuery.list().size();
        List resultRows = mainQuery.list();
        return UserDataResponse.getUserData(resultRows, total);
    }

    public GetUsersResponse getUsers(SearchDTO searchDTO, String sortBy, String orderBy, int page, int maxResults) {
        String coreHql = "from User u ";
        String totalSearchClause = "";
        if (searchDTO != null) {
            totalSearchClause = searchDTO.toSearchClause(" AND ", " WHERE ");
        }
        String listHql = "select u from User u " + totalSearchClause + " order by " + sortBy + " " + orderBy;
        Query listQuery = this.newQuery(listHql);
        String countHql = "select count(u) from User u " + totalSearchClause;
        Query countQuery = this.newQuery(countHql);
        if (searchDTO != null) {
            searchDTO.assignQueryParameterValues(listQuery);
            searchDTO.assignQueryParameterValues(countQuery);
        }
        long total = (Long)countQuery.uniqueResult();
        this.setPagination(page, maxResults, listQuery);
        List resultRows = listQuery.list();
        return GetUsersResponse.createGetUsersResponse(resultRows, total);
    }

    void setPagination(int page, int maxResults, Query mainQuery) {
        maxResults = MiscUtil.negativeIsInfinity(maxResults);
        int offset = (page - 1) * maxResults;
        mainQuery.setFirstResult(offset);
        mainQuery.setMaxResults(maxResults);
    }

    Query getUserListQueryUsingCustomFilterString(String filterString, String sortBy, String orderBy) {
        String simpleHql = "select u from User u ";
        boolean filterStringIsPresent = MiscUtil.isNonNullNonEmpty(filterString);
        String whereClause = !filterStringIsPresent ? " " : "where (lower(u.lastName) LIKE :filterString or lower(u.ecommonsId) LIKE :filterString) ";
        String completeHql = "select u from User u " + whereClause + " order by " + sortBy + " " + orderBy;
        Query mainQuery = this.newQuery(completeHql);
        if (filterStringIsPresent) {
            mainQuery.setParameter("filterString", (Object)("%" + filterString.toLowerCase() + "%"));
        }
        return mainQuery;
    }
}

