/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TransactionsReportDTO
implements CsvAbleDTO {
    private Integer asrId;
    private String asrName;
    private Date cancelTime;
    private String ecommonsId;
    private Date checkInTime;
    private Date checkOutTime;
    private String studyName;
    private String piFirstName;
    private String piMiddleName;
    private String piLastName;
    private String psFirstName;
    private String psMiddleName;
    private String psLastName;
    private String catalystId;
    private String localId;
    private String irb;
    private String visitName;
    private String visitTypeName;
    private String subjectFirstName;
    private String subjectMiddleName;
    private String subjectLastName;
    private String mrn;
    private String appointmentStatus;
    private String cancelStatus;
    private String cancelStatusReason;
    private Date scheduledStartTime;
    private Date scheduledEndTime;

    public Integer getAsrId() {
        return this.asrId;
    }

    public void setAsrId(Integer asrId) {
        this.asrId = asrId;
    }

    public String getAsrName() {
        return this.asrName;
    }

    public void setAsrName(String asrName) {
        this.asrName = asrName;
    }

    public Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(Date cancelTime) {
        this.cancelTime = cancelTime;
    }

    public String getEcommonsId() {
        return this.ecommonsId;
    }

    public void setEcommonsId(String ecommonsId) {
        this.ecommonsId = ecommonsId;
    }

    public Date getCheckInTime() {
        return this.checkInTime;
    }

    public void setCheckInTime(Date checkInTime) {
        this.checkInTime = checkInTime;
    }

    public Date getCheckOutTime() {
        return this.checkOutTime;
    }

    public void setCheckOutTime(Date checkOutTime) {
        this.checkOutTime = checkOutTime;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getPiFirstName() {
        return this.piFirstName;
    }

    public void setPiFirstName(String piFirstName) {
        this.piFirstName = piFirstName;
    }

    public String getPiMiddleName() {
        return this.piMiddleName;
    }

    public void setPiMiddleName(String piMiddleName) {
        this.piMiddleName = piMiddleName;
    }

    public String getPiLastName() {
        return this.piLastName;
    }

    public void setPiLastName(String piLastName) {
        this.piLastName = piLastName;
    }

    public String getPsFirstName() {
        return this.psFirstName;
    }

    public void setPsFirstName(String psFirstName) {
        this.psFirstName = psFirstName;
    }

    public String getPsMiddleName() {
        return this.psMiddleName;
    }

    public void setPsMiddleName(String psMiddleName) {
        this.psMiddleName = psMiddleName;
    }

    public String getPsLastName() {
        return this.psLastName;
    }

    public void setPsLastName(String psLastName) {
        this.psLastName = psLastName;
    }

    public String getCatalystId() {
        return this.catalystId;
    }

    public void setCatalystId(String catalystId) {
        this.catalystId = catalystId;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getIrb() {
        return this.irb;
    }

    public void setIrb(String irb) {
        this.irb = irb;
    }

    public String getVisitName() {
        return this.visitName;
    }

    public void setVisitName(String visitName) {
        this.visitName = visitName;
    }

    public String getVisitTypeName() {
        return this.visitTypeName;
    }

    public void setVisitTypeName(String visitTypeName) {
        this.visitTypeName = visitTypeName;
    }

    public String getSubjectFirstName() {
        return this.subjectFirstName;
    }

    public void setSubjectFirstName(String subjectFirstName) {
        this.subjectFirstName = subjectFirstName;
    }

    public String getSubjectMiddleName() {
        return this.subjectMiddleName;
    }

    public void setSubjectMiddleName(String subjectMiddleName) {
        this.subjectMiddleName = subjectMiddleName;
    }

    public String getSubjectLastName() {
        return this.subjectLastName;
    }

    public void setSubjectLastName(String subjectLastName) {
        this.subjectLastName = subjectLastName;
    }

    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    public String getAppointmentStatus() {
        return this.appointmentStatus;
    }

    public void setAppointmentStatus(String appointmentStatus) {
        this.appointmentStatus = appointmentStatus;
    }

    public String getCancelStatus() {
        return this.cancelStatus;
    }

    public void setCancelStatus(String cancelStatus) {
        this.cancelStatus = cancelStatus;
    }

    public String getCancelStatusReason() {
        return this.cancelStatusReason;
    }

    public void setCancelStatusReason(String cancelStatusReason) {
        this.cancelStatusReason = cancelStatusReason;
    }

    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    @Override
    public String toCsvHeaders() {
        return "Appointment Status Reason,Status Change Time,Cancellation Type,Cancellation Reason,User Initiating Change,Scheduled Start Time,Scheduled End Time,Visit Length,Study Name,PI,Primary Contact,Catalyst ID,Local ID,IRB #,Subject Name,MRN";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        int previousAsrId = -1;
        boolean firstTime = true;
        for (Object object : dtoList) {
            TransactionsReportDTO d = (TransactionsReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            int currentAsrId = d.asrId;
            if (currentAsrId != previousAsrId) {
                if (!firstTime) {
                    result.add(" \n");
                }
                firstTime = false;
                result.add(d.visitName + " - " + d.appointmentStatus + "\n");
                result.add(this.toCsvHeaders() + "\n");
            }
            previousAsrId = currentAsrId;
            columns.add(MiscUtil.q(d.asrName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.cancelTime)));
            columns.add(MiscUtil.q(d.cancelStatus));
            columns.add(MiscUtil.q(d.cancelStatusReason));
            columns.add(MiscUtil.q(d.ecommonsId));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledStartTime)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.scheduledEndTime)));
            columns.add(MiscUtil.q(MiscUtil.formatEndMinusStart(d.scheduledStartTime, d.scheduledEndTime)));
            columns.add(MiscUtil.q(d.studyName));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.piFirstName, d.piMiddleName, d.piLastName)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.psFirstName, d.psMiddleName, d.psLastName)));
            columns.add(MiscUtil.q(d.catalystId));
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.irb));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.subjectFirstName, d.subjectMiddleName, d.subjectLastName)));
            columns.add(MiscUtil.q(d.mrn));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

