/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.Range;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.TemplateResourceDTO;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="template_resource")
public class TemplateResource
extends BaseEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private VisitTemplate visitTemplate;
    private Resource resource;
    private boolean alternate;
    private boolean billable;
    private Integer duration;
    private Integer floatStart;
    private Integer floatEnd;
    private Date createdDate;
    private Date lastUpdateTime;
    private Boolean floatable;
    private Boolean flexible;
    private Integer startMinutes;
    private Integer endMinutes;
    private String groupId;
    private Date scheduledStartTime;
    private Date scheduledEndTime;
    private int availableStartTimeInMin;
    private int availableEndTimeInMin;
    private Boolean alternateResourceUsed;
    private String annotations;
    private String rejectedResourceMessage;
    private String available;
    private String resourceGroupType;
    static final Comparator<TemplateResource> TemplateResourceComparator = (o1, o2) -> o1.getStartMinutes().compareTo(o2.getStartMinutes());

    public TemplateResource() {
        super(null);
    }

    public TemplateResource(TemplateResourceDTO trDto, Resource resource, VisitTemplate visitTemplate) {
        super(null);
        this.setResource(resource);
        this.setVisitTemplate(visitTemplate);
        Date now = new Date();
        this.setCreatedDate(now);
        this.setLastUpdateTime(now);
        this.possiblyUpdateMyNonResourceFields(trDto, true);
    }

    public final boolean possiblyUpdateMyNonResourceFields(TemplateResourceDTO trDto) {
        return this.possiblyUpdateMyNonResourceFields(trDto, false);
    }

    public final boolean possiblyUpdateMyNonResourceFields(TemplateResourceDTO trDto, boolean creationSoGoForIt) {
        if (!creationSoGoForIt && trDto.matches(this)) {
            return false;
        }
        this.setAlternate(trDto.isAlternate());
        this.setBillable(trDto.isBillable());
        this.setFlexible(trDto.isFlexible());
        if (trDto.isFloatable()) {
            this.makeFloatable(trDto.getFloatStart(), trDto.getFloatEnd());
        } else {
            this.makeNotFloatable();
        }
        this.setStartMinutes(trDto.getStartMinutes());
        this.setEndMinutes(trDto.getEndMinutes());
        this.calculateDuration();
        return true;
    }

    void calculateDuration() {
        if (this.startMinutes != null && this.endMinutes != null) {
            Integer minutesFromStartToEnd = this.endMinutes - this.startMinutes;
            this.setDuration(minutesFromStartToEnd);
        } else {
            this.duration = null;
        }
    }

    private boolean sameStart(TemplateResource next) {
        return this.getStartMinutes().intValue() == next.getStartMinutes().intValue();
    }

    private boolean tangentBefore(TemplateResource next) {
        return this.getEndMinutes().intValue() == next.getStartMinutes().intValue();
    }

    public void makeNotFloatable() {
        this.updateFloatability(Boolean.FALSE, null, null);
    }

    public void makeFloatable(Integer floatStart, Integer floatEnd) {
        this.updateFloatability(Boolean.TRUE, floatStart, floatEnd);
    }

    private void updateFloatability(Boolean f, Integer start, Integer end) {
        this.setFloatable(f);
        this.setFloatStart(start);
        this.setFloatEnd(end);
    }

    @JoinColumn(name="visit_template", referencedColumnName="id")
    @ManyToOne(optional=false)
    public VisitTemplate getVisitTemplate() {
        return this.visitTemplate;
    }

    public void setVisitTemplate(VisitTemplate visitTemplate) {
        this.visitTemplate = visitTemplate;
    }

    @JoinColumn(name="resource", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    @Column(name="alternate")
    public boolean getAlternate() {
        return this.alternate;
    }

    public void setAlternate(boolean alternate) {
        this.alternate = alternate;
    }

    @Column(name="billable")
    public boolean getBillable() {
        return this.billable;
    }

    public void setBillable(boolean billable) {
        this.billable = billable;
    }

    @Column(name="duration")
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    @Column(name="float_start")
    public Integer getFloatStart() {
        return this.floatStart;
    }

    public void setFloatStart(Integer floatStart) {
        this.floatStart = floatStart;
    }

    @Column(name="float_end")
    public Integer getFloatEnd() {
        return this.floatEnd;
    }

    public void setFloatEnd(Integer floatEnd) {
        this.floatEnd = floatEnd;
    }

    @Column(name="created_date")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Column(name="last_update_time")
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Column(name="floatable")
    public Boolean getFloatable() {
        return this.floatable;
    }

    public void setFloatable(Boolean floatable) {
        this.floatable = floatable;
    }

    @Column(name="flexible")
    public Boolean getFlexible() {
        return this.flexible;
    }

    public void setFlexible(Boolean flexible) {
        this.flexible = flexible;
    }

    @Transient
    public Date getStartDate() {
        if (this.startMinutes != null) {
            return DateUtility.originDatePlusMinutes(this.startMinutes.intValue());
        }
        return null;
    }

    @Transient
    public Date getEndDate() {
        if (this.endMinutes != null) {
            return DateUtility.originDatePlusMinutes(this.endMinutes.intValue());
        }
        return null;
    }

    @Column(name="start_minutes")
    public Integer getStartMinutes() {
        return this.startMinutes;
    }

    public void setStartMinutes(Integer startMinutes) {
        this.startMinutes = startMinutes;
    }

    @Column(name="end_minutes")
    public Integer getEndMinutes() {
        return this.endMinutes;
    }

    public void setEndMinutes(Integer endMinutes) {
        this.endMinutes = endMinutes;
    }

    @Column(name="group_id")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Transient
    public boolean getUngroupedFloatable() {
        return this.floatable != false && this.groupId == null;
    }

    @Transient
    public boolean getUngroupedFlexible() {
        return this.flexible != false && this.groupId == null;
    }

    @Transient
    public boolean getGroupedFloatable() {
        return this.floatable != false && this.groupId != null;
    }

    @Transient
    public boolean getGroupedFlexible() {
        return this.flexible != false && this.groupId != null;
    }

    @Transient
    public Date getScheduledEndTime() {
        return this.scheduledEndTime;
    }

    public void setScheduledEndTime(Date scheduledEndTime) {
        this.scheduledEndTime = scheduledEndTime;
    }

    @Transient
    public Date getScheduledStartTime() {
        return this.scheduledStartTime;
    }

    public void setScheduledStartTime(Date scheduledStartTime) {
        this.scheduledStartTime = scheduledStartTime;
    }

    @Transient
    public int getAvailableEndTimeInMin() {
        return this.availableEndTimeInMin;
    }

    public void setAvailableEndTimeInMin(int availableEndTimeInMin) {
        this.availableEndTimeInMin = availableEndTimeInMin;
    }

    @Transient
    public int getAvailableStartTimeInMin() {
        return this.availableStartTimeInMin;
    }

    public void setAvailableStartTimeInMin(int availableStartTimeInMin) {
        this.availableStartTimeInMin = availableStartTimeInMin;
    }

    @Transient
    public Boolean getAlternateResourceUsed() {
        return this.alternateResourceUsed;
    }

    public void setAlternateResourceUsed(Boolean alternateResourceUsed) {
        this.alternateResourceUsed = alternateResourceUsed;
    }

    @Transient
    public String getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(String annotations) {
        this.annotations = annotations;
    }

    @Transient
    public String getRejectedResourceMessage() {
        return this.rejectedResourceMessage;
    }

    public void setRejectedResourceMessage(String rejectedResourceMessage) {
        this.rejectedResourceMessage = rejectedResourceMessage;
    }

    @Transient
    public String getAvailable() {
        return this.available;
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    @Transient
    public String getResourceGroupType() {
        return this.resourceGroupType;
    }

    public void setResourceGroupType(String resourceGroupType) {
        this.resourceGroupType = resourceGroupType;
    }

    public TemplateResource cloneTemplateResource() {
        TemplateResource result = null;
        try {
            result = (TemplateResource)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            SchedulerRuntimeException.logAndThrow("Couldn't clone TemplateResource '" + this.getId() + "'", exception);
        }
        return result;
    }

    public String toString() {
        return "TemplateResource [id=" + this.id + ", getId()=" + this.getId() + "]";
    }

    public static <T> boolean allTheSame(List<TemplateResource> list, Function<TemplateResource, T> function) {
        return RichList.enrich(list).map(function).toSet().size() == 1;
    }

    public static String isValidFlexGroup(List<TemplateResource> templateResourceList) {
        if (TemplateResource.allTheSame(templateResourceList, TemplateResource::getStartMinutes)) {
            return "At least one resource must not share the same start time";
        }
        if (!TemplateResource.allTheSame(templateResourceList, TemplateResource::getDuration)) {
            return "The duration of all the Flex Resources should be the same.";
        }
        if (!TemplateResource.allTheSame(templateResourceList, TemplateResource::getFlexible)) {
            return "Not all of the Resources are Flex Resources.";
        }
        Collections.sort(templateResourceList, TemplateResourceComparator);
        for (int i = 0; i < templateResourceList.size() - 1; ++i) {
            TemplateResource next;
            TemplateResource current = templateResourceList.get(i);
            if (current.tangentBefore(next = templateResourceList.get(i + 1)) || current.sameStart(next)) continue;
            return "There is a time gap between the Flex Resources / does not meet the flex link criteria, hence cannot be linked.";
        }
        return "OK";
    }

    public static List<TemplateResource> getValidFlexGroup(List<TemplateResource> templateResourceList, TemplateResource aspirantResource) {
        Collections.sort(templateResourceList, TemplateResourceComparator);
        Collection sameDurationResources = templateResourceList.stream().filter(s -> s.getDuration().equals(aspirantResource.getDuration())).collect(Collectors.toList());
        ArrayList<TemplateResource> initialCandidateResources = new ArrayList<TemplateResource>();
        List<Integer> possibleFlexTimes = aspirantResource.getFlexTimes();
        for (TemplateResource templateResource : sameDurationResources) {
            int currentMinutes = templateResource.getStartMinutes();
            if (!possibleFlexTimes.contains(currentMinutes)) continue;
            initialCandidateResources.add(templateResource);
        }
        Collection nonDuplicatedResources = initialCandidateResources.stream().collect(HashMap::new, (m, e) -> m.put(e.getStartMinutes(), e), Map::putAll).values();
        ArrayList tr = Lists.newArrayList(nonDuplicatedResources);
        Collections.sort(tr, TemplateResourceComparator);
        ArrayList finalTimeList = Lists.newArrayList();
        for (int i = 0; i < tr.size() - 1; ++i) {
            TemplateResource next;
            TemplateResource current = (TemplateResource)tr.get(i);
            if (!current.tangentBefore(next = (TemplateResource)tr.get(i + 1))) continue;
            finalTimeList.add(current.getStartMinutes());
            finalTimeList.add(next.getStartMinutes());
        }
        Collection candidateResourcesCollection = initialCandidateResources.stream().filter(s -> finalTimeList.contains(s.getStartMinutes())).collect(Collectors.toList());
        ArrayList candidateResources = Lists.newArrayList((Iterable)candidateResourcesCollection);
        candidateResources.remove(aspirantResource);
        Collections.sort(candidateResources, TemplateResourceComparator);
        return candidateResources;
    }

    @Transient
    private List<Integer> getFlexTimes() {
        ArrayList possibleFlexTimes = Lists.newArrayList();
        Integer resourceDuration = this.getDuration();
        int aspirantStartMinutes = this.getStartMinutes();
        possibleFlexTimes.add(aspirantStartMinutes);
        int oneBeforeAspirantStartMinutes = this.getStartMinutes() - resourceDuration;
        possibleFlexTimes.add(oneBeforeAspirantStartMinutes);
        int twoBeforeAspirantStartMinutes = oneBeforeAspirantStartMinutes - resourceDuration;
        possibleFlexTimes.add(twoBeforeAspirantStartMinutes);
        int oneAfterAspirantStartMinutes = this.getStartMinutes() + resourceDuration;
        possibleFlexTimes.add(oneAfterAspirantStartMinutes);
        int twoAfterAspirantStartMinutes = oneAfterAspirantStartMinutes + resourceDuration;
        possibleFlexTimes.add(twoAfterAspirantStartMinutes);
        return possibleFlexTimes;
    }

    public static String isValidFloatGroup(List<TemplateResource> templateResourceList) {
        if (!TemplateResource.allTheSame(templateResourceList, TemplateResource::getStartMinutes) || !TemplateResource.allTheSame(templateResourceList, TemplateResource::getEndMinutes)) {
            return "The preferred start time and end time of the Float Resources do not match.";
        }
        if (!TemplateResource.allTheSame(templateResourceList, TemplateResource::getFloatStart) || !TemplateResource.allTheSame(templateResourceList, TemplateResource::getFloatEnd)) {
            return "The float start time and end time of the Float Resources do not match.";
        }
        if (!TemplateResource.allTheSame(templateResourceList, TemplateResource::getFloatable)) {
            return "Not all of the Resources are Float Resources.";
        }
        return "OK";
    }

    static int minutesFromOriginToDayNumber(int minutes) {
        int daysFromOrigin = minutes / 1440;
        return 1 + daysFromOrigin;
    }

    @Transient
    public int getOneDayDuration(int dayOffset) {
        int result;
        int startDayOffset = TemplateResource.minutesFromOriginToDayNumber(this.getStartMinutes());
        int endDayOffset = TemplateResource.minutesFromOriginToDayNumber(this.getEndMinutes());
        int startMinutes = DateUtility.minutesIntoDay(this.getStartMinutes());
        int endMinutes = DateUtility.minutesIntoDay(this.getEndMinutes());
        if (endDayOffset < dayOffset || startDayOffset > dayOffset) {
            result = 0;
        } else if (startDayOffset < dayOffset && endDayOffset == dayOffset) {
            result = endMinutes;
        } else if (startDayOffset == dayOffset && endDayOffset > dayOffset) {
            result = 1440 - startMinutes;
        } else if (startDayOffset < dayOffset && endDayOffset > dayOffset) {
            result = 1440;
        } else if (startDayOffset == dayOffset && endDayOffset == dayOffset) {
            result = endMinutes - startMinutes;
        } else {
            result = 0;
            SchedulerRuntimeException.logAndThrow("Unexpected combination of startMinutes, endMinutes, dayOffset in getOneDayDuration()");
        }
        return result;
    }

    public void determineAnnotationsString(List<TemplateResourceAnnotations> traList, boolean addQuantities) {
        List annotationStringList = traList.stream().map(tra -> addQuantities ? tra.getQuantifiedLlaName() : tra.getLineLevelAnnotations().getName()).collect(Collectors.toList());
        annotationStringList.sort(Comparator.naturalOrder());
        this.setAnnotations(Joiner.on((String)", ").join(annotationStringList));
    }

    public boolean occursInOneDay() {
        boolean mainStartEndAreSameDay = DateUtility.earlierAndLaterAreSameLocalDay(this.startMinutes, this.endMinutes);
        boolean floatSameDay = true;
        if (this.floatable.booleanValue()) {
            floatSameDay = DateUtility.earlierAndLaterAreSameLocalDay(this.floatStart, this.floatEnd);
        }
        return mainStartEndAreSameDay && floatSameDay;
    }

    public boolean startDayOffsetMatches(int desiredOffset) {
        return TemplateResource.minutesFromOriginToDayNumber(this.startMinutes) == desiredOffset;
    }

    public boolean resourceOverlapsDayOffset(int desiredDaysOffset) {
        boolean mainDatesOverlap = DateUtility.minutesIntervalOverlapsDaysOffset(this.startMinutes, this.endMinutes, desiredDaysOffset);
        boolean floatDatesOverlap = false;
        if (this.floatable.booleanValue()) {
            floatDatesOverlap = DateUtility.minutesIntervalOverlapsDaysOffset(this.floatStart, this.floatEnd, desiredDaysOffset);
        }
        return mainDatesOverlap || floatDatesOverlap;
    }

    @Transient
    public boolean isGrouped() {
        return this.groupId != null;
    }

    public static int totalVisitCalendarDays(List<TemplateResource> allVisitTrs) {
        int latestFloatEndMinutesAtStartOfDay;
        if (allVisitTrs.isEmpty()) {
            return 0;
        }
        Integer latestEndMinutes = allVisitTrs.stream().map(tr -> tr.getEndMinutes() == null ? 0 : tr.getEndMinutes()).max(Comparator.naturalOrder()).get();
        Integer latestFloatEndMinutes = allVisitTrs.stream().map(tr -> tr.getFloatEnd() == null ? 0 : tr.getFloatEnd()).max(Comparator.naturalOrder()).get();
        int latestEndMinutesAtStartOfDay = latestEndMinutes / 1440 * 1440;
        int latestEnd = latestEndMinutesAtStartOfDay < (latestFloatEndMinutesAtStartOfDay = latestFloatEndMinutes / 1440 * 1440) ? latestFloatEndMinutesAtStartOfDay : latestEndMinutesAtStartOfDay;
        return 1 + latestEnd / 1440;
    }

    public static List<String> allVisitCalendarDayStrings(List<TemplateResource> allVisitTrs) {
        int totalDays = TemplateResource.totalVisitCalendarDays(allVisitTrs);
        LocalDate relativeOrigin = DateUtility.TEMPLATE_RESOURCE_LOCAL_DATE_ORIGIN;
        return Range.from((int)0).to(totalDays).toRichList().map(i -> DateUtility.format(DateUtility.dateMonthYear(), DateUtility.toDate(relativeOrigin.plusDays(i.intValue())))).toList();
    }
}

