/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import java.util.Map;
import java.util.Optional;

public enum UserRoleType {
    STUDY_COORDINATOR_RESEARCH_ASSISTANT(1, "Study Coordinator - Research Asst"),
    PI(2, "PI"),
    CO_INVESTIGATOR(3, "Co-Investigator"),
    OTHER_STAFF(4, "Other Study Staff"),
    NURSE(5, "Nurse"),
    NUTRITIONIST(6, "Nutritionist"),
    ADMINISTRATION(7, "CRC Administration"),
    LAB(8, "Lab"),
    ADMINISTRATIVE_DIRECTOR(9, "Administrative Director"),
    NURSING_MANAGER(10, "Nurse Manager Director"),
    NUTRITION_MANAGER(11, "Nutrition Manager"),
    FINAL_APPROVER(12, "Final Approver"),
    PHYSICIAN(13, "Physician"),
    PHYSICIAN2(14, "Physician2"),
    SCHEDULER(15, "Scheduler"),
    SCHEDULER2(16, "Scheduler2"),
    PROTOCOL_NURSE(17, "Protocol Nurse"),
    ASSOCIATE_NURSE(18, "Associate Nurse"),
    PROTOCOL_NUTRITIONIST(19, "Protocol Nutritionist");

    @Deprecated
    public final int databaseId;
    public final String humanReadableName;

    private UserRoleType(int databaseId, String humanReadableName) {
        this.databaseId = databaseId;
        this.humanReadableName = humanReadableName;
    }

    public static Optional<UserRoleType> fromHumanReadableName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        String lowercaseName = name.toLowerCase();
        return Optional.ofNullable(Holder.byHumanReadableName.get(lowercaseName));
    }

    private static final class Holder {
        static final Map<String, UserRoleType> byHumanReadableName = Holder.makeByHumanReadableNameMap();

        private Holder() {
        }

        private static Map<String, UserRoleType> makeByHumanReadableNameMap() {
            return Pairs.toMap((Iterable)ListUtils.enrich((Object[])UserRoleType.values()).map(role -> Pair.pair((Object)role.humanReadableName.toLowerCase(), (Object)role)));
        }
    }
}

