/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class SubjectConfirmationDataUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)parentSAMLObject;
        subjectCD.getUnknownXMLObjects().add(childSAMLObject);
    }

    @Override
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        SubjectConfirmationData subjectCD = (SubjectConfirmationData)samlObject;
        if (attribute.getLocalName().equals("NotBefore") && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            subjectCD.setNotBefore(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("NotOnOrAfter") && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            subjectCD.setNotOnOrAfter(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("Recipient")) {
            subjectCD.setRecipient(attribute.getValue());
        } else if (attribute.getLocalName().equals("InResponseTo")) {
            subjectCD.setInResponseTo(attribute.getValue());
        } else if (attribute.getLocalName().equals("Address")) {
            subjectCD.setAddress(attribute.getValue());
        } else {
            QName attribQName = XMLHelper.getNodeQName((Node)attribute);
            if (attribute.isId()) {
                subjectCD.getUnknownAttributes().registerID(attribQName);
            }
            subjectCD.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }
}

