/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.Comments;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VisitCommentsResponse {
    public static List<VisitComment> fromTemplateApprovalHistoryList(List<Comments> visitComments) {
        ArrayList<VisitComment> resourceList = new ArrayList<VisitComment>();
        for (Comments comment : visitComments) {
            VisitComment visitComment = new VisitComment(comment);
            resourceList.add(visitComment);
        }
        return resourceList;
    }

    public static class VisitComment {
        private Integer id;
        private String ecommonsId;
        private Date commentDate;
        private String comment;

        VisitComment(Comments comments) {
            if (comments == null) {
                SchedulerRuntimeException.logAndThrow("comments parameter should be non-null");
            }
            this.id = comments.getId();
            this.ecommonsId = comments.getUser().getEcommonsId();
            this.commentDate = comments.getDate();
            this.comment = comments.getComment();
        }
    }
}

