/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import com.google.gson.Gson;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.ResourceDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AppService {
    private final StudyDAO studyDAO;
    private final ResourceDAO resourceDAO;
    private final SubjectDAO subjectDAO;
    private final AuthDAO authDAO;

    @Autowired
    public AppService(StudyDAO studyDAO, ResourceDAO resourceDAO, SubjectDAO subjectDAO, AuthDAO authDAO) {
        this.studyDAO = studyDAO;
        this.resourceDAO = resourceDAO;
        this.subjectDAO = subjectDAO;
        this.authDAO = authDAO;
    }

    AppService() {
        this(null, null, null, null);
    }

    Map<String, List<?>> getStaticListsMap() {
        HashMap map = new HashMap();
        List jsonableVisitTypes = RichList.enrich(this.studyDAO.getVisitTypes()).map(VisitType::toJsonable).toList();
        map.put("visitTypes", jsonableVisitTypes);
        map.put("sublocations", this.resourceDAO.getSublocations());
        map.put("roles", this.studyDAO.getRoles());
        map.put("resources", this.resourceDAO.findResourcesListedInResourceSublocation());
        map.put("rooms", this.resourceDAO.getRooms());
        map.put("institutionRoles", this.studyDAO.getInstitutionRoles());
        map.put("studyStatuses", this.studyDAO.getStudyStatuses());
        map.put("resourceTypes", this.resourceDAO.getResourceTypes());
        map.put("overrideReasons", this.studyDAO.getOverrideReasons());
        map.put("institutions", this.resourceDAO.getInstitutions());
        map.put("irbInstitutions", this.studyDAO.getIRBInstitutions());
        map.put("checkOutReasons", this.studyDAO.getCheckOutReasons());
        map.put("cancellationReasons", this.studyDAO.getCancellationReasons());
        map.put("appointmentStatuses", this.studyDAO.getAppointmentStatuses());
        map.put("states", this.subjectDAO.getStates());
        map.put("races", this.subjectDAO.getRaces());
        map.put("ethnicities", this.subjectDAO.getEthnicities());
        map.put("countries", this.subjectDAO.getCountries());
        map.put("genders", this.subjectDAO.getGenders());
        map.put("visitCancelStatuses", this.studyDAO.getVisitCancelStatuses());
        map.put("fundingSources", this.studyDAO.getFundingSources());
        map.put("credentials", this.authDAO.getCredentials());
        map.put("divisions", this.authDAO.getDivisions());
        map.put("departments", this.authDAO.getDepartments());
        map.put("facultyRanks", this.authDAO.getFacultyRanks());
        map.put("fundingSources", this.authDAO.getFundingSources());
        map.put("centersAndInstitutions", this.authDAO.getCentersAndInstitutions());
        return map;
    }

    public String getStaticLists() {
        Gson gson = new Gson();
        return gson.toJson(this.getStaticListsMap());
    }
}

