/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service.cleanup;

import edu.harvard.catalyst.scheduler.dto.Epic.EmpiSubjectDto;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.service.cleanup.SubjectEmpiFieldMatcher;
import edu.harvard.catalyst.scheduler.util.DateUtility;

public class DobMatcher
extends SubjectEmpiFieldMatcher {
    public DobMatcher(Subject schedulerSubject, EmpiSubjectDto.Patient empiSubject) {
        super(5.0f, schedulerSubject, empiSubject);
    }

    @Override
    SubjectEmpiFieldMatcher.MatchInfo computeMatchInfo(String site) {
        String schedulerDob;
        String empiDob = this.empiSubject.getDobString();
        if (empiDob.equalsIgnoreCase(schedulerDob = DateUtility.format(DateUtility.monthDayYear(), this.schedulerSubject.getBirthdate()))) {
            this.matchInfo.setPoints(Float.valueOf(this.weightedPoints(100.0f)));
            this.matchInfo.setMatchLabel("Exact Match!");
        } else {
            this.matchInfo.setComment(empiDob + " (empi) vs (sched) " + schedulerDob);
            this.matchInfo.setMatchLabel("No Match");
        }
        return this.matchInfo;
    }
}

