/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service.cleanup;

import edu.harvard.catalyst.scheduler.service.cleanup.SubjectEmpiFieldMatcher;
import java.util.List;
import java.util.stream.Collectors;

public class SubjectMatcher {
    List<SubjectEmpiFieldMatcher> fieldMatchers;

    public SubjectMatcher(List<SubjectEmpiFieldMatcher> fieldMatchers) {
        this.fieldMatchers = fieldMatchers;
    }

    public List<SubjectEmpiFieldMatcher> getFieldMatchers() {
        return this.fieldMatchers;
    }

    public void setFieldMatchers(List<SubjectEmpiFieldMatcher> fieldMatchers) {
        this.fieldMatchers = fieldMatchers;
    }

    public List<SubjectEmpiFieldMatcher.MatchInfo> getMatchInfoList(String site) {
        List<SubjectEmpiFieldMatcher.MatchInfo> matchInfoList = this.fieldMatchers.stream().map(fm -> fm.computeMatchInfo(site)).collect(Collectors.toList());
        return matchInfoList;
    }

    public float getMatchPoints(String site) {
        List<SubjectEmpiFieldMatcher.MatchInfo> matchInfoList = this.getMatchInfoList(site);
        float points = 0.0f;
        if (!matchInfoList.isEmpty()) {
            for (SubjectEmpiFieldMatcher.MatchInfo matchInfo : matchInfoList) {
                points += matchInfo.getPoints().floatValue();
            }
            points /= (float)matchInfoList.size();
        }
        return points;
    }
}

