/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import java.util.List;

public final class GetStudyVisitsResponse {
    private final Long totalCount;
    private final Integer studyId;
    private final String studyName;
    private final String localId;
    private final String investigatorFullName;
    final List<VisitTemplate1> visitTemplate1s;

    private GetStudyVisitsResponse(List<VisitTemplate1> visitTemplate1s, Long totalCount, String studyName, String localId, String investigatorName, int studyId) {
        this.totalCount = totalCount;
        this.studyId = studyId;
        this.studyName = studyName;
        this.localId = localId;
        this.investigatorFullName = investigatorName;
        this.visitTemplate1s = visitTemplate1s;
    }

    public static GetStudyVisitsResponse createGetStudyVisitsResponse(List<VisitTemplate> visitTemplates, Long total, String studyName, String localId, String investigatorName, int studyId) {
        List visitTemplate1List = ListUtils.enrich(visitTemplates).map(v -> new VisitTemplate1((VisitTemplate)v)).toList();
        return new GetStudyVisitsResponse(visitTemplate1List, total, studyName, localId, investigatorName, studyId);
    }

    static class VisitTemplate1 {
        private final Integer id;
        private final String name;
        private final Integer visitTypeId;
        private final Integer visitDuration;
        private final boolean relativeTime;

        VisitTemplate1(VisitTemplate visitTemplate) {
            if (visitTemplate == null) {
                SchedulerRuntimeException.logAndThrow("VisitTemplate should not be null!");
            }
            this.id = visitTemplate.getId();
            this.name = visitTemplate.getName();
            this.visitTypeId = visitTemplate.getVisitType().getId();
            this.visitDuration = visitTemplate.getDuration();
            this.relativeTime = visitTemplate.getRelativeTime();
        }
    }
}

