/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.dto.SwitchSubjectResultDTO;
import edu.harvard.catalyst.scheduler.dto.VisitRenderSummaryDTO;
import edu.harvard.catalyst.scheduler.dto.response.BookedResourcesResponse;
import edu.harvard.catalyst.scheduler.dto.response.BookedVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.CalendarVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.OverbookTimelineDataResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceSchedule;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.SublocationClosureInterval;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class AppointmentDAO
extends SiteDAO {
    public static final Integer SCHEDULE_ID = 1;
    private static final Integer CHECKIN_ID = 2;
    private static final Integer CHECKOUT_ID = 3;
    private static final Integer CANCEL_ID = 4;
    protected static final Integer HOLD_ID = 5;
    public static final String SCHEDULED_APPT_STATUS = "Scheduled";
    public static final String CHECKED_IN_APPT_STATUS = "Checked-In";
    public static final String HOLD_APPT_STATUS = "Hold";

    static boolean isAllDay(boolean homeView, String visitType) {
        return homeView && visitType.contains("Inpatient");
    }

    public List<SublocationClosureInterval> findSublocationSchedule(Sublocation sublocation, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocation);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public boolean isSublocationClosed(Sublocation sublocation, Date startDate, Date endDate) {
        String findSublocationClosure = "select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))";
        Query query = this.newQuery("select s FROM SublocationClosureInterval s where s.sublocation = :sublocation AND  ((:startTime >= s.startTime and :startTime < s.endTime)  or (:endTime > s.startTime and :endTime <= s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime))");
        query.setParameter("sublocation", (Object)sublocation);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List list = query.list();
        return !list.isEmpty();
    }

    public List<BookedResource> findOverbookConflictResourcesByVisitStatus(Resource resource, Date startDate, Date endDate) {
        String findBookedResource = "select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime";
        Query query = this.newQuery("select br FROM BookedResource br, BookedVisit bv where  br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and br.resource = :resource  and ((:startTime >= br.scheduledStartTime and :startTime < br.scheduledEndTime)  or (:endTime > br.scheduledStartTime and :endTime <= br.scheduledEndTime)  or (br.scheduledStartTime >= :startTime and br.scheduledEndTime <= :endTime)) ORDER BY br.scheduledStartTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public List<OverbookTimelineDataResponseDTO> getOverbookTimelineData(Date startDate, Date endDate, ResourceType resourceType, List<Integer> sublocations, String orderBy, User user) {
        Object[] columnsArray = new String[]{"resource.id", "resource.name", "bvStart", "bvEnd", "visit_template.name", "user.last_name", "study.local_id", "brStart", "brEnd", "bvId", "subject.first_name", "subject.last_name"};
        String columnSqlList = Joiner.on((String)", ").join(columnsArray);
        String filterBy = sublocations.isEmpty() ? " " : " and resource_sublocation.sublocation IN (" + Joiner.on((String)",").join(sublocations) + ") ";
        String findBookedResource = "SELECT " + columnSqlList + " FROM resource_sublocation, resource LEFT OUTER JOIN (select br.resource, br.id, br.booked_visit, booked_visit.visit_template, booked_visit.id bvId,booked_visit.scheduled_start_time AS bvStart, booked_visit.scheduled_end_time AS bvEnd, br.scheduled_start_time AS brStart, br.scheduled_end_time AS brEnd,booked_visit.study, booked_visit.appointment_status, s.principal_investigator, su.id subjectId from booked_resource br, study s, booked_visit LEFT OUTER JOIN subject_mrn sm ON sm.id = booked_visit.subject_mrn LEFT OUTER JOIN subject su ON su.id = sm.subject WHERE br.booked_visit = booked_visit.id and booked_visit.study = s.id and booked_visit.appointment_status IN (1,2,5) and  ((:startTime between br.scheduled_start_time                   and br.scheduled_end_time)                   or (:endTime between br.scheduled_start_time                  and br.scheduled_end_time)                   or (br.scheduled_start_time > :startTime and                   br.scheduled_end_time < :endTime)) ) AS bookedData ON resource.id = bookedData.resource                 LEFT OUTER JOIN study ON bookedData.study = study.id                 LEFT OUTER JOIN subject ON bookedData.subjectId = subject.id                 LEFT OUTER JOIN visit_template ON bookedData.visit_template = visit_template.id                 LEFT OUTER JOIN user ON bookedData.principal_investigator = user.id                 where resource_sublocation.resource = resource.id and resource.type IN (:resourceType) " + filterBy + "                ORDER BY resource.name " + orderBy + ", bookedData.brStart";
        System.out.println("Running SQL: '" + findBookedResource + "'");
        SQLQuery query = this.newSqlQuery(findBookedResource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("resourceType", (Object)resourceType.getName());
        for (Object column : columnsArray) {
            query.addScalar((String)column);
        }
        List resultRows = query.list();
        long selectedMinutes = startDate.getTime() / 60000L;
        List<Date> selectedDates = DateUtility.dateInterval(startDate, endDate);
        Session session = this.session();
        Ref<Integer> previousResource = new Ref<Integer>(0);
        Function<Object[], OverbookTimelineDataResponseDTO> toOverbookTimelineDataResponseDTO = resultRow -> {
            String subjectFirstName;
            String visit;
            Integer resource = (Integer)resultRow[0];
            String resourceName = (String)resultRow[1];
            Date scheduledStartTime = (Date)resultRow[7];
            Date scheduledEndTime = (Date)resultRow[8];
            Integer bookedVisitId = (Integer)resultRow[9];
            boolean hasBookedVisitId = bookedVisitId != null;
            boolean hasSubjectData = resultRow[10] != null;
            boolean isNewResource = !resource.equals(previousResource.get());
            boolean notStudyStaff = !user.isStudyStaff();
            boolean hasBookedVisitIdAndNotStudyStaff = hasBookedVisitId && notStudyStaff;
            boolean hasBookedVisitIdAndIsNewResource = hasBookedVisitId && isNewResource;
            int rowCount = hasBookedVisitIdAndIsNewResource ? this.getResourceCount(resource, startDate, endDate) : 0;
            long sixtySecondsInMillis = Duration.ofSeconds(60L).toMillis();
            String rooms = hasBookedVisitId ? AppointmentDAO.findRoomString(bookedVisitId, session) : "";
            long startTime = hasBookedVisitId ? scheduledStartTime.getTime() / sixtySecondsInMillis : 0L;
            long endTime = hasBookedVisitId ? scheduledEndTime.getTime() / sixtySecondsInMillis : 0L;
            String piName = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[5] : "";
            String localId = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[6] : "";
            String string = visit = hasBookedVisitIdAndNotStudyStaff ? (String)resultRow[4] : "";
            String string2 = hasSubjectData ? (hasBookedVisitIdAndNotStudyStaff ? SubjectDataEncryptor.decrypt((String)resultRow[10]) : "") : (subjectFirstName = "No Subject Assigned");
            String subjectLastName = hasSubjectData ? (hasBookedVisitIdAndNotStudyStaff ? SubjectDataEncryptor.decrypt((String)resultRow[11]) : "") : "No Subject Assigned";
            String visitHoverStartTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[2]);
            String visitHoverEndTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[3]);
            String resourceHoverStartTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[7]);
            String resourceHoverEndTime = DateUtility.format(DateUtility.dateTime(), (Date)resultRow[8]);
            String alternateResources = isNewResource ? this.findAlternateResourcesString(resource) : "";
            ArrayList<Map<String, String>> defaultResourceSchedule = isNewResource ? this.getDefaultResourceSchedule(selectedDates, resource) : new ArrayList();
            ArrayList<Map<String, String>> temporaryResourceSchedule = isNewResource ? this.getTemporaryResourceSchedule(startDate, endDate, resource) : new ArrayList<Map<String, String>>();
            OverbookTimelineDataResponseDTO overbookTimeLineData = new OverbookTimelineDataResponseDTO(resource, resourceName, rooms, visitHoverStartTime, visitHoverEndTime, resourceHoverStartTime, resourceHoverEndTime, visit, piName, localId, subjectFirstName, subjectLastName, startTime, endTime, selectedMinutes, defaultResourceSchedule, temporaryResourceSchedule, alternateResources, rowCount);
            previousResource.set(resource);
            return overbookTimeLineData;
        };
        return RichList.enrich((List)resultRows).map(toOverbookTimelineDataResponseDTO).toList();
    }

    private List<Map<String, String>> getDefaultResourceSchedule(List<Date> selectedDates, Integer resource) {
        List dayOfWeeks = RichList.enrich(selectedDates).map(date -> DateUtility.getDayOfTheWeek(date)).toList();
        List defaultSchedules = RichList.enrich((List)dayOfWeeks).flatMapList(day -> this.findResourceScheduleByResource(resource, (Integer)day, false)).toList();
        Function<ResourceSchedule, Map> toDefaultScheduleMap = schedule -> Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"defaultScheduleTime", (Object)(DateUtility.retrieveDayOfWeek(schedule.getDayOfWeek()) + ": " + DateUtility.format(DateUtility.clockHourMin(), schedule.getStartTime()) + " - " + DateUtility.format(DateUtility.clockHourMin(), schedule.getEndTime()))), Pair.pair((Object)"defaultScheduleQuantity", (Object)String.valueOf(schedule.getQuantity()))});
        return RichList.enrich((List)defaultSchedules).map(toDefaultScheduleMap).toList();
    }

    private List<Map<String, String>> getTemporaryResourceSchedule(Date startDate, Date endDate, Integer resource) {
        List<ResourceSchedule> exceptionSchedules = this.findExceptionSchedule(resource, startDate, endDate, true);
        Function<ResourceSchedule, Map> toExceptionScheduleMap = schedule -> Pairs.toMap((Pair[])new Pair[]{Pair.pair((Object)"exceptionScheduleTime", (Object)(DateUtility.format(DateUtility.dateTime(), schedule.getStartTime()) + " - " + DateUtility.format(DateUtility.dateTime(), schedule.getEndTime()))), Pair.pair((Object)"exceptionScheduleQuantity", (Object)String.valueOf(schedule.getQuantity()))});
        return RichList.enrich(exceptionSchedules).map(toExceptionScheduleMap).toList();
    }

    private int getResourceCount(int resource, Date startDate, Date endDate) {
        String findResourceCount = "SELECT br FROM BookedResource br, BookedVisit bv, Resource r  WHERE r.id = :resource AND br.resource = r.id and br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and     ((:startTime between br.scheduledStartTime                   and br.scheduledEndTime)                   or (:endTime between br.scheduledStartTime                  and br.scheduledEndTime)                   or (br.scheduledStartTime > :startTime and                   br.scheduledEndTime < :endTime)) ORDER BY br.scheduledStartTime ";
        Query query = this.newQuery("SELECT br FROM BookedResource br, BookedVisit bv, Resource r  WHERE r.id = :resource AND br.resource = r.id and br.bookedVisit = bv.id and bv.appointmentStatus IN (1,2,5) and     ((:startTime between br.scheduledStartTime                   and br.scheduledEndTime)                   or (:endTime between br.scheduledStartTime                  and br.scheduledEndTime)                   or (br.scheduledStartTime > :startTime and                   br.scheduledEndTime < :endTime)) ORDER BY br.scheduledStartTime ");
        query.setParameter("resource", (Object)resource);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        List dateRangeList = query.list();
        return this.isOverlappingDates(dateRangeList);
    }

    public int isOverlappingDates(List<BookedResource> dateRangeList) {
        int rowCount = 0;
        Date latestEndTimeRow1 = dateRangeList.get(0).getScheduledEndTime();
        Date latestEndTimeRow2 = dateRangeList.get(0).getScheduledEndTime();
        for (int index1 = 1; index1 < dateRangeList.size(); ++index1) {
            Date startDate = dateRangeList.get(index1).getScheduledStartTime();
            Date endDate = dateRangeList.get(index1).getScheduledEndTime();
            if (startDate.getTime() >= latestEndTimeRow1.getTime()) {
                latestEndTimeRow1 = endDate;
                if (rowCount != 0) continue;
                latestEndTimeRow2 = endDate;
                continue;
            }
            if (startDate.getTime() < latestEndTimeRow1.getTime() && startDate.getTime() < latestEndTimeRow2.getTime()) {
                latestEndTimeRow2 = endDate;
                ++rowCount;
                continue;
            }
            if (startDate.getTime() >= latestEndTimeRow2.getTime()) {
                latestEndTimeRow2 = endDate;
                continue;
            }
            if (startDate.getTime() >= latestEndTimeRow2.getTime()) continue;
            latestEndTimeRow2 = endDate;
            ++rowCount;
        }
        return rowCount;
    }

    public List<ResourceSchedule> findExceptionSchedule(Integer resourceId, Date startDate, Date endDate, boolean override) {
        Resource resource = this.findById(Resource.class, resourceId);
        String findExceptionSchedule = "SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND  s.override = :override  AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime";
        Query query = this.session().createQuery("SELECT s FROM ResourceSchedule s WHERE s.resource = :resource AND  s.override = :override  AND  ((:startTime between s.startTime and s.endTime)  or (:endTime between s.startTime and s.endTime)  or (s.startTime >= :startTime and s.endTime <= :endTime)) ORDER BY s.startTime");
        query.setParameter("resource", (Object)resource);
        query.setParameter("override", (Object)override);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list();
    }

    public String findAlternateResourcesString(Integer resourceId) {
        Resource resource = this.findById(Resource.class, resourceId);
        String hql = "select ra.alternateResource.name from ResourceAlternate ra where ra.sourceResource = :resource order by ra.alternateResource.name";
        Query query = this.newQuery("select ra.alternateResource.name from ResourceAlternate ra where ra.sourceResource = :resource order by ra.alternateResource.name");
        query.setParameter("resource", (Object)resource);
        List list = query.list();
        return Joiner.on((String)", ").join((Iterable)list);
    }

    public List<ResourceSchedule> findResourceScheduleByResource(Integer resourceId, Integer dayOfWeek, boolean override) {
        Resource resource = this.findById(Resource.class, resourceId);
        Criteria criteria = this.newCriteria(ResourceSchedule.class);
        criteria.add((Criterion)Restrictions.eq((String)"resource", (Object)resource));
        criteria.add((Criterion)Restrictions.eq((String)"dayOfWeek", (Object)dayOfWeek));
        criteria.add((Criterion)Restrictions.eq((String)"override", (Object)override));
        criteria.addOrder(Order.asc((String)"startTime"));
        return criteria.list();
    }

    public TemplateResource findTemplateResourceById(int id) {
        return this.findById(TemplateResource.class, id);
    }

    public CancellationStatus findCancellationStatusById(int id) {
        return this.findById(CancellationStatus.class, id);
    }

    public AppointmentStatus findScheduledStatus() {
        return this.findById(SCHEDULE_ID);
    }

    public AppointmentStatus findById(int id) {
        return this.findById(AppointmentStatus.class, id);
    }

    public AppointmentStatus findHoldStatus() {
        return this.findById(HOLD_ID);
    }

    public TemplateResourceGroup findTemplateResourceGroup(TemplateResource templateResource) {
        VisitTemplate visit = templateResource.getVisitTemplate();
        String groupId = templateResource.getGroupId();
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"visit", (Object)visit));
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        criteria.add((Criterion)Restrictions.eq((String)"groupId", (Object)groupId));
        List result = criteria.list();
        return (TemplateResourceGroup)result.get(0);
    }

    public List<TemplateResourceGroup> findTrgListByGroupId(String group) {
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"groupId", (Object)group));
        return criteria.list();
    }

    public List<TemplateResourceAnnotations> findTemplateResourceAnnotationsByTemplateResource(TemplateResource templateResource) {
        Criteria criteria = this.newCriteria(TemplateResourceAnnotations.class);
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        return criteria.list();
    }

    public AppointmentStatus findCheckedInStatus() {
        Criteria criteria = this.newCriteria(AppointmentStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)CHECKIN_ID));
        return (AppointmentStatus)criteria.uniqueResult();
    }

    public AppointmentStatus findCheckedOutStatus() {
        Criteria criteria = this.newCriteria(AppointmentStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)CHECKOUT_ID));
        return (AppointmentStatus)criteria.uniqueResult();
    }

    public AppointmentStatus findCancelledStatus() {
        Criteria criteria = this.newCriteria(AppointmentStatus.class);
        criteria.add((Criterion)Restrictions.eq((String)"id", (Object)CANCEL_ID));
        return (AppointmentStatus)criteria.uniqueResult();
    }

    public List<BookedResource> findBookedResourcesByBookedVisit(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        return query.list();
    }

    public Date findLatestBookedResourcesByBookedVisit(BookedVisit bookedVisit) {
        String findBookedVisit = "SELECT a.scheduledEndTime FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledEndTime DESC";
        Query query = this.newQuery("SELECT a.scheduledEndTime FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledEndTime DESC");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setFirstResult(0);
        query.setMaxResults(1);
        return (Date)query.uniqueResult();
    }

    public boolean findBookedResourcesByBookedVisit(TemplateResource templateResource) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE  a.templateResource = :templateResource ";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.templateResource = :templateResource ");
        query.setParameter("templateResource", (Object)templateResource);
        return query.list().size() > 0;
    }

    public BookedResource findBookedResourceById(Integer id) {
        return this.findById(BookedResource.class, id);
    }

    public AppointmentOverrideReason findAppointmentOverrideReasonById(Integer id) {
        return this.findById(AppointmentOverrideReason.class, id);
    }

    public AppointmentStatusReason findAppointmentStatusReasonById(Integer id) {
        return this.findById(AppointmentStatusReason.class, id);
    }

    public List<VisitCommentsResponse.VisitComment> findAppointmentCommentsByVisit(BookedVisit visit) {
        Criteria criteria = this.newCriteria(Comments.class);
        criteria.add((Criterion)Restrictions.eq((String)"bookedVisit", (Object)visit));
        return VisitCommentsResponse.fromTemplateApprovalHistoryList(criteria.list());
    }

    public List<TemplateResource> getSingleFloatTemplateResources(VisitTemplate selectedVisit) {
        String findFloatTemplateResource = "SELECT tr FROM TemplateResource tr WHERE tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr WHERE tr.visitTemplate = :visit AND tr.floatable = true AND tr.groupId IS NULL ");
        query.setParameter("visit", (Object)selectedVisit);
        return query.list();
    }

    public List<TemplateResourceGroup> getTemplateResourceGroups(VisitTemplate selectedVisit, boolean isGrouped) {
        String findTemplateResourceGroups = "SELECT trg FROM TemplateResourceGroup trg WHERE trg.visit = :visit AND trg.flexGroup = :flexGroup ";
        Query query = this.newQuery("SELECT trg FROM TemplateResourceGroup trg WHERE trg.visit = :visit AND trg.flexGroup = :flexGroup ");
        query.setParameter("visit", (Object)selectedVisit);
        query.setParameter("flexGroup", (Object)isGrouped);
        return query.list();
    }

    public BookedResource findOrderedBookedResource(BookedVisit bookedVisit, String columnSort, String orderBy) {
        String findBookedVisit = "SELECT a FROM BookedResource a WHERE a.bookedVisit = :bookedVisit order by " + columnSort + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setFirstResult(0);
        query.setMaxResults(1);
        List brs = query.list();
        return (BookedResource)brs.get(0);
    }

    public List<BookedResource> findRoomBookedResourcesByBookedVisit(int bookedVisit) {
        String findBookedVisit = "SELECT a FROM BookedResource a, Resource r, BookedVisit bv  WHERE a.bookedVisit = bv.id and bv.id = :bookedVisit and a.resource = r.id and r.resourceType = 'Room'";
        Query query = this.newQuery("SELECT a FROM BookedResource a, Resource r, BookedVisit bv  WHERE a.bookedVisit = bv.id and bv.id = :bookedVisit and a.resource = r.id and r.resourceType = 'Room'");
        query.setParameter("bookedVisit", (Object)bookedVisit);
        return query.list();
    }

    public List<BookedResourcesResponse> getBookedResourcesListByBookedVisit(int bookedVisit, String sortBy, String orderBy, int page, int maxResults) {
        String sortOn = sortBy;
        if (sortBy.equalsIgnoreCase("br.scheduled_start_time")) {
            sortOn = " br.scheduled_start_time " + orderBy + ", br.scheduled_end_time ";
        } else if (sortBy.equalsIgnoreCase("br.scheduled_end_time")) {
            sortOn = " br.scheduled_end_time " + orderBy + ", br.scheduled_start_time ";
        }
        String findBookedVisit = "SELECT br.id, r.name, group_concat(lla.name separator ', '), br.scheduled_start_time, br.scheduled_end_time  FROM booked_visit bv, resource r, booked_resource br  LEFT OUTER JOIN override_booked_resource_annotations obra ON obra.booked_resource = br.id  LEFT OUTER JOIN line_level_annotations lla ON obra.line_level_annotations = lla.id  WHERE br.booked_visit = bv.id and bv.id = :bookedVisit and br.resource = r.id  group by br.id order by " + sortOn + " " + orderBy;
        SQLQuery query = this.newSqlQuery(findBookedVisit);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        int offSet = (page - 1) * maxResults;
        query.setFirstResult(offSet);
        query.setMaxResults(maxResults);
        List resultRows = query.list();
        ArrayList bookedResourcesResponseDTOs = Lists.newArrayList();
        Long total = this.findBookedResourcesCount(bookedVisit);
        for (Object[] row : resultRows) {
            Integer bookedResource = (Integer)row[0];
            String resourceName = (String)row[1];
            String annotations = (String)row[2];
            Date scheduledStartTime = (Date)row[3];
            Date scheduledEndTime = (Date)row[4];
            BookedResourcesResponse bookedResourcesResponseDTO = new BookedResourcesResponse(bookedResource, resourceName, annotations, scheduledStartTime, scheduledEndTime, "", "", "", total, false);
            bookedResourcesResponseDTOs.add(bookedResourcesResponseDTO);
        }
        return bookedResourcesResponseDTOs;
    }

    Long findBookedResourcesCount(int bookedVisit) {
        String findCount = "SELECT count(br.id) FROM BookedResource br  WHERE br.bookedVisit.id = :bookedVisit";
        Query query = this.newQuery("SELECT count(br.id) FROM BookedResource br  WHERE br.bookedVisit.id = :bookedVisit").setParameter("bookedVisit", (Object)bookedVisit);
        return (Long)query.uniqueResult();
    }

    public static String findRoomString(int visit, Session session) {
        String hql = "select br.resource.name from BookedResource br where br.bookedVisit.id = :visit and br.resource.resourceType = 'Room' order by br.resource.name ASC";
        Query query = session.createQuery("select br.resource.name from BookedResource br where br.bookedVisit.id = :visit and br.resource.resourceType = 'Room' order by br.resource.name ASC");
        query.setParameter("visit", (Object)visit);
        List list = query.list();
        return Joiner.on((String)", ").join((Iterable)list);
    }

    public boolean canUserSeeBookedVisit(User user, Integer bookedVisitId) {
        boolean result = true;
        if (user.isStudyStaff()) {
            Query query = this.newQuery("select bv from Study s, StudyUser su, BookedVisit bv  where s.id = su.study    and :user = su.user    and bv.study = s.id    and bv.id = :bvId    and su.active=true    and s.studyStatus !=3");
            query.setParameter("user", (Object)user);
            query.setParameter("bvId", (Object)bookedVisitId);
            BookedVisit bookedVisit = (BookedVisit)query.uniqueResult();
            if (bookedVisit == null) {
                result = false;
            }
        }
        return result;
    }

    public List<CalendarVisitsResponse> getCalendarBookedVisits(String filterString, Date startDate, Date endDate, boolean homeView, List<Study> studies, boolean isStudyStaff) {
        boolean filterStringIsPresent;
        if (isStudyStaff && (studies == null || studies.isEmpty())) {
            return Lists.newArrayList();
        }
        String findBookedVisit = "select bv FROM BookedVisit bv  where (bv.appointmentStatus IN (1,2,3,5) OR  (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) ";
        boolean bl = filterStringIsPresent = filterString != null && !filterString.isEmpty();
        if (filterStringIsPresent) {
            findBookedVisit = findBookedVisit + " and bv.visitTemplate.sublocation.name = :sublocation ";
        }
        if (isStudyStaff) {
            findBookedVisit = findBookedVisit + " and bv.study IN (:studies) ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id ";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (filterStringIsPresent) {
            query.setParameter("sublocation", (Object)filterString);
        }
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        if (isStudyStaff) {
            query.setParameterList("studies", studies);
        }
        return AppointmentDAO.bookedVisitsDTO(homeView, query, session);
    }

    public List<CalendarVisitsResponse> findBookedVisitsByResource(String resource, User user, List<Study> studies, Date startDate, Date endDate, boolean homeView) {
        String columnHqlList = CalendarBookedVisitsColumn.columnHqlList;
        String findBookedVisit = this.getCalendarBookedVisitsQueryHql(columnHqlList);
        if (studies != null && (!studies.isEmpty() && !user.isStudyStaff() || user.isStudyStaff())) {
            findBookedVisit = findBookedVisit + " and bv.study in (:studies)";
        }
        findBookedVisit = findBookedVisit + " and br.resource.name = :resource GROUP BY bv.id ";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        if (studies != null && (!studies.isEmpty() && !user.isStudyStaff() || user.isStudyStaff())) {
            query.setParameterList("studies", studies);
        }
        query.setParameter("resource", (Object)resource);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return AppointmentDAO.getCalendarVisitsDTOs(homeView, query, session);
    }

    public List<CalendarVisitsResponse> findBookedVisitsByApppointmentStatus(int appointmentStatusId, Date startDate, Date endDate, boolean homeView, List<Study> studies, boolean isStudyStaff) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.appointmentStatus.id IN (:appointmentStatus) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) ";
        if (studies != null && !studies.isEmpty()) {
            findBookedVisit = findBookedVisit + " and bv.study in (:studies)";
        }
        if (CANCEL_ID.equals(appointmentStatusId)) {
            findBookedVisit = findBookedVisit + " and (bv.cancelDate >= :dayBeforeYesterday)";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id ";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameter("appointmentStatus", (Object)appointmentStatusId);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (isStudyStaff) {
            query.setParameterList("studies", studies);
        }
        if (CANCEL_ID.equals(appointmentStatusId)) {
            Date twoDaysAgo = this.getDayBeforeYesterday();
            query.setParameter("dayBeforeYesterday", (Object)twoDaysAgo);
        }
        return AppointmentDAO.bookedVisitsDTO(homeView, query, session);
    }

    static List<CalendarVisitsResponse> bookedVisitsDTO(boolean homeView, Query query, Session session) {
        List resultRows = query.list();
        ArrayList results = Lists.newArrayList();
        for (BookedVisit bv : resultRows) {
            Integer eventId = bv.getId();
            String appointmentStatus = bv.getAppointmentStatus().getName();
            String localId = bv.getStudy().getLocalId();
            String piLastName = bv.getStudy().getInvestigator() != null ? bv.getStudy().getInvestigator().getLastName() : "";
            String visitName = bv.getVisitTemplate().getName();
            String subjectLastName = bv.getSubjectMrn() == null ? "No Subject Assigned" : bv.getSubjectMrnDecrypted().getSubject().getLastName();
            String scheduledStartTime = DateUtility.format(DateUtility.dateHourMinSec(), bv.getScheduledStartTime());
            String scheduledEndTime = DateUtility.format(DateUtility.dateHourMinSec(), bv.getScheduledEndTime());
            String visitType = bv.getVisitType().getName();
            String rooms = AppointmentDAO.findRoomString(eventId, session);
            boolean allDay = AppointmentDAO.isAllDay(homeView, visitType);
            CalendarVisitsResponse r = new CalendarVisitsResponse(eventId, visitName, piLastName, rooms, localId, subjectLastName, appointmentStatus, scheduledStartTime, scheduledEndTime, allDay, visitType.contains("Inpatient"));
            results.add(r);
        }
        return results;
    }

    public List<CalendarVisitsResponse> findAllBookedVisitsByStudy(List<Study> study, Date startDate, Date endDate, boolean homeView) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.study IN (:study) and  ((bv.appointmentStatus.id IN (1,2,3,5)) OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) GROUP BY bv.id";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameterList("study", study);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return AppointmentDAO.bookedVisitsDTO(homeView, query, session);
    }

    public List<CalendarVisitsResponse> findAllBookedVisitsBySubject(User user, List<Study> studyList, List<Subject> subject, Date startDate, Date endDate, boolean homeView) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.subjectMrn is not NULL and bv.subjectMrn.subject IN (:subjectList) and  ((bv.appointmentStatus.id IN (1,2,3)) OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) ";
        if (user.isStudyStaff()) {
            findBookedVisit = findBookedVisit + " and bv.study in (:studyList) ";
        }
        findBookedVisit = findBookedVisit + " GROUP BY bv.id";
        Session session = this.session();
        Query query = session.createQuery(findBookedVisit);
        query.setParameterList("subjectList", subject);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        if (user.isStudyStaff()) {
            query.setParameterList("studyList", studyList);
        }
        return AppointmentDAO.bookedVisitsDTO(homeView, query, session);
    }

    static List<CalendarVisitsResponse> getCalendarVisitsDTOs(boolean homeView, Query query, Session session) {
        List resultRows = query.list();
        Function<Object[], CalendarVisitsResponse> toCalendarVisitsResponse = resultRow -> {
            String resultSubjectLastName = resultRow[5] == null ? "No Subject Assigned" : SubjectDataEncryptor.decrypt((String)resultRow[5]);
            Integer eventId = (Integer)resultRow[0];
            String appointmentStatus = (String)resultRow[1];
            String localId = (String)resultRow[2];
            String userLastName = (String)resultRow[3];
            String piLastName = userLastName != null ? userLastName : "";
            String visitName = (String)resultRow[4];
            String subjectLastName = resultSubjectLastName;
            String scheduledStartTime = DateUtility.format(DateUtility.dateHourMinSec(), (Date)resultRow[6]);
            String scheduledEndTime = DateUtility.format(DateUtility.dateHourMinSec(), (Date)resultRow[7]);
            String visitType = resultRow[8] instanceof VisitType ? ((VisitType)resultRow[8]).getName() : VisitType.valueOf((String)resultRow[8]).getName();
            String rooms = AppointmentDAO.findRoomString(eventId, session);
            boolean allDay = AppointmentDAO.isAllDay(homeView, visitType);
            return new CalendarVisitsResponse(eventId, visitName, piLastName, rooms, localId, subjectLastName, appointmentStatus, scheduledStartTime, scheduledEndTime, allDay, visitType.contains("Inpatient"));
        };
        return RichList.enrich((List)resultRows).map(toCalendarVisitsResponse).toList();
    }

    private String getCalendarBookedVisitsQueryHql(String columnHqlList) {
        return "SELECT " + columnHqlList + " FROM BookedVisit bv JOIN bv.study s LEFT JOIN s.investigator u LEFT JOIN bv.subjectMrn sm LEFT JOIN sm.subject subj, BookedResource br, AppointmentStatus apSt, VisitTemplate vt, Sublocation sub WHERE br.bookedVisit = bv.id and bv.visitTemplate = vt.id and bv.appointmentStatus = apSt.id and vt.sublocation = sub.id and  ((apSt.id IN (1,2,3,5)) OR (apSt.id = 4 AND bv.cancelDate > :dayBeforeDate))  and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisits(Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults) {
        String findBookedVisit = "select bv FROM BookedVisit bv where  ((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeYesterday)) and  ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))  order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("dayBeforeYesterday", (Object)this.getDayBeforeYesterday());
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        return this.bookedVisitsResponses(page - 1, query, total);
    }

    public List<BookedVisitsResponse> getOnlyTodaysBookedVisitsByStudy(List<Study> study, Date startDate, Date endDate, String sortBy, String orderBy, int page, int maxResults) {
        String findBookedVisit = "select bv  FROM BookedVisit bv  where bv.study IN (:studies) and ((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus = 4 AND bv.cancelDate > :dayBeforeDate))  and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime)) order by " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameterList("studies", study);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        Long total = query.list().size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        return this.bookedVisitsResponses(page - 1, query, total);
    }

    public List<BookedVisitsResponse> findAllBookedVisitsByStudyStaff(List<Study> study, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        String findBookedVisit = "select bv FROM BookedVisit bv where bv.study in (:study) and ((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate)) ";
        if (!initialLoad && fromDate != null) {
            findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        }
        findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameterList("study", study);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        int ofPage = this.getOfPage(study, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate, query);
        return this.getCalendarBookedVisitsResponses(maxResults, query, ofPage);
    }

    private int getOfPage(List<Study> study, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate, Query query) {
        int ofPage;
        if (initialLoad) {
            ofPage = (int)((this.getBookedVisitRowOffsetByStudy(study, toDate, sortBy, orderBy) + 1L) / (long)maxResults);
        } else {
            if (fromDate != null) {
                query.setParameter("startTime", (Object)fromDate);
                query.setParameter("endTime", (Object)toDate);
            }
            ofPage = page - 1;
        }
        return ofPage;
    }

    public List<BookedVisitsResponse> getAllBookedVisits(String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        int ofPage;
        String findBookedVisit = "select bv FROM BookedVisit bv where ((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate)) ";
        if (!initialLoad && fromDate != null) {
            findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
        }
        findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisit);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        if (initialLoad) {
            ofPage = (int)((this.getBookedVisitRowOffset(toDate, sortBy, orderBy) + 1L) / (long)maxResults);
        } else {
            if (fromDate != null) {
                query.setParameter("startTime", (Object)fromDate);
                query.setParameter("endTime", (Object)toDate);
            }
            ofPage = page - 1;
        }
        return this.getCalendarBookedVisitsResponses(maxResults, query, ofPage);
    }

    private List<BookedVisitsResponse> getCalendarBookedVisitsResponses(int maxResults, Query query, int ofPage) {
        Long total = query.list().size();
        int offset = ofPage * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        return this.bookedVisitsResponses(ofPage, query, total);
    }

    private List<BookedVisitsResponse> bookedVisitsResponses(int page, Query query, Long total) {
        List resultRows = query.list();
        ArrayList results = Lists.newArrayList();
        for (BookedVisit bv : resultRows) {
            String visitName = bv.getVisitTemplate().getName();
            String irb = bv.getStudy().getIrb();
            String catId = bv.getStudy().getCatalystId();
            String localId = bv.getStudy().getLocalId();
            SubjectMrn subjectMrn = bv.getSubjectMrnDecrypted();
            String subjectFullName = subjectMrn == null ? "No Subject Assigned" : subjectMrn.getSubject().getLastName() + ", " + subjectMrn.getSubject().getFirstName();
            String subjectMrnCode = subjectMrn == null ? "N/A" : subjectMrn.getMrn();
            String apptStatusName = bv.getAppointmentStatus().getName();
            Date scheduledStartTime = bv.getScheduledStartTime();
            Date scheduledEndTime = bv.getScheduledEndTime();
            BookedVisitsResponse result = new BookedVisitsResponse(bv.getId(), visitName, irb, catId, localId, subjectFullName, subjectMrnCode, apptStatusName, scheduledStartTime, scheduledEndTime, total, page);
            results.add(result);
        }
        return results;
    }

    private Long getBookedVisitRowOffset(Date toDate, String sortBy, String orderBy) {
        String findBookedVisitOffset = "SELECT COUNT(bv) FROM BookedVisit bv WHERE (((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate)) AND bv.scheduledStartTime < (:today))  ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisitOffset);
        query.setParameter("today", (Object)toDate);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        return (Long)query.uniqueResult();
    }

    private Long getBookedVisitRowOffsetByStudy(List<Study> studyList, Date toDate, String sortBy, String orderBy) {
        String findBookedVisitOffset = "SELECT COUNT(bv) FROM BookedVisit bv WHERE (((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate)) AND bv.study IN (:studies) AND bv.scheduledStartTime < (:today))  ORDER BY " + sortBy + " " + orderBy;
        Query query = this.newQuery(findBookedVisitOffset);
        query.setParameter("today", (Object)toDate);
        query.setParameterList("studies", studyList);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        return (Long)query.uniqueResult();
    }

    private Long getBookedVisitRowOffsetByStudySubject(List<StudySubject> studySubjectList, Date toDate, String sortBy, String orderBy, boolean isStudyStaff, List<Study> studyList) {
        String findBookedVisitOffset = "SELECT COUNT(bv) FROM BookedVisit bv WHERE (((bv.appointmentStatus.id IN (1,2,3,5))  OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate))  AND bv.subjectMrn IN (:subjectMrns) AND bv.scheduledStartTime < (:today)) ";
        if (isStudyStaff) {
            findBookedVisitOffset = findBookedVisitOffset + " AND bv.study IN (:studyList) ";
        }
        findBookedVisitOffset = findBookedVisitOffset + " ORDER BY " + sortBy + " " + orderBy;
        List subjectMrnList = studySubjectList.stream().map(ss -> ss.getSubjectMrn()).collect(Collectors.toList());
        Query query = this.newQuery(findBookedVisitOffset);
        query.setParameter("today", (Object)toDate);
        query.setParameterList("subjectMrns", subjectMrnList);
        query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
        if (isStudyStaff) {
            query.setParameterList("studyList", studyList);
        }
        return (Long)query.uniqueResult();
    }

    public List<BookedVisitsResponse> getBookedVisitsListByStudy(List<Study> study, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate) {
        if (study.size() > 0) {
            String findBookedVisit = "select bv FROM BookedVisit bv where bv.study in (:study) and ((bv.appointmentStatus.id IN (1,2,3,5)) OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate)) ";
            if (!initialLoad && fromDate != null) {
                findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
            }
            findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
            Query query = this.newQuery(findBookedVisit);
            query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
            query.setParameterList("study", study);
            int ofPage = this.getOfPage(study, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate, query);
            return this.getCalendarBookedVisitsResponses(maxResults, query, ofPage);
        }
        return null;
    }

    public List<BookedVisitsResponse> getBookedVisitsListBySubject(List<Subject> subjects, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate, boolean isStudyStaff) {
        ArrayList totalStudySubjectList = Lists.newArrayList();
        subjects.stream().forEach(subject -> {
            List<StudySubject> studySubjectListBySubject = this.findStudySubjectBySubject((Subject)subject);
            totalStudySubjectList.addAll(studySubjectListBySubject);
        });
        return this.getListOfBookedVisitBySubjects(totalStudySubjectList, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate, isStudyStaff, Lists.newArrayList());
    }

    public List<BookedVisitsResponse> getBookedVisitsListBySubjectAndStudy(List<Study> studies, List<Subject> subjectList, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate, boolean isStudyStaff) {
        List totalStudySubjectList = RichList.enrich(subjectList).flatMap(subject -> RichList.enrich((List)studies).flatMap(study -> RichList.enrich(this.findStudySubjectBySubjectAndStudy((Subject)subject, (Study)study)))).toList();
        return this.getListOfBookedVisitBySubjects(totalStudySubjectList, sortBy, orderBy, page, maxResults, initialLoad, fromDate, toDate, isStudyStaff, studies);
    }

    public List<StudySubject> findStudySubjectBySubject(Subject subject) {
        String findStudySubjectQueryString = "FROM StudySubject ss WHERE ss.subjectMrn.subject = :subject ";
        Query query = this.newQuery(findStudySubjectQueryString);
        query.setParameter("subject", (Object)subject);
        return query.list();
    }

    public List<StudySubject> findStudySubjectBySubjectAndStudy(Subject subject, Study study) {
        String findStudySubjectQueryString = "FROM StudySubject ss WHERE ss.study = :study and ss.subjectMrn.subject = :subject ";
        Query query = this.newQuery(findStudySubjectQueryString);
        query.setParameter("subject", (Object)subject);
        query.setParameter("study", (Object)study);
        return query.list();
    }

    public List<BookedVisitsResponse> getListOfBookedVisitBySubjects(List<StudySubject> studySubjects, String sortBy, String orderBy, int page, int maxResults, boolean initialLoad, Date fromDate, Date toDate, boolean isStudyStaff, List<Study> studyList) {
        if (studySubjects != null && !studySubjects.isEmpty()) {
            int ofPage;
            boolean hasFromDate;
            List subjectMrnList = studySubjects.stream().map(ss -> ss.getSubjectMrn()).collect(Collectors.toList());
            String findBookedVisit = "select bv.id, bv.visitTemplate.name, bv.study.irb, bv.study.catalystId, bv.study.localId,  sm.subject.firstName, sm.subject.lastName, sm.mrn, bv.appointmentStatus.name, bv.scheduledStartTime, bv.scheduledEndTime FROM BookedVisit bv, SubjectMrn sm where bv.subjectMrn = sm.id and bv.subjectMrn in (:subjectMrnList) and ((bv.appointmentStatus.id IN (1,2,3)) OR (bv.appointmentStatus.id = 4 AND bv.cancelDate > :dayBeforeDate)) ";
            boolean bl = hasFromDate = fromDate != null;
            if (isStudyStaff) {
                findBookedVisit = findBookedVisit + " AND bv.study in (:studyList) ";
            }
            if (!initialLoad && hasFromDate) {
                findBookedVisit = findBookedVisit + " and ((:startTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (:endTime between bv.scheduledStartTime and bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime and bv.scheduledEndTime <= :endTime))";
            }
            findBookedVisit = findBookedVisit + " ORDER BY " + sortBy + " " + orderBy;
            Query query = this.newQuery(findBookedVisit);
            query.setParameter("dayBeforeDate", (Object)this.getDayBeforeYesterday());
            query.setParameterList("subjectMrnList", subjectMrnList);
            if (isStudyStaff) {
                query.setParameterList("studyList", studyList);
            }
            if (initialLoad) {
                ofPage = (int)((this.getBookedVisitRowOffsetByStudySubject(studySubjects, toDate, sortBy, orderBy, isStudyStaff, studyList) + 1L) / (long)maxResults);
            } else {
                if (hasFromDate) {
                    query.setParameter("startTime", (Object)fromDate);
                    query.setParameter("endTime", (Object)toDate);
                }
                ofPage = page - 1;
            }
            return this.getBookedVisitsResponses(ofPage, maxResults, query);
        }
        return null;
    }

    private List<BookedVisitsResponse> getBookedVisitsResponses(int page, int maxResults, Query query) {
        Long total = query.list().size();
        int offset = page * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultRows = query.list();
        Function<Object[], BookedVisitsResponse> toBookedVisitsResponse = resultRow -> {
            Integer bvId = (Integer)resultRow[0];
            String visitName = (String)resultRow[1];
            String irb = (String)resultRow[2];
            String catId = (String)resultRow[3];
            String localId = (String)resultRow[4];
            String subjectFirstName = SubjectDataEncryptor.decrypt((String)resultRow[5]);
            String subjectLastName = SubjectDataEncryptor.decrypt((String)resultRow[6]);
            String subjectMrn = SubjectDataEncryptor.decrypt((String)resultRow[7]);
            String apptStatusName = (String)resultRow[8];
            Date scheduledStartTime = (Date)resultRow[9];
            Date scheduledEndTime = (Date)resultRow[10];
            return new BookedVisitsResponse(bvId, visitName, irb, catId, localId, subjectLastName + ", " + subjectFirstName, subjectMrn, apptStatusName, scheduledStartTime, scheduledEndTime, total, page);
        };
        return RichList.enrich((List)resultRows).map(toBookedVisitsResponse).toList();
    }

    public boolean subjectHasBookedVisitInDateRange(Integer subject, Date startDate, Date endDate) {
        String findBookedVisit = "SELECT bv.id FROM BookedVisit bv, Subject s, SubjectMrn sm  WHERE   bv.subjectMrn = sm.id AND sm.subject = s.id AND s.id = :subject   AND bv.appointmentStatus.id IN (1,2)  AND (   (:startTime >= bv.scheduledStartTime AND :startTime < bv.scheduledEndTime)  or (:endTime > bv.scheduledStartTime AND :endTime <= bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime AND bv.scheduledEndTime <= :endTime) )";
        Query query = this.newQuery("SELECT bv.id FROM BookedVisit bv, Subject s, SubjectMrn sm  WHERE   bv.subjectMrn = sm.id AND sm.subject = s.id AND s.id = :subject   AND bv.appointmentStatus.id IN (1,2)  AND (   (:startTime >= bv.scheduledStartTime AND :startTime < bv.scheduledEndTime)  or (:endTime > bv.scheduledStartTime AND :endTime <= bv.scheduledEndTime)  or (bv.scheduledStartTime >= :startTime AND bv.scheduledEndTime <= :endTime) )");
        query.setParameter("subject", (Object)subject);
        query.setParameter("startTime", (Object)startDate);
        query.setParameter("endTime", (Object)endDate);
        return query.list().size() != 0;
    }

    public BookedVisit findBookedVisitById(int id) {
        return this.findById(BookedVisit.class, id);
    }

    public Date getDayBeforeYesterday() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        return new Date(calendar.getTimeInMillis());
    }

    public List<BookedResource> findBookedResources(Resource sharedResource) {
        String findBookedResources = "SELECT br FROM BookedVisit bv, BookedResource br, AppointmentStatus ap WHERE   br.bookedVisit = bv.id AND bv.appointmentStatus = ap.id AND br.resource = :resource   AND ap.name IN ('Scheduled','Hold','Checked-In') ";
        Query query = this.newQuery("SELECT br FROM BookedVisit bv, BookedResource br, AppointmentStatus ap WHERE   br.bookedVisit = bv.id AND bv.appointmentStatus = ap.id AND br.resource = :resource   AND ap.name IN ('Scheduled','Hold','Checked-In') ").setParameter("resource", (Object)sharedResource);
        return query.list();
    }

    public SwitchSubjectResultDTO switchVisitSubject(Integer newSubjectMrnId, BookedVisit visit, boolean homeScreen, String className) {
        String fullName;
        if (newSubjectMrnId.equals(0)) {
            visit.setSubjectMrn(null);
            fullName = "No Subject Assigned";
            visit.setAppointmentStatus(this.findHoldStatus());
            className = visit.getAppointmentStatus().getName();
        } else {
            SubjectMrn subjectMrn = this.findById(SubjectMrn.class, newSubjectMrnId);
            visit.setSubjectMrn(subjectMrn);
            visit.setAppointmentStatus(this.findScheduledStatus());
            fullName = SubjectDataEncryptor.decrypt(subjectMrn.getSubject().getFullName());
        }
        this.updateEntity(visit);
        VisitRenderSummaryDTO visitRenderSummaryDTO = new VisitRenderSummaryDTO(visit, className, homeScreen);
        return new SwitchSubjectResultDTO(true, newSubjectMrnId, fullName, visitRenderSummaryDTO);
    }

    public List<BookedVisit> getAllBookedVisitByStudyAndSubjectMrn(Study study, SubjectMrn subjectMrn) {
        String queryString = "select bv from BookedVisit bv where bv.study = :study and bv.subjectMrn = :subjectMrn";
        Query query = this.newQuery(queryString);
        query.setParameter("study", (Object)study);
        query.setParameter("subjectMrn", (Object)subjectMrn);
        return query.list();
    }

    private static final class CalendarBookedVisitsColumn {
        static final List<String> columnsHql = Arrays.asList("bv.id", "apSt.name", "bv.study.localId", "u.lastName", "bv.name", "subj.lastName", "bv.scheduledStartTime", "bv.scheduledEndTime", "bv.visitType");
        static final String columnHqlList = Joiner.on((String)", ").join(columnsHql);

        private CalendarBookedVisitsColumn() {
        }
    }

    private static final class Ref<A> {
        private A a;

        Ref(A a) {
            this.a = a;
        }

        A get() {
            return this.a;
        }

        void set(A a) {
            this.a = a;
        }
    }
}

