/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SearchDTO {
    List<SearchItem> searchItems;

    public List<SearchItem> setSearchItems(List<SearchItem> searchItems) {
        this.searchItems = searchItems;
        return this.searchItems;
    }

    public List<SearchItem> getSearchItems() {
        return this.searchItems;
    }

    static String possiblyAdjustEnumValue(SearchItem searchItem) {
        String result = searchItem.getValue();
        if (searchItem.key.equals("v.visitType")) {
            result = searchItem.getValue().replaceAll("(\\S) ", "$1");
        }
        return result;
    }

    public static String toSearchClause(List<SearchItem> searchItems, Function<String, String> keyMapper) {
        String result = "";
        List searchClauses = searchItems.stream().filter(si -> si.getValue() != null && !si.getValue().isEmpty()).map(si -> "(" + (String)keyMapper.apply(si.getKey()) + " like '%" + SearchDTO.possiblyAdjustEnumValue(si) + "%')").collect(Collectors.toList());
        if (!searchClauses.isEmpty()) {
            result = " AND " + Joiner.on((String)" AND ").join(searchClauses);
        }
        return result;
    }

    public static class SearchItem {
        String key;
        String value;

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

