/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.processor;

import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.opensaml.common.SAMLException;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecoder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.BasicSecurityPolicy;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.xml.security.SecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.context.SAMLMessageContext;
import org.springframework.security.saml.metadata.MetadataManager;
import org.springframework.security.saml.processor.SAMLBinding;
import org.springframework.security.saml.processor.SAMLProcessor;
import org.springframework.security.saml.util.SAMLUtil;
import org.springframework.util.Assert;

public class SAMLProcessorImpl
implements SAMLProcessor {
    private static final Logger log = LoggerFactory.getLogger(SAMLProcessorImpl.class);
    protected Collection<SAMLBinding> bindings;

    public SAMLProcessorImpl(SAMLBinding binding) {
        this.bindings = Arrays.asList(binding);
    }

    public SAMLProcessorImpl(Collection<SAMLBinding> bindings) {
        this.bindings = bindings;
    }

    public SAMLMessageContext retrieveMessage(SAMLMessageContext samlContext, SAMLBinding binding) throws SAMLException, MetadataProviderException, MessageDecodingException, SecurityException {
        log.debug("Retrieving message using binding {}", (Object)binding.getBindingURI());
        this.verifyContext(samlContext);
        this.populateSecurityPolicy(samlContext, binding);
        QName peerEntityRole = samlContext.getPeerEntityRole();
        if (peerEntityRole == null) {
            peerEntityRole = IDPSSODescriptor.DEFAULT_ELEMENT_NAME;
        }
        samlContext.setPeerEntityRole(peerEntityRole);
        samlContext.setInboundSAMLProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
        samlContext.setInboundSAMLBinding(binding.getBindingURI());
        MessageDecoder decoder = binding.getMessageDecoder();
        decoder.decode((MessageContext)samlContext);
        if (samlContext.getPeerEntityMetadata() == null) {
            throw new MetadataProviderException("Metadata for issuer " + samlContext.getInboundMessageIssuer() + " wasn't found");
        }
        samlContext.setPeerEntityId(samlContext.getPeerEntityMetadata().getEntityID());
        samlContext.setPeerExtendedMetadata(((MetadataManager)samlContext.getMetadataProvider()).getExtendedMetadata(samlContext.getPeerEntityId()));
        return samlContext;
    }

    protected void populateSecurityPolicy(SAMLMessageContext samlContext, SAMLBinding binding) {
        BasicSecurityPolicy policy = new BasicSecurityPolicy();
        binding.getSecurityPolicy(policy.getPolicyRules(), samlContext);
        StaticSecurityPolicyResolver resolver = new StaticSecurityPolicyResolver((SecurityPolicy)policy);
        samlContext.setSecurityPolicyResolver((SecurityPolicyResolver)resolver);
    }

    @Override
    public SAMLMessageContext retrieveMessage(SAMLMessageContext samlContext, String binding) throws SAMLException, MetadataProviderException, MessageDecodingException, SecurityException {
        return this.retrieveMessage(samlContext, this.getBinding(binding));
    }

    @Override
    public SAMLMessageContext retrieveMessage(SAMLMessageContext samlContext) throws SAMLException, MetadataProviderException, MessageDecodingException, SecurityException {
        return this.retrieveMessage(samlContext, this.getBinding(samlContext.getInboundMessageTransport()));
    }

    @Override
    public SAMLMessageContext sendMessage(SAMLMessageContext samlContext, boolean sign) throws SAMLException, MetadataProviderException, MessageEncodingException {
        Endpoint endpoint = samlContext.getPeerEntityEndpoint();
        if (endpoint == null) {
            throw new SAMLException("Could not get peer entity endpoint");
        }
        return this.sendMessage(samlContext, sign, this.getBinding(endpoint));
    }

    @Override
    public SAMLMessageContext sendMessage(SAMLMessageContext samlContext, boolean sign, String bindingName) throws SAMLException, MetadataProviderException, MessageEncodingException {
        return this.sendMessage(samlContext, sign, this.getBinding(bindingName));
    }

    protected SAMLMessageContext sendMessage(SAMLMessageContext samlContext, boolean sign, SAMLBinding binding) throws SAMLException, MetadataProviderException, MessageEncodingException {
        this.verifyContext(samlContext);
        if (sign) {
            Assert.notNull((Object)samlContext.getLocalSigningCredential(), (String)"Cannot sign outgoing message as no signing credential is set in the context");
            samlContext.setOutboundSAMLMessageSigningCredential(samlContext.getLocalSigningCredential());
        }
        MessageEncoder encoder = binding.getMessageEncoder();
        encoder.encode((MessageContext)samlContext);
        return samlContext;
    }

    protected void verifyContext(SAMLMessageContext samlContext) throws MetadataProviderException {
        Assert.notNull((Object)samlContext.getMetadataProvider(), (String)"Metadata provider must be set in the context");
        Assert.notNull((Object)samlContext.getLocalEntityId(), (String)"Local entity id must be set in the context");
        Assert.notNull((Object)samlContext.getLocalEntityRole(), (String)"Local entity role must be set in the context");
        Assert.notNull((Object)samlContext.getLocalEntityMetadata(), (String)"Local entity metadata must be set in the context");
        Assert.notNull((Object)samlContext.getLocalEntityRoleMetadata(), (String)"Local entity role metadata must be set in the context");
        Assert.notNull((Object)samlContext.getLocalExtendedMetadata(), (String)"Local extended metadata must be set in the context");
        Assert.notNull((Object)samlContext.getLocalTrustEngine(), (String)"SignatureTrustEngine must be set in the samlContext");
        Assert.notNull(samlContext.getLocalSSLTrustEngine(), (String)"SSL Trust Engine must be set in the samlContext");
    }

    protected SAMLBinding getBinding(InTransport transport) throws SAMLException {
        for (SAMLBinding binding : this.bindings) {
            if (!binding.supports(transport)) continue;
            return binding;
        }
        throw new SAMLException("Unsupported request");
    }

    protected SAMLBinding getBinding(Endpoint endpoint) throws SAMLException, MetadataProviderException {
        return this.getBinding(SAMLUtil.getBindingForEndpoint(endpoint));
    }

    protected SAMLBinding getBinding(String bindingName) throws SAMLException {
        for (SAMLBinding binding : this.bindings) {
            if (!binding.getBindingURI().equals(bindingName)) continue;
            return binding;
        }
        throw new SAMLException("Binding " + bindingName + " is not available, please check your configuration");
    }
}

