/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggerListener
implements ApplicationListener<AbstractAuthenticationEvent> {
    private static final Log logger = LogFactory.getLog(LoggerListener.class);
    private boolean logInteractiveAuthenticationSuccessEvents = true;

    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        if (!this.logInteractiveAuthenticationSuccessEvents && event instanceof InteractiveAuthenticationSuccessEvent) {
            return;
        }
        if (logger.isWarnEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Authentication event ");
            builder.append(ClassUtils.getShortName(((Object)((Object)event)).getClass()));
            builder.append(": ");
            builder.append(event.getAuthentication().getName());
            builder.append("; details: ");
            builder.append(event.getAuthentication().getDetails());
            if (event instanceof AbstractAuthenticationFailureEvent) {
                builder.append("; exception: ");
                builder.append(((AbstractAuthenticationFailureEvent)event).getException().getMessage());
            }
            logger.warn((Object)builder.toString());
        }
    }

    public boolean isLogInteractiveAuthenticationSuccessEvents() {
        return this.logInteractiveAuthenticationSuccessEvents;
    }

    public void setLogInteractiveAuthenticationSuccessEvents(boolean logInteractiveAuthenticationSuccessEvents) {
        this.logInteractiveAuthenticationSuccessEvents = logInteractiveAuthenticationSuccessEvents;
    }
}

