/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Iterator;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.HibernateIterator;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.LobCreator;
import org.hibernate.engine.jdbc.NonContextualLobCreator;
import org.hibernate.engine.jdbc.StreamUtils;
import org.hibernate.intercept.FieldInterceptionHelper;
import org.hibernate.intercept.FieldInterceptor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.LazyInitializer;
import org.hibernate.type.AnyType;
import org.hibernate.type.BigDecimalType;
import org.hibernate.type.BigIntegerType;
import org.hibernate.type.BinaryType;
import org.hibernate.type.BlobType;
import org.hibernate.type.BooleanType;
import org.hibernate.type.ByteType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.CharArrayType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.CharacterArrayType;
import org.hibernate.type.CharacterType;
import org.hibernate.type.ClassType;
import org.hibernate.type.ClobType;
import org.hibernate.type.CurrencyType;
import org.hibernate.type.DateType;
import org.hibernate.type.DoubleType;
import org.hibernate.type.FloatType;
import org.hibernate.type.ImageType;
import org.hibernate.type.IntegerType;
import org.hibernate.type.LocaleType;
import org.hibernate.type.LongType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MaterializedBlobType;
import org.hibernate.type.MaterializedClobType;
import org.hibernate.type.ObjectType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.SerializableType;
import org.hibernate.type.ShortType;
import org.hibernate.type.StringType;
import org.hibernate.type.TextType;
import org.hibernate.type.TimeType;
import org.hibernate.type.TimeZoneType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.TrueFalseType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.type.WrappedMaterializedBlobType;
import org.hibernate.type.WrapperBinaryType;
import org.hibernate.type.YesNoType;
import org.hibernate.usertype.CompositeUserType;

public final class Hibernate {
    public static final BooleanType BOOLEAN = BooleanType.INSTANCE;
    public static final TrueFalseType TRUE_FALSE = TrueFalseType.INSTANCE;
    public static final YesNoType YES_NO = YesNoType.INSTANCE;
    public static final ByteType BYTE = ByteType.INSTANCE;
    public static final ShortType SHORT = ShortType.INSTANCE;
    public static final IntegerType INTEGER = IntegerType.INSTANCE;
    public static final LongType LONG = LongType.INSTANCE;
    public static final FloatType FLOAT = FloatType.INSTANCE;
    public static final DoubleType DOUBLE = DoubleType.INSTANCE;
    public static final BigIntegerType BIG_INTEGER = BigIntegerType.INSTANCE;
    public static final BigDecimalType BIG_DECIMAL = BigDecimalType.INSTANCE;
    public static final CharacterType CHARACTER = CharacterType.INSTANCE;
    public static final StringType STRING = StringType.INSTANCE;
    public static final TimeType TIME = TimeType.INSTANCE;
    public static final DateType DATE = DateType.INSTANCE;
    public static final TimestampType TIMESTAMP = TimestampType.INSTANCE;
    public static final BinaryType BINARY = BinaryType.INSTANCE;
    public static final WrapperBinaryType WRAPPER_BINARY = WrapperBinaryType.INSTANCE;
    public static final CharArrayType CHAR_ARRAY = CharArrayType.INSTANCE;
    public static final CharacterArrayType CHARACTER_ARRAY = CharacterArrayType.INSTANCE;
    public static final ImageType IMAGE = ImageType.INSTANCE;
    public static final TextType TEXT = TextType.INSTANCE;
    public static final MaterializedBlobType MATERIALIZED_BLOB = MaterializedBlobType.INSTANCE;
    public static final MaterializedClobType MATERIALIZED_CLOB = MaterializedClobType.INSTANCE;
    public static final BlobType BLOB = BlobType.INSTANCE;
    public static final ClobType CLOB = ClobType.INSTANCE;
    public static final WrappedMaterializedBlobType WRAPPER_MATERIALIZED_BLOB = WrappedMaterializedBlobType.INSTANCE;
    public static final CharacterArrayClobType WRAPPER_CHARACTERS_CLOB = CharacterArrayClobType.INSTANCE;
    public static final PrimitiveCharacterArrayClobType CHARACTERS_CLOB = PrimitiveCharacterArrayClobType.INSTANCE;
    public static final CalendarType CALENDAR = CalendarType.INSTANCE;
    public static final CalendarDateType CALENDAR_DATE = CalendarDateType.INSTANCE;
    public static final LocaleType LOCALE = LocaleType.INSTANCE;
    public static final CurrencyType CURRENCY = CurrencyType.INSTANCE;
    public static final TimeZoneType TIMEZONE = TimeZoneType.INSTANCE;
    public static final ClassType CLASS = ClassType.INSTANCE;
    public static final SerializableType SERIALIZABLE = SerializableType.INSTANCE;
    public static final ObjectType OBJECT = ObjectType.INSTANCE;

    private Hibernate() {
        throw new UnsupportedOperationException();
    }

    public static Type serializable(Class serializableClass) {
        return new SerializableType(serializableClass);
    }

    public static Type any(Type metaType, Type identifierType) {
        return new AnyType(metaType, identifierType);
    }

    public static Type entity(Class persistentClass) {
        return Hibernate.entity(persistentClass.getName());
    }

    public static Type entity(String entityName) {
        return new ManyToOneType(NoScope.INSTANCE, entityName);
    }

    public static Type custom(Class userTypeClass) {
        return Hibernate.custom(userTypeClass, null);
    }

    public static Type custom(Class userTypeClass, String[] parameterNames, String[] parameterValues) {
        return Hibernate.custom(userTypeClass, Hibernate.toProperties(parameterNames, parameterValues));
    }

    private static Properties toProperties(String[] parameterNames, String[] parameterValues) {
        if (parameterNames == null || parameterNames.length == 0) {
            return null;
        }
        Properties parameters = new Properties();
        for (int i = 0; i < parameterNames.length; ++i) {
            parameters.put(parameterNames[i], parameterValues[i]);
        }
        return parameters;
    }

    public static Type custom(Class userTypeClass, Properties parameters) {
        if (CompositeUserType.class.isAssignableFrom(userTypeClass)) {
            return TypeFactory.customComponent(userTypeClass, parameters, NoScope.INSTANCE);
        }
        return TypeFactory.custom(userTypeClass, parameters, NoScope.INSTANCE);
    }

    public static void initialize(Object proxy) throws HibernateException {
        if (proxy == null) {
            return;
        }
        if (proxy instanceof HibernateProxy) {
            ((HibernateProxy)proxy).getHibernateLazyInitializer().initialize();
        } else if (proxy instanceof PersistentCollection) {
            ((PersistentCollection)proxy).forceInitialization();
        }
    }

    public static boolean isInitialized(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return !((HibernateProxy)proxy).getHibernateLazyInitializer().isUninitialized();
        }
        if (proxy instanceof PersistentCollection) {
            return ((PersistentCollection)proxy).wasInitialized();
        }
        return true;
    }

    public static Class getClass(Object proxy) {
        if (proxy instanceof HibernateProxy) {
            return ((HibernateProxy)proxy).getHibernateLazyInitializer().getImplementation().getClass();
        }
        return proxy.getClass();
    }

    public static Blob createBlob(byte[] bytes) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(bytes));
    }

    public static Blob createBlob(byte[] bytes, Session session) {
        return Hibernate.getLobCreator(session).createBlob(bytes);
    }

    public static LobCreator getLobCreator(Session session) {
        return Hibernate.getLobCreator((SessionImplementor)((Object)session));
    }

    public static LobCreator getLobCreator(SessionImplementor session) {
        return session.getFactory().getSettings().getJdbcSupport().getLobCreator((LobCreationContext)((Object)session));
    }

    @Deprecated
    public static Blob createBlob(InputStream stream, int length) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(stream, length));
    }

    @Deprecated
    public static Blob createBlob(InputStream stream, long length) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createBlob(stream, length));
    }

    @Deprecated
    public static Blob createBlob(InputStream stream, long length, Session session) {
        return Hibernate.getLobCreator(session).createBlob(stream, length);
    }

    @Deprecated
    public static Blob createBlob(InputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(stream.available());
        StreamUtils.copy(stream, buffer);
        return Hibernate.createBlob(buffer.toByteArray());
    }

    @Deprecated
    public static Clob createClob(String string) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createClob(string));
    }

    @Deprecated
    public static Clob createClob(String string, Session session) {
        return Hibernate.getLobCreator(session).createClob(string);
    }

    @Deprecated
    public static Clob createClob(Reader reader, int length) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createClob(reader, length));
    }

    @Deprecated
    public static Clob createClob(Reader reader, long length) {
        return NonContextualLobCreator.INSTANCE.wrap(NonContextualLobCreator.INSTANCE.createClob(reader, length));
    }

    @Deprecated
    public static Clob createClob(Reader reader, long length, Session session) {
        return Hibernate.getLobCreator(session).createClob(reader, length);
    }

    public static void close(Iterator iterator) throws HibernateException {
        if (!(iterator instanceof HibernateIterator)) {
            throw new IllegalArgumentException("not a Hibernate iterator");
        }
        ((HibernateIterator)iterator).close();
    }

    public static boolean isPropertyInitialized(Object proxy, String propertyName) {
        Object entity;
        if (proxy instanceof HibernateProxy) {
            LazyInitializer li = ((HibernateProxy)proxy).getHibernateLazyInitializer();
            if (li.isUninitialized()) {
                return false;
            }
            entity = li.getImplementation();
        } else {
            entity = proxy;
        }
        if (FieldInterceptionHelper.isInstrumented(entity)) {
            FieldInterceptor interceptor = FieldInterceptionHelper.extractFieldInterceptor(entity);
            return interceptor == null || interceptor.isInitialized(propertyName);
        }
        return true;
    }

    private static class NoScope
    implements TypeFactory.TypeScope {
        public static final NoScope INSTANCE = new NoScope();

        private NoScope() {
        }

        public SessionFactoryImplementor resolveFactory() {
            throw new HibernateException("Cannot access SessionFactory from here");
        }
    }
}

