/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public final class OneWayPasswordEncoder {
    private static final Logger LOG = Logger.getLogger(OneWayPasswordEncoder.class);
    private static final int COUNT = 5;

    private OneWayPasswordEncoder() {
    }

    public static OneWayPasswordEncoder getInstance() {
        return Holder.instance;
    }

    public synchronized String encode(String password, String saltKey) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"encode(String, String) - start");
        }
        String encodedPassword = null;
        byte[] salt = this.base64ToByte(saltKey);
        String encodeProblem = "Problem encoding password!";
        byte[] btPass = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.reset();
            digest.update(salt);
            btPass = digest.digest(password.getBytes("UTF-8"));
            for (int i = 0; i < 5; ++i) {
                digest.reset();
                btPass = digest.digest(btPass);
            }
        }
        catch (UnsupportedEncodingException uee) {
            SchedulerRuntimeException.logAndThrow("Problem encoding password!", uee);
        }
        catch (NoSuchAlgorithmException nsae) {
            SchedulerRuntimeException.logAndThrow("Problem encoding password!", nsae);
        }
        encodedPassword = this.byteToBase64(btPass);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"encode(String, String) - end");
        }
        return encodedPassword;
    }

    private byte[] base64ToByte(String str) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"base64ToByte(String) - start");
        }
        byte[] returnbyteArray = Base64.base64Decode(str);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"base64ToByte(String) - end");
        }
        return returnbyteArray;
    }

    private String byteToBase64(byte[] bt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"byteToBase64(byte[]) - start");
        }
        String returnString = Base64.base64Encode(bt);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"byteToBase64(byte[]) - end");
        }
        return returnString;
    }

    private static final class Holder {
        private static final OneWayPasswordEncoder instance = Holder.makeInstance();

        private Holder() {
        }

        static OneWayPasswordEncoder makeInstance() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getInstance() - start");
            }
            if (instance == null) {
                OneWayPasswordEncoder returnOneWayPasswordEncoder = new OneWayPasswordEncoder();
                LOG.info((Object)"New instance created");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"getInstance() - end");
                }
                return returnOneWayPasswordEncoder;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"getInstance() - end");
            }
            return instance;
        }
    }
}

