/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hibernate.Query;

public class SearchDTO {
    List<SearchItem> searchItems;
    private Set<String> queryParamNames = new HashSet<String>();
    public static final Function<String, String> visitTypeValueMapper = value -> value.replaceAll("(\\S) ", "$1");

    public void assignUniqueQueryParamName(SearchItem searchItem) {
        String newQueryParamName = searchItem.getKey().replace(".", "_").trim();
        while (this.queryParamNames.contains(newQueryParamName)) {
            newQueryParamName = newQueryParamName + "_";
        }
        this.queryParamNames.add(newQueryParamName);
        searchItem.setQueryParamName(newQueryParamName);
    }

    public List<SearchItem> setSearchItems(List<SearchItem> searchItems) {
        this.searchItems = searchItems;
        return this.searchItems;
    }

    public List<SearchItem> getSearchItems() {
        return this.searchItems;
    }

    public void mapSearchItemKeyAndValue(String key, String newKey, Function<String, String> valueMapper) {
        List<SearchItem> searchItems = this.getSearchItems();
        if (searchItems != null && searchItems.size() > 0) {
            searchItems.stream().forEach(si -> {
                if (si.getKey().equals(key)) {
                    List<SearchItem> orSearchItems = si.getOrSearchItems();
                    if (orSearchItems != null && orSearchItems.size() > 0) {
                        for (SearchItem orSearchItem : orSearchItems) {
                            orSearchItem.setKey(newKey);
                            if (valueMapper == null) continue;
                            orSearchItem.setValue((String)valueMapper.apply(orSearchItem.getValue()));
                        }
                    } else {
                        si.setKey(newKey);
                        if (valueMapper != null) {
                            si.setValue((String)valueMapper.apply(si.getValue()));
                        }
                    }
                }
            });
        }
    }

    public void mapSearchItemKeysAndValues(Map<String, String> keyMapperMap, Map<String, Function<String, String>> valueMapperMap) {
        List<SearchItem> searchItems = this.getSearchItems();
        if (searchItems != null && searchItems.size() > 0) {
            searchItems.stream().forEach(si -> {
                String key = si.getKey();
                if (key == null) {
                    List<SearchItem> orSearchItems = si.getOrSearchItems();
                    if (orSearchItems != null && orSearchItems.size() > 0) {
                        for (SearchItem orSearchItem : orSearchItems) {
                            String newKey = (String)keyMapperMap.get(orSearchItem.getKey());
                            if (newKey == null) continue;
                            Function valueMapper = (Function)valueMapperMap.get(newKey);
                            orSearchItem.setKey(newKey);
                            if (valueMapper == null) continue;
                            orSearchItem.setValue((String)valueMapper.apply(orSearchItem.getValue()));
                        }
                    }
                } else {
                    String newKey = (String)keyMapperMap.get(si.getKey());
                    if (newKey != null) {
                        si.setKey(newKey);
                        Function valueMapper = (Function)valueMapperMap.get(newKey);
                        if (valueMapper != null) {
                            si.setValue((String)valueMapper.apply(si.getValue()));
                        }
                    }
                }
            });
        }
    }

    public List<String> generateSearchClauseList() {
        List<SearchItem> searchItems = this.getSearchItems();
        List<String> searchClauses = searchItems == null || searchItems.size() == 0 ? new ArrayList<String>() : searchItems.stream().filter(si -> MiscUtil.isNonNullNonEmpty(si.getValue()) || si.getOrSearchItems() != null).map(si -> {
            List<SearchItem> orSearchItems = si.getOrSearchItems();
            if (orSearchItems != null && orSearchItems.size() > 0) {
                List orSearchClauses = orSearchItems.stream().map(osi -> {
                    StringBuilder searchClauseBuilder = new StringBuilder(osi.getKey());
                    this.generateAndAppendMatchClause(searchClauseBuilder, (SearchItem)osi);
                    return searchClauseBuilder.toString();
                }).collect(Collectors.toList());
                return "(" + Joiner.on((String)" OR ").join(orSearchClauses) + ")";
            }
            if (si.getValue() != null && !si.getValue().isEmpty()) {
                StringBuilder searchClause = new StringBuilder(si.getKey());
                this.generateAndAppendMatchClause(searchClause, (SearchItem)si);
                return searchClause.toString();
            }
            return null;
        }).collect(Collectors.toList());
        return searchClauses;
    }

    public void generateAndAppendMatchClause(StringBuilder searchClause, SearchItem searchItem) {
        String matchClause;
        this.assignUniqueQueryParamName(searchItem);
        if (searchItem.getSearchType() == SearchType.EXACT) {
            matchClause = " = :" + searchItem.getQueryParamName();
            searchItem.setQueryParamValue(searchItem.getValue());
        } else {
            matchClause = " LIKE :" + searchItem.getQueryParamName();
            searchItem.setQueryParamValue("%" + searchItem.getValue() + "%");
        }
        searchClause.append(matchClause);
    }

    public String toSearchClause(String joinString, String prependString) {
        List<String> searchClauses = this.generateSearchClauseList();
        if (!searchClauses.isEmpty()) {
            return prependString + Joiner.on((String)joinString).join(searchClauses);
        }
        return "";
    }

    public String toSearchClause() {
        return this.toSearchClause(" AND ", " AND ");
    }

    public void assignQueryParameterValues(Query query) {
        List<SearchItem> searchItems = this.getSearchItems();
        if (MiscUtil.isNonNullNonEmpty(searchItems)) {
            searchItems.stream().forEach(searchItem -> {
                List<SearchItem> orSearchItems = searchItem.getOrSearchItems();
                if (MiscUtil.isNonNullNonEmpty(orSearchItems)) {
                    for (SearchItem orSearchItem : orSearchItems) {
                        query.setString(orSearchItem.getQueryParamName(), orSearchItem.getQueryParamValue());
                    }
                } else {
                    query.setString(searchItem.getQueryParamName(), searchItem.getQueryParamValue());
                }
            });
        }
    }

    public static class SearchItem {
        String key;
        String value;
        String queryParamName;
        String queryParamValue;
        SearchType searchType;
        List<SearchItem> orSearchItems;

        public SearchItem() {
        }

        public SearchItem(SearchType searchType, String key, String value, List<SearchItem> orSearchItems) {
            this.searchType = searchType;
            this.key = key;
            this.value = value;
            this.orSearchItems = orSearchItems;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setQueryParamName(String queryParamName) {
            this.queryParamName = queryParamName;
        }

        public String getQueryParamName() {
            return this.queryParamName;
        }

        public void setQueryParamValue(String queryParamValue) {
            this.queryParamValue = queryParamValue;
        }

        public String getQueryParamValue() {
            return this.queryParamValue;
        }

        public SearchType getSearchType() {
            return this.searchType;
        }

        public void setSearchType(SearchType searchType) {
            this.searchType = searchType;
        }

        public List<SearchItem> getOrSearchItems() {
            return this.orSearchItems;
        }

        public void setOrSearchItems(List<SearchItem> orSearchItems) {
            this.orSearchItems = orSearchItems;
        }
    }

    public static enum SearchType {
        EXACT("exact"),
        ANY("any");

        private String type;

        private SearchType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

