/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class StudyStatusChangeReportDTO
implements CsvAbleDTO {
    private String studyName;
    private String localId;
    private String pi;
    private String studyStatus;
    private Date dateStatusChange;
    private String userFirstName;
    private String userMiddleName;
    private String userLastName;
    private int studyId;

    public int getStudyId() {
        return this.studyId;
    }

    public void setStudyId(int studyId) {
        this.studyId = studyId;
    }

    public String getStudyName() {
        return this.studyName;
    }

    public void setStudyName(String studyName) {
        this.studyName = studyName;
    }

    public String getLocalId() {
        return this.localId;
    }

    public void setLocalId(String localId) {
        this.localId = localId;
    }

    public String getPi() {
        return this.pi;
    }

    public void setPi(String pi) {
        this.pi = pi;
    }

    public String getStudyStatus() {
        return this.studyStatus;
    }

    public void setStudyStatus(String studyStatus) {
        this.studyStatus = studyStatus;
    }

    public Date getDateStatusChange() {
        return this.dateStatusChange;
    }

    public void setDateStatusChange(Date dateStatusChange) {
        this.dateStatusChange = dateStatusChange;
    }

    public void setUserFirstName(String userFirstName) {
        this.userFirstName = userFirstName;
    }

    public String getUserFirstName() {
        return this.userFirstName;
    }

    public String getUserMiddleName() {
        return this.userMiddleName;
    }

    public void setUserMiddleName(String userMiddleName) {
        this.userMiddleName = userMiddleName;
    }

    public String getUserLastName() {
        return this.userLastName;
    }

    public void setUserLastName(String userLastName) {
        this.userLastName = userLastName;
    }

    @Override
    public String toCsvHeaders() {
        return "Local ID,PI,Study Status, Date of Status Change, User";
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            StudyStatusChangeReportDTO d = (StudyStatusChangeReportDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(d.localId));
            columns.add(MiscUtil.q(d.pi));
            columns.add(MiscUtil.q(d.studyStatus));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(d.dateStatusChange)));
            columns.add(MiscUtil.q(MiscUtil.fullName(d.userFirstName, d.userMiddleName, d.userLastName)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }
}

