/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.core.BookedVisitActivityLogStatics;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.BookedVisitActivityLog;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import java.util.Arrays;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class AuditDAO
extends SiteDAO {
    public List<BookedVisitActivityLog> getActivityLogForBookedVisit(BookedVisit bookedVisit) {
        String hql = "select bval from BookedVisitActivityLog bval where bval.bookedVisit = :bookedVisit and bval.actionPerformed IN (:actions) order by bval.date DESC";
        List<String> actions = Arrays.asList(BookedVisitActivityLogStatics.BATCH_ENTRY.getLogString(), BookedVisitActivityLogStatics.CANCELLED.getLogString(), BookedVisitActivityLogStatics.CHECKED_IN.getLogString(), BookedVisitActivityLogStatics.CHECKED_OUT.getLogString(), BookedVisitActivityLogStatics.OVERBOOKED.getLogString(), BookedVisitActivityLogStatics.RESCHEDULED.getLogString(), BookedVisitActivityLogStatics.SCHEDULED.getLogString());
        Query query = this.session().createQuery(hql);
        query.setParameter("bookedVisit", (Object)bookedVisit);
        query.setParameterList("actions", actions);
        return query.list();
    }
}

