/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.response.MrnInfoDTO;
import edu.harvard.catalyst.scheduler.dto.response.SubjectDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.SubjectsResponseDTO;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.ArchivalStatus;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.SubjectService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StandaloneSubjectService
implements SubjectService {
    protected final SubjectDAO subjectDAO;

    @Autowired
    public StandaloneSubjectService(SubjectDAO subjectDAO) {
        this.subjectDAO = subjectDAO;
    }

    @Override
    public SubjectDetailResponse getSubjectData(Boolean isPuid, Integer id, String remoteHost, User user) {
        return this.subjectDAO.getSubjectDataById(id);
    }

    @Override
    public SubjectsResponseDTO getSearchedSubjects(String subjectLastName, String subjectFirstName, String subjectMrn, String subjectBirthDate, List<String> subjectGenderIdList) {
        return this.subjectDAO.getSearchSubjects(subjectLastName, subjectFirstName, subjectMrn, subjectBirthDate, subjectGenderIdList);
    }

    public boolean refreshExternalSubject(SubjectMrn subjectMrn, boolean tolerateSomeTimeouts) {
        SchedulerRuntimeException.logAndThrow("Cannot refresh external Subject in standalone mode");
        return false;
    }

    public void markArchivalStatus(Subject subject, String actionPerformed, String changesDetail, ArchivalStatus status) {
        subject.setArchivalStatus(status);
        this.subjectDAO.updateEntity(subject);
        ActivityLog al = new ActivityLog();
        al.setPerformingUser(null);
        al.setActionPerformed(actionPerformed);
        al.setDate(new Date());
        al.setIpAddress(null);
        al.setAffectedUser(null);
        al.setAffectedResource(null);
        al.setAffectedSublocation(null);
        al.setAffectedSubject(subject);
        al.setAffectedStudy(null);
        al.setAffectedVisit(null);
        al.setChangesDetailRequiredField(null);
        al.setChangesDetail(changesDetail);
        al.setAppointmentOverrideReason(null);
        al.setBookedVisit(null);
        this.subjectDAO.createEntity(al);
    }

    @Override
    public SubjectDetailResponse findInternalSubjectByMrn(List<MrnInfoDTO> mrnInfoDTO) {
        return this.subjectDAO.findInternalSubjectByMrn(mrnInfoDTO);
    }

    @Override
    public SubjectDetailResponse getExternalSubjectDataUsingMrn(MrnInfoDTO mrnInfoDTO) {
        return new SubjectDetailResponse();
    }
}

