/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import java.math.BigInteger;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class SiteDAO {
    @Autowired
    protected SessionFactory sessionFactory;

    public void createEntity(BaseEntity entity) {
        org.hibernate.Session session = this.session();
        session.save((Object)entity);
        session.flush();
    }

    public void updateEntity(BaseEntity entity) {
        org.hibernate.Session session = this.session();
        session.update((Object)entity);
        session.flush();
    }

    public void deleteEntity(BaseEntity entity) {
        org.hibernate.Session session = this.session();
        session.delete((Object)entity);
        session.flush();
    }

    public void refreshEntity(BaseEntity entity) {
        org.hibernate.Session session = this.session();
        session.refresh((Object)entity);
    }

    public <T extends BaseEntity> T findById(Class<T> entityClass, Integer id) {
        Criteria crit = this.newCriteria(entityClass);
        crit.add((Criterion)Restrictions.eq((String)"id", (Object)id));
        return (T)((BaseEntity)crit.uniqueResult());
    }

    public String findNameById(String tableName, Integer id, boolean first) {
        return first ? this.findFieldById(tableName, id, "firstName") : this.findFieldById(tableName, id, "name");
    }

    public String findNameById(String tableName, Integer id) {
        return this.findFieldById(tableName, id, "name");
    }

    public String findFieldById(String tableName, Integer id, String fieldName) {
        String findName = "SELECT table." + fieldName + " FROM " + tableName + " table  WHERE table.id = :id ";
        Query query = this.newQuery(findName);
        query.setParameter("id", (Object)id);
        query.setCacheable(true);
        String result = (String)query.uniqueResult();
        return result;
    }

    public BaseEntity findEntityByFieldString(String tableName, String fieldName, String value) {
        BaseEntity result = null;
        String queryString = "SELECT t FROM " + tableName + " t  " + "WHERE UPPER(t." + fieldName + ") = UPPER('" + value + "')";
        Query query = this.newQuery(queryString);
        query.setCacheable(true);
        List results = query.list();
        if (results.size() == 0) {
            SchedulerRuntimeException.logDontThrow("No results for " + tableName + ":" + fieldName + ":" + value);
        } else {
            result = (BaseEntity)results.get(0);
            if (results.size() > 1) {
                SchedulerRuntimeException.logDontThrow("Choosing first from multiple results for " + tableName + ":" + fieldName + ":" + value);
            }
        }
        return result;
    }

    protected <T extends BaseEntity> List<T> findAll(Class<T> entityClass) {
        return this.newCriteria(entityClass).list();
    }

    protected <T extends BaseEntity> List<T> findAll(Class<T> entityClass, int firstRecord) {
        Criteria criteria = this.newCriteria(entityClass);
        criteria.setFirstResult(firstRecord);
        return criteria.list();
    }

    public int findTotalByQuery(String sqlQuery) {
        BigInteger bi = (BigInteger)this.newSqlQuery(sqlQuery).uniqueResult();
        return bi.intValue();
    }

    org.hibernate.Session session() {
        Session session = this.sessionFactory.getCurrentSession();
        return session;
    }

    Criteria newCriteria(Class<? extends BaseEntity> entityClass) {
        return this.session().createCriteria(entityClass);
    }

    public Query newQuery(String hql) {
        return this.session().createQuery(hql);
    }

    SQLQuery newSqlQuery(String sql) {
        return this.session().createSQLQuery(sql);
    }
}

