/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.common.collect.Lists;
import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.dto.ReportDTO;
import edu.harvard.catalyst.scheduler.dto.WorkloadAndResourceResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.CancellationsReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.statics.StudyStatusFilter;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Report;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.ReportService;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/report")
@Singleton
@Component
public class ReportResource
extends SecuredResource {
    private ReportService reportService;

    @Autowired
    public ReportResource(ReportService reportService) {
        this.reportService = reportService;
    }

    ReportResource() {
    }

    @GET
    @Path(value="/getReports")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getReports() {
        this.reportService.logViewReports(this.getUser(), this.getRemoteHost(), "Reports Screen View");
        ReportDTO reportDTO = new ReportDTO();
        List<Report> reports = this.reportService.getReports(reportDTO);
        reportDTO.setReports(reports);
        return this.gson.toJson((Object)reportDTO);
    }

    @GET
    @Path(value="/getReportData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String getReportData(@QueryParam(value="id") int id) {
        Report report = this.reportService.getReportData(this.getUser(), this.getRemoteHost(), id);
        return this.gson.toJson((Object)report);
    }

    @POST
    @Path(value="/getReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public Response getReport(@FormParam(value="data") String data, @QueryParam(value="name") String name, @QueryParam(value="filterString") String filterString, @QueryParam(value="filterId") String filterId, @QueryParam(value="sortId") String sortId, @DefaultValue(value="json") @QueryParam(value="output") String output) {
        List<Object> reportResultList = new ArrayList();
        ReportDTO dto = new ReportDTO();
        try {
            dto = (ReportDTO)this.gson.fromJson(data, ReportDTO.class);
            if (dto == null) {
                dto = new ReportDTO();
            }
            dto.setName(name);
            dto.setFilterString(filterString);
            dto.setFilterId(filterId);
            dto.setSortId(sortId);
            reportResultList = this.reportService.getReport(dto, this.getUser(), this.getRemoteHost());
            return this.handleListAndOutputChoice(reportResultList, dto, output, name);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    String adjustFileName(String name) {
        String result = name;
        if (name.equals("export_daily_overview")) {
            result = "daily_overview";
        }
        if (name.equals("export_daily_resource")) {
            result = "daily_resource";
        }
        if (name.equals("meta_kitchen_flat")) {
            result = "meta_kitchen";
        }
        return result;
    }

    Response handleListAndOutputChoice(List<?> reportResultList, ReportDTO dto, String output, String reportName) {
        Response resultResponse = null;
        if (output.equalsIgnoreCase("json")) {
            String result = this.subjectMrnSkippingGson.toJson((Object)dto);
            resultResponse = Response.ok((Object)result).build();
        } else {
            List<Object> csvRows;
            if (MiscUtil.isNonNullNonEmpty(reportResultList) && reportResultList.get(0) instanceof CsvAbleDTO) {
                CsvAbleDTO csvAbleDTO = (CsvAbleDTO)reportResultList.get(0);
                csvRows = csvAbleDTO.toCsvRows(reportResultList, reportName);
            } else {
                csvRows = Lists.newArrayList((Object[])new String[]{""});
            }
            StreamingOutput streamingOutput = out -> {
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));){
                    for (String row : csvRows) {
                        ((Writer)writer).flush();
                        writer.write(row);
                        ((Writer)writer).flush();
                    }
                }
                catch (IOException ioe) {
                    SchedulerRuntimeException.logAndThrow("Problem streaming with " + csvRows + "rows", ioe);
                }
            };
            reportName = this.adjustFileName(reportName).toLowerCase() + ".csv";
            resultResponse = Response.ok((Object)streamingOutput).header("Content-Disposition", (Object)("attachment; filename=" + reportName)).build();
        }
        return resultResponse;
    }

    @POST
    @Path(value="/logViewReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public void logViewReport(@FormParam(value="data") String data) {
        ReportDTO dto = (ReportDTO)this.gson.fromJson(data, ReportDTO.class);
        this.reportService.logViewReports(this.getUser(), this.getRemoteHost(), "Report Clicked - " + dto.getName());
    }

    @POST
    @Path(value="/loadResourceTypes")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String loadResourceTypes(@FormParam(value="data") String data) {
        List<ResourceType> resourceTypes = this.reportService.getResourceTypes();
        ReportDTO dto = new ReportDTO();
        dto.setResourceTypes(resourceTypes);
        return this.gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/loadSublocations")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public String loadSublocations(@FormParam(value="data") String data) {
        List<Sublocation> sublocations = this.reportService.getSublocations();
        ReportDTO dto = new ReportDTO();
        dto.setSublocations(sublocations);
        return this.gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/studyDataReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public Response studyDataReport(@QueryParam(value="localId") String localId, @QueryParam(value="name") String name, @QueryParam(value="studyStatus") String studyStatus, @QueryParam(value="fundingSource") String fundingSource, @QueryParam(value="sortStrategy") String sortStrategy, @DefaultValue(value="json") @QueryParam(value="output") String output) {
        ReportDTO dto = new ReportDTO();
        ArrayList<StudyDataReportResponseDTO> studyDataReportResponseDTOs = new ArrayList();
        StudyStatusFilter studyStatusFilter = null;
        if (MiscUtil.isNonNullNonEmpty(studyStatus)) {
            studyStatusFilter = StudyStatusFilter.valueOf(studyStatus);
        }
        try {
            studyDataReportResponseDTOs = this.reportService.getStudyDataReport(Optional.of(this.getUser()), Optional.of(this.getRemoteHost()), Optional.ofNullable(localId), Optional.ofNullable(name), Optional.ofNullable(fundingSource), Optional.ofNullable(studyStatusFilter), Optional.ofNullable(sortStrategy));
            dto.setStudyDataReport(studyDataReportResponseDTOs);
            return this.handleListAndOutputChoice(studyDataReportResponseDTOs, dto, output, "study_data");
        }
        catch (Exception e) {
            studyDataReportResponseDTOs.clear();
            String result = this.subjectMrnSkippingGson.toJson((Object)dto);
            return Response.ok((Object)result).build();
        }
    }

    @POST
    @Path(value="/cancellationsReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public Response cancellationsReport(@QueryParam(value="startTime") String startTimeLongString, @QueryParam(value="endTime") String endTimeLongString, @QueryParam(value="localId") String localId, @QueryParam(value="name") String name, @QueryParam(value="type") String type, @QueryParam(value="reason") String reason, @QueryParam(value="noApprove") String noApprove, @QueryParam(value="sortStrategy") String sortStrategy, @DefaultValue(value="json") @QueryParam(value="output") String output) {
        ReportDTO dto = new ReportDTO();
        ArrayList<CancellationsReportResponseDTO> cancellationsReportResponseDTOs = new ArrayList();
        try {
            Date startTime = DateUtility.parseLong(startTimeLongString);
            Date endTime = DateUtility.parseLong(endTimeLongString);
            endTime = DateUtility.adjustToEndOfDay(endTime);
            cancellationsReportResponseDTOs = this.reportService.getCancellationsReport(Optional.of(this.getUser()), Optional.of(this.getRemoteHost()), Optional.of(startTime), Optional.of(endTime), Optional.ofNullable(localId), Optional.ofNullable(name), Optional.ofNullable(type), Optional.ofNullable(reason), Optional.ofNullable(noApprove), Optional.ofNullable(sortStrategy));
            dto.setCancellationsReport(cancellationsReportResponseDTOs);
            return this.handleListAndOutputChoice(cancellationsReportResponseDTOs, dto, output, "cancellations");
        }
        catch (Exception e) {
            cancellationsReportResponseDTOs.clear();
            String result = this.subjectMrnSkippingGson.toJson((Object)dto);
            return Response.ok((Object)result).build();
        }
    }

    @POST
    @Path(value="/resourceLevelOfServiceReport")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK, InstitutionRoleType.ROLE_GENERAL_VIEW})
    public Response resourceLevelOfServiceReport(@QueryParam(value="filterString") String filterString, @QueryParam(value="filterId") String filterId, @QueryParam(value="sortId") String sortId, @DefaultValue(value="json") @QueryParam(value="output") String output) {
        ReportDTO dto = new ReportDTO();
        ArrayList<WorkloadAndResourceResponseDTO> workloadAndResourceResponseDTOS = new ArrayList();
        try {
            dto.setFilterString(filterString);
            dto.setFilterId(filterId);
            dto.setSortId(sortId);
            workloadAndResourceResponseDTOS = this.reportService.getResourceLevelOfServiceReport(dto, Optional.of(this.getUser()), Optional.of(this.getRemoteHost()));
            dto.setWorkloadAndResourcesReport(workloadAndResourceResponseDTOS);
            return this.handleListAndOutputChoice(workloadAndResourceResponseDTOS, dto, output, "resource_level_of_service");
        }
        catch (Exception e) {
            workloadAndResourceResponseDTOS.clear();
            String result = this.subjectMrnSkippingGson.toJson((Object)dto);
            return Response.serverError().build();
        }
    }

    public static class BadReport {
        static BadReport instance = new BadReport();

        static BadReport getInstance() {
            return instance;
        }
    }
}

