/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.scheduler.entity.HasName;
import java.util.Optional;
import java.util.function.Function;

public interface ServiceHelpers {
    public static final String TO = " to ";
    public static final String NULL = ": NULL ";
    public static final String COLON = ": ";
    public static final String SPACE = " ";
    public static final String COMMA = ", ";

    default public String lookupFieldById(Integer id, Function<Integer, HasName> lookupField) {
        if (id != 0) {
            return lookupField.apply(id).getName();
        }
        return null;
    }

    default public <F> Optional<String> makeFieldString(String fieldName, F dtoField, F userField) {
        return this.makeFieldString(fieldName, dtoField, userField, Function.identity(), Function.identity());
    }

    default public <F> Optional<String> makeFieldString(String fieldName, F dtoField, F userField, Function<F, F> mungeUserField, Function<F, F> mungeDtoField) {
        if (userField != null && dtoField != null && !dtoField.equals(userField)) {
            return Optional.of(SPACE + fieldName + COLON + mungeUserField.apply(userField) + TO + mungeDtoField.apply(dtoField) + COMMA);
        }
        if (userField == null && dtoField != null) {
            return Optional.of(SPACE + fieldName + ": NULL  to " + mungeDtoField.apply(dtoField) + COMMA);
        }
        if (null == dtoField && userField != null) {
            return Optional.of(SPACE + fieldName + COLON + mungeUserField.apply(userField) + " to : NULL , ");
        }
        return Optional.empty();
    }

    default public <C, F extends HasName> Optional<String> makeFieldString(String fieldName, String mappedTo, F userField, C id, Function<F, C> getUserFieldToCompareTo) {
        return this.makeFieldString(fieldName, mappedTo, userField, id, getUserFieldToCompareTo, Function.identity(), Function.identity());
    }

    default public <C, F extends HasName> Optional<String> makeFieldString(String fieldName, String mappedTo, F userField, C id, Function<F, C> getUserFieldToCompareTo, Function<String, String> mungeUserField, Function<String, String> mungeMappedTo) {
        if (userField != null) {
            C userFieldToCompareTo = getUserFieldToCompareTo.apply(userField);
            if (!id.equals(userFieldToCompareTo) && mappedTo != null) {
                return Optional.of(SPACE + fieldName + COLON + mungeUserField.apply(userField.getName()) + TO + mungeMappedTo.apply(mappedTo) + COMMA);
            }
            if (null == mappedTo) {
                return Optional.of(SPACE + fieldName + COLON + mungeUserField.apply(userField.getName()) + " to : NULL , ");
            }
            return Optional.empty();
        }
        if (mappedTo != null) {
            return Optional.of(SPACE + fieldName + ": NULL  to " + mungeMappedTo.apply(mappedTo) + COMMA);
        }
        return Optional.empty();
    }
}

