/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml.trust;

import java.security.GeneralSecurityException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidator;
import java.security.cert.Certificate;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationOptions;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.saml.trust.MetadataCredentialResolver;

public class CertPathPKIXTrustEvaluator
extends org.opensaml.xml.security.x509.CertPathPKIXTrustEvaluator {
    private final Logger log = LoggerFactory.getLogger(MetadataCredentialResolver.class);
    private String securityProvider = null;
    private boolean validateCertPath = true;

    public CertPathPKIXTrustEvaluator() {
    }

    public CertPathPKIXTrustEvaluator(PKIXValidationOptions newOptions) {
        super(newOptions);
    }

    public boolean validate(PKIXValidationInformation validationInfo, X509Credential untrustedCredential) throws SecurityException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting PKIX path validation on untrusted credential: {}", (Object)X509Util.getIdentifiersToken((X509Credential)untrustedCredential, (X500DNHandler)this.getX500DNHandler()));
        }
        try {
            CertPathBuilder builder;
            PKIXBuilderParameters params = this.getPKIXBuilderParameters(validationInfo, untrustedCredential);
            if (this.securityProvider == null) {
                builder = CertPathBuilder.getInstance("PKIX");
                this.log.trace("Building certificate path using default security provider");
            } else {
                builder = CertPathBuilder.getInstance("PKIX", this.securityProvider);
                this.log.trace("Building certificate path using security provider {}", (Object)this.securityProvider);
            }
            PKIXCertPathBuilderResult buildResult = (PKIXCertPathBuilderResult)builder.build(params);
            if (this.log.isDebugEnabled()) {
                this.logCertPathDebug(buildResult, untrustedCredential.getEntityCertificate());
                this.log.debug("PKIX validation succeeded for untrusted credential: {}", (Object)X509Util.getIdentifiersToken((X509Credential)untrustedCredential, (X500DNHandler)this.getX500DNHandler()));
            }
            if (this.validateCertPath) {
                this.log.trace("Validating certificate path");
                CertPathValidator validator = this.securityProvider == null ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", this.securityProvider);
                validator.validate(buildResult.getCertPath(), params);
            }
            return true;
        }
        catch (CertPathBuilderException e) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("PKIX path construction failed for untrusted credential: " + X509Util.getIdentifiersToken((X509Credential)untrustedCredential, (X500DNHandler)this.getX500DNHandler()), (Throwable)e);
            } else {
                this.log.error("PKIX path construction failed for untrusted credential: " + X509Util.getIdentifiersToken((X509Credential)untrustedCredential, (X500DNHandler)this.getX500DNHandler()) + ": " + e.getMessage());
            }
            return false;
        }
        catch (GeneralSecurityException e) {
            this.log.error("PKIX validation failure", (Throwable)e);
            throw new SecurityException("PKIX validation failure", (Exception)e);
        }
    }

    private void logCertPathDebug(PKIXCertPathBuilderResult buildResult, X509Certificate targetCert) {
        this.log.debug("Built valid PKIX cert path");
        this.log.debug("Target certificate: {}", (Object)this.getX500DNHandler().getName(targetCert.getSubjectX500Principal()));
        for (Certificate certificate : buildResult.getCertPath().getCertificates()) {
            this.log.debug("CertPath certificate: {}", (Object)this.getX500DNHandler().getName(((X509Certificate)certificate).getSubjectX500Principal()));
        }
        TrustAnchor ta = buildResult.getTrustAnchor();
        if (ta.getTrustedCert() != null) {
            this.log.debug("TrustAnchor: {}", (Object)this.getX500DNHandler().getName(ta.getTrustedCert().getSubjectX500Principal()));
        } else if (ta.getCA() != null) {
            this.log.debug("TrustAnchor: {}", (Object)this.getX500DNHandler().getName(ta.getCA()));
        } else {
            this.log.debug("TrustAnchor: {}", (Object)ta.getCAName());
        }
    }

    public void setSecurityProvider(String provider) {
        this.securityProvider = provider;
    }

    public void setValidateCertPath(boolean validateCertPath) {
        this.validateCertPath = validateCertPath;
    }
}

