/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.CsvAbleDTO;
import edu.harvard.catalyst.scheduler.dto.response.FundingSourceInfo;
import edu.harvard.catalyst.scheduler.entity.IRBInstitution;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudyFundingSource;
import edu.harvard.catalyst.scheduler.entity.StudyStatus;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StudyDataReportResponseDTO
implements CsvAbleDTO {
    private String catalystId;
    private String localId;
    private String name;
    private DtoInstitution institution;
    private DtoStudyStatus studyStatus;
    private Date expectedStartDate;
    private Date expectedEndDate;
    private Date statusChange;
    private Date firstVisitDate;
    private Date lastScheduledVisitDate;
    private String irb;
    private Date irbExpiration;
    private Date irbRenewalDate;
    private Date irbApprovalDate;
    private Integer totalSubjects;
    private Integer totalOutpatientVisits;
    private Integer totalInpatientVisits;
    private Boolean industryInitiated;
    private User4 investigator;
    private User4 physician;
    private User4 physician2;
    private User3 scheduler;
    private User3 secondaryScheduler;
    private User3 scheduler3;
    private User1 protocolNurse;
    private User1 associateNurse;
    private User1 protocolNutritionist;
    private User1 associateProtocolNutritionist;
    private Boolean crcFunded;
    private String crcCategory;
    private DtoIrbInstitution irbInstitution;
    private List<FundingSourceInfo> fundingSourceInfoList = new ArrayList<FundingSourceInfo>();
    private Map<Integer, FundingSourceInfo> integerToFundingSourceMap = Maps.newHashMap();

    public StudyDataReportResponseDTO(Study study, Set<StudyFundingSource> sfsSet) {
        if (study == null) {
            SchedulerRuntimeException.logAndThrow("Study parameter should be non-null");
        }
        this.catalystId = study.getCatalystId();
        this.localId = study.getLocalId();
        this.irb = study.getIrb();
        this.irbExpiration = study.getIrbExpiration();
        this.irbRenewalDate = study.getIrbRenewalDate();
        this.irbApprovalDate = study.getIrbApprovalDate();
        this.statusChange = study.getStatusChange();
        this.firstVisitDate = study.getFirstVisitDate();
        this.lastScheduledVisitDate = study.getLastScheduledVisitDate();
        this.name = study.getName();
        this.industryInitiated = study.getIndustryInitiated();
        this.totalSubjects = study.getTotalSubjects();
        this.totalOutpatientVisits = study.getTotalOutpatientVisits();
        for (StudyFundingSource sfs : sfsSet) {
            FundingSourceInfo fsi = new FundingSourceInfo(sfs);
            this.fundingSourceInfoList.add(fsi);
            this.integerToFundingSourceMap.put(fsi.getOneToFour(), fsi);
        }
        this.studyStatus = new DtoStudyStatus(study.getStudyStatus());
        this.institution = new DtoInstitution(study.getInstitution());
        this.irbInstitution = new DtoIrbInstitution(study.getIrbInstitution());
        this.investigator = new User4(study.getInvestigator());
        this.physician = new User4(study.getPhysician());
        this.physician2 = new User4(study.getPhysician2());
        this.scheduler = new User3(study.getScheduler());
        this.secondaryScheduler = new User3(study.getSecondaryScheduler());
        this.scheduler3 = new User3(study.getScheduler3());
        this.protocolNurse = new User1(study.getProtocolNurse());
        this.associateNurse = new User1(study.getAssociateNurse());
        this.protocolNutritionist = new User1(study.getProtocolNutritionist());
        this.associateProtocolNutritionist = new User1(study.getAssociateProtocolNutritionist());
        this.expectedStartDate = study.getExpectedStartDate();
        this.expectedEndDate = study.getExpectedEndDate();
        this.totalInpatientVisits = study.getTotalInpatientVisits();
        this.crcCategory = study.getCrcCategory();
        this.crcFunded = study.getCrcFunded();
    }

    @Override
    public String toCsvHeaders() {
        return "Study Name,Institution,Local ID,Catalyst ID,Status,Last Status Change,IRB #,IRB Institution,IRB Approval Date,IRB Renewal Date,IRB Expiration Date,CRC Approved,CRC Category,Industry Initiated,Start Date,End Date,First Visit Date,Last Scheduled Visit Date,Total Inpatient Visits,Total Outpatient Visits,Total Subjects,Funding Source 1,Funding Centers and Institutes 1,Funding Grant ID 1,Funding Site Cost Center 1,Funding Total Direct Dollar Award 1,Funding Total Indirect Dollar Award 1,Funding Project Start Date 1,Funding Project End Date 1,Funding Comment 1,Funding Source 2,Funding Centers and Institutes 2,Funding Grant ID 2,Funding Site Cost Center 2,Funding Total Direct Dollar Award 2,Funding Total Indirect Dollar Award 2,Funding Project Start Date 2,Funding Project End Date 2,Funding Comment 2,Funding Source 3,Funding Centers and Institutes 3,Funding Grant ID 3,Funding Site Cost Center 3,Funding Total Direct Dollar Award 3,Funding Total Indirect Dollar Award 3,Funding Project Start Date 3,Funding Project End Date 3,Funding Comment 3,Funding Source 4,Funding Centers and Institutes 4,Funding Grant ID 4,Funding Site Cost Center 4,Funding Total Direct Dollar Award 4,Funding Total Indirect Dollar Award 4,Funding Project Start Date 4,Funding Project End Date 4,Funding Comment 4,PI Name,PI Email,PI Phone #1,PI Pager,Primary Scheduling Contact,Primary Scheduling Contact Email,Primary Scheduling Contact Phone,Secondary Scheduling Contact,Secondary Scheduling Contact Email,Secondary Scheduling Contact Phone,Third Scheduling Contact,Third Scheduling Contact Email,Third Scheduling Contact Phone,Responsible Physician 1,Responsible Physician 1 email,Responsible Physician 1 Phone#1,Responsible Physician 1 Pager,Responsible Physician 2,Responsible Physician 2 Email,Responsible Physician 2 Phone#1,Responsible Physician 2 Pager,Protocol Nurse,Associate Protocol Nurse,Protocol Nutritionist,Associate Protocol Nutritionist";
    }

    void addFundingSourceColumns(List<String> columns, StudyDataReportResponseDTO s) {
        for (int i = 1; i <= 4; ++i) {
            FundingSourceInfo fundingSourceInfo = s.integerToFundingSourceMap.get(i);
            if (fundingSourceInfo == null) {
                fundingSourceInfo = FundingSourceInfo.makeBlankFundingSourceInfo();
            }
            columns.add(MiscUtil.q(fundingSourceInfo.getName()));
            columns.add(MiscUtil.q(fundingSourceInfo.getCenterAndInstitutionName()));
            columns.add(MiscUtil.q(fundingSourceInfo.getGrant()));
            columns.add(MiscUtil.q(fundingSourceInfo.getCenter()));
            columns.add(MiscUtil.q(fundingSourceInfo.getDirectAward()));
            columns.add(MiscUtil.q(fundingSourceInfo.getIndirectAward()));
            columns.add(MiscUtil.q(MiscUtil.showDate(fundingSourceInfo.getStart())));
            columns.add(MiscUtil.q(MiscUtil.showDate(fundingSourceInfo.getEnd())));
            columns.add(MiscUtil.q(fundingSourceInfo.getComment()));
        }
    }

    @Override
    public List<String> toCsvRows(List<?> dtoList) {
        ArrayList result = Lists.newArrayList();
        result.add(this.toCsvHeaders() + "\n");
        for (Object object : dtoList) {
            StudyDataReportResponseDTO s = (StudyDataReportResponseDTO)object;
            ArrayList columns = Lists.newArrayList();
            columns.add(MiscUtil.q(s.name));
            columns.add(MiscUtil.q(s.institution.longName));
            columns.add(MiscUtil.q(s.localId));
            columns.add(MiscUtil.q(s.catalystId));
            columns.add(MiscUtil.q(s.studyStatus.shortName));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(s.statusChange)));
            columns.add(MiscUtil.q(s.irb));
            columns.add(MiscUtil.q(s.irbInstitution.name));
            columns.add(MiscUtil.q(MiscUtil.showDate(s.irbApprovalDate)));
            columns.add(MiscUtil.q(MiscUtil.showDate(s.irbRenewalDate)));
            columns.add(MiscUtil.q(MiscUtil.showDate(s.irbExpiration)));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(s.crcFunded)));
            columns.add(MiscUtil.q(s.crcCategory));
            columns.add(MiscUtil.q(MiscUtil.yesNoValue(s.industryInitiated)));
            columns.add(MiscUtil.q(MiscUtil.showDate(s.expectedStartDate)));
            columns.add(MiscUtil.q(MiscUtil.showDate(s.expectedEndDate)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(s.firstVisitDate)));
            columns.add(MiscUtil.q(MiscUtil.showDateTime(s.lastScheduledVisitDate)));
            columns.add(MiscUtil.q(String.valueOf(s.totalInpatientVisits)));
            columns.add(MiscUtil.q(String.valueOf(s.totalOutpatientVisits)));
            columns.add(MiscUtil.q(String.valueOf(s.totalSubjects)));
            this.addFundingSourceColumns(columns, s);
            columns.add(MiscUtil.q(MiscUtil.fullName(s.investigator.firstName, s.investigator.middleName, s.investigator.lastName)));
            columns.add(MiscUtil.q(s.investigator.email));
            columns.add(MiscUtil.q(s.investigator.primaryPhone));
            columns.add(MiscUtil.q(s.investigator.pager));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.scheduler.firstName, s.scheduler.middleName, s.scheduler.lastName)));
            columns.add(MiscUtil.q(s.scheduler.email));
            columns.add(MiscUtil.q(s.scheduler.primaryPhone));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.secondaryScheduler.firstName, s.secondaryScheduler.middleName, s.secondaryScheduler.lastName)));
            columns.add(MiscUtil.q(s.secondaryScheduler.email));
            columns.add(MiscUtil.q(s.secondaryScheduler.primaryPhone));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.scheduler3.firstName, s.scheduler3.middleName, s.scheduler3.lastName)));
            columns.add(MiscUtil.q(s.scheduler3.email));
            columns.add(MiscUtil.q(s.scheduler3.primaryPhone));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.physician.firstName, s.physician.middleName, s.physician.lastName)));
            columns.add(MiscUtil.q(s.physician.email));
            columns.add(MiscUtil.q(s.physician.primaryPhone));
            columns.add(MiscUtil.q(s.physician.pager));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.physician2.firstName, s.physician2.middleName, s.physician2.lastName)));
            columns.add(MiscUtil.q(s.physician2.email));
            columns.add(MiscUtil.q(s.physician2.primaryPhone));
            columns.add(MiscUtil.q(s.physician2.pager));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.protocolNurse.firstName, s.protocolNurse.middleName, s.protocolNurse.lastName)));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.associateNurse.firstName, s.associateNurse.middleName, s.associateNurse.lastName)));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.protocolNutritionist.firstName, s.protocolNutritionist.middleName, s.protocolNutritionist.lastName)));
            columns.add(MiscUtil.q(MiscUtil.fullName(s.associateProtocolNutritionist.firstName, s.associateProtocolNutritionist.middleName, s.associateProtocolNutritionist.lastName)));
            String rows = Joiner.on((String)",").join((Iterable)columns);
            result.add(rows + "\n");
        }
        return result;
    }

    class User1 {
        String firstName = "";
        String middleName = "";
        String lastName = "";

        User1(User user) {
            if (user == null) {
                return;
            }
            this.firstName = user.getFirstName();
            this.middleName = user.getMiddleName();
            this.lastName = user.getLastName();
        }
    }

    class User3 {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        String email = "";
        String primaryPhone = "";

        User3(User user) {
            if (user == null) {
                return;
            }
            this.firstName = user.getFirstName();
            this.middleName = user.getMiddleName();
            this.lastName = user.getLastName();
            this.email = user.getEmail();
            this.primaryPhone = user.getPrimaryPhone();
        }
    }

    class User4 {
        String firstName = "";
        String middleName = "";
        String lastName = "";
        String email = "";
        String primaryPhone = "";
        String pager = "";

        User4(User user) {
            if (user == null) {
                return;
            }
            this.firstName = user.getFirstName();
            this.middleName = user.getMiddleName();
            this.lastName = user.getLastName();
            this.email = user.getEmail();
            this.primaryPhone = user.getPrimaryPhone();
            this.pager = user.getPager();
        }
    }

    class DtoIrbInstitution {
        String name = "";

        DtoIrbInstitution(IRBInstitution irbInstitution1) {
            if (irbInstitution1 == null) {
                return;
            }
            this.name = irbInstitution1.getName();
        }
    }

    class DtoInstitution {
        String longName = "";

        DtoInstitution(Institution institution1) {
            if (institution1 == null) {
                return;
            }
            this.longName = institution1.getLongName();
        }
    }

    class DtoStudyStatus {
        String shortName = "";

        DtoStudyStatus(StudyStatus studyStatus1) {
            if (studyStatus1 == null) {
                return;
            }
            this.shortName = studyStatus1.getShortName();
        }
    }
}

