/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.encryption;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLRuntimeException;
import org.opensaml.xml.encryption.DecryptionException;
import org.opensaml.xml.encryption.EncryptedData;
import org.opensaml.xml.encryption.EncryptedKey;
import org.opensaml.xml.encryption.EncryptedKeyResolver;
import org.opensaml.xml.encryption.EncryptedType;
import org.opensaml.xml.encryption.EncryptionMethod;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.StaticBasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.KeyAlgorithmCriteria;
import org.opensaml.xml.security.criteria.KeyLengthCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCriteria;
import org.opensaml.xml.signature.DigestMethod;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Decrypter {
    private final ParserPool parserPool;
    private UnmarshallerFactory unmarshallerFactory;
    private final Logger log = LoggerFactory.getLogger(Decrypter.class);
    private KeyInfoCredentialResolver resolver;
    private KeyInfoCredentialResolver kekResolver;
    private EncryptedKeyResolver encKeyResolver;
    private CriteriaSet resolverCriteria;
    private CriteriaSet kekResolverCriteria;
    private String jcaProviderName;
    private boolean defaultRootInNewDocument;

    public Decrypter(KeyInfoCredentialResolver newResolver, KeyInfoCredentialResolver newKEKResolver, EncryptedKeyResolver newEncKeyResolver) {
        this.resolver = newResolver;
        this.kekResolver = newKEKResolver;
        this.encKeyResolver = newEncKeyResolver;
        this.resolverCriteria = null;
        this.kekResolverCriteria = null;
        this.parserPool = this.buildParserPool();
        this.unmarshallerFactory = Configuration.getUnmarshallerFactory();
        this.defaultRootInNewDocument = false;
    }

    public boolean isRootInNewDocument() {
        return this.defaultRootInNewDocument;
    }

    public void setRootInNewDocument(boolean flag) {
        this.defaultRootInNewDocument = flag;
    }

    public String getJCAProviderName() {
        return this.jcaProviderName;
    }

    public void setJCAProviderName(String providerName) {
        this.jcaProviderName = providerName;
    }

    public KeyInfoCredentialResolver getKeyResolver() {
        return this.resolver;
    }

    public void setKeyResolver(KeyInfoCredentialResolver newResolver) {
        this.resolver = newResolver;
    }

    public KeyInfoCredentialResolver getKEKResolver() {
        return this.kekResolver;
    }

    public void setKEKResolver(KeyInfoCredentialResolver newKEKResolver) {
        this.kekResolver = newKEKResolver;
    }

    public EncryptedKeyResolver getEncryptedKeyResolver() {
        return this.encKeyResolver;
    }

    public void setEncryptedKeyResolver(EncryptedKeyResolver newResolver) {
        this.encKeyResolver = newResolver;
    }

    public CriteriaSet setKeyResolverCriteria() {
        return this.resolverCriteria;
    }

    public void setKeyResolverCriteria(CriteriaSet newCriteria) {
        this.resolverCriteria = newCriteria;
    }

    public CriteriaSet getKEKResolverCriteria() {
        return this.kekResolverCriteria;
    }

    public void setKEKResolverCriteria(CriteriaSet newCriteria) {
        this.kekResolverCriteria = newCriteria;
    }

    public XMLObject decryptData(EncryptedData encryptedData) throws DecryptionException {
        return this.decryptData(encryptedData, this.isRootInNewDocument());
    }

    public XMLObject decryptData(EncryptedData encryptedData, boolean rootInNewDocument) throws DecryptionException {
        List<XMLObject> xmlObjects = this.decryptDataToList(encryptedData, rootInNewDocument);
        if (xmlObjects.size() != 1) {
            this.log.error("The decrypted data contained more than one top-level XMLObject child");
            throw new DecryptionException("The decrypted data contained more than one XMLObject child");
        }
        return xmlObjects.get(0);
    }

    public List<XMLObject> decryptDataToList(EncryptedData encryptedData) throws DecryptionException {
        return this.decryptDataToList(encryptedData, this.isRootInNewDocument());
    }

    public List<XMLObject> decryptDataToList(EncryptedData encryptedData, boolean rootInNewDocument) throws DecryptionException {
        LinkedList<XMLObject> xmlObjects = new LinkedList<XMLObject>();
        DocumentFragment docFragment = this.decryptDataToDOM(encryptedData);
        NodeList children = docFragment.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XMLObject xmlObject;
            Node node = children.item(i);
            if (node.getNodeType() != 1) {
                this.log.error("Decryption returned a top-level node that was not of type Element: " + node.getNodeType());
                throw new DecryptionException("Top-level node was not of type Element");
            }
            Element element = (Element)node;
            if (rootInNewDocument) {
                Document newDoc = null;
                try {
                    newDoc = this.parserPool.newDocument();
                }
                catch (XMLParserException e) {
                    this.log.error("There was an error creating a new DOM Document", (Throwable)e);
                    throw new DecryptionException("Error creating new DOM Document", e);
                }
                newDoc.adoptNode(element);
                newDoc.appendChild(element);
            }
            try {
                Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(element);
                if (unmarshaller == null && (unmarshaller = this.unmarshallerFactory.getUnmarshaller(Configuration.getDefaultProviderQName())) == null) {
                    String errorMsg = "Unable to locate unmarshaller for " + XMLHelper.getNodeQName(element);
                    this.log.error(errorMsg);
                    throw new DecryptionException(errorMsg);
                }
                xmlObject = unmarshaller.unmarshall(element);
            }
            catch (UnmarshallingException e) {
                this.log.error("There was an error during unmarshalling of the decrypted element", (Throwable)e);
                throw new DecryptionException("Unmarshalling error during decryption", e);
            }
            xmlObjects.add(xmlObject);
        }
        return xmlObjects;
    }

    public DocumentFragment decryptDataToDOM(EncryptedData encryptedData) throws DecryptionException {
        String algorithm;
        if (this.resolver == null && this.encKeyResolver == null) {
            this.log.error("Decryption can not be attempted, required resolvers are not available");
            throw new DecryptionException("Unable to decrypt EncryptedData, required resolvers are not available");
        }
        DocumentFragment docFrag = null;
        if (this.resolver != null) {
            docFrag = this.decryptUsingResolvedKey(encryptedData);
            if (docFrag != null) {
                return docFrag;
            }
            this.log.debug("Failed to decrypt EncryptedData using standard KeyInfo resolver");
        }
        if (DatatypeHelper.isEmpty(algorithm = encryptedData.getEncryptionMethod().getAlgorithm())) {
            String msg = "EncryptedData's EncryptionMethod Algorithm attribute was empty, key decryption could not be attempted";
            this.log.error(msg);
            throw new DecryptionException(msg);
        }
        if (this.encKeyResolver != null) {
            docFrag = this.decryptUsingResolvedEncryptedKey(encryptedData, algorithm);
            if (docFrag != null) {
                return docFrag;
            }
            this.log.debug("Failed to decrypt EncryptedData using EncryptedKeyResolver");
        }
        this.log.error("Failed to decrypt EncryptedData using either EncryptedData KeyInfoCredentialResolver or EncryptedKeyResolver + EncryptedKey KeyInfoCredentialResolver");
        throw new DecryptionException("Failed to decrypt EncryptedData");
    }

    public DocumentFragment decryptDataToDOM(EncryptedData encryptedData, Key dataEncKey) throws DecryptionException {
        XMLCipher xmlCipher;
        if (!"http://www.w3.org/2001/04/xmlenc#Element".equals(encryptedData.getType())) {
            this.log.error("EncryptedData was of unsupported type '" + encryptedData.getType() + "', could not attempt decryption");
            throw new DecryptionException("EncryptedData of unsupported type was encountered");
        }
        if (dataEncKey == null) {
            this.log.error("Data decryption key was null");
            throw new IllegalArgumentException("Data decryption key may not be null");
        }
        try {
            this.checkAndMarshall(encryptedData);
        }
        catch (DecryptionException e) {
            this.log.error("Error marshalling EncryptedData for decryption", (Throwable)e);
            throw e;
        }
        Element targetElement = encryptedData.getDOM();
        try {
            xmlCipher = this.getJCAProviderName() != null ? XMLCipher.getProviderInstance((String)this.getJCAProviderName()) : XMLCipher.getInstance();
            xmlCipher.init(2, dataEncKey);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error initialzing cipher instance on data decryption", (Throwable)e);
            throw new DecryptionException("Error initialzing cipher instance on data decryption", (Exception)((Object)e));
        }
        byte[] bytes = null;
        try {
            bytes = xmlCipher.decryptToByteArray(targetElement);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error decrypting the encrypted data element", (Throwable)e);
            throw new DecryptionException("Error decrypting the encrypted data element", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DecryptionException("Probable runtime exception on decryption:" + e.getMessage(), e);
        }
        if (bytes == null) {
            throw new DecryptionException("EncryptedData could not be decrypted");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(bytes);
        DocumentFragment docFragment = this.parseInputStream(input, encryptedData.getDOM().getOwnerDocument());
        return docFragment;
    }

    public Key decryptKey(EncryptedKey encryptedKey, String algorithm) throws DecryptionException {
        if (this.kekResolver == null) {
            this.log.warn("No KEK KeyInfo credential resolver is available, can not attempt EncryptedKey decryption");
            throw new DecryptionException("No KEK KeyInfo resolver is available for EncryptedKey decryption");
        }
        if (DatatypeHelper.isEmpty(algorithm)) {
            this.log.error("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
        }
        CriteriaSet criteriaSet = this.buildCredentialCriteria(encryptedKey, this.kekResolverCriteria);
        try {
            for (Credential cred : this.kekResolver.resolve(criteriaSet)) {
                try {
                    return this.decryptKey(encryptedKey, algorithm, SecurityHelper.extractDecryptionKey(cred));
                }
                catch (DecryptionException e) {
                    String msg = "Attempt to decrypt EncryptedKey using credential from KEK KeyInfo resolver failed: ";
                    this.log.debug(msg, (Throwable)e);
                }
            }
        }
        catch (SecurityException e) {
            this.log.error("Error resolving credentials from EncryptedKey KeyInfo", (Throwable)e);
        }
        this.log.error("Failed to decrypt EncryptedKey, valid decryption key could not be resolved");
        throw new DecryptionException("Valid decryption key for EncryptedKey could not be resolved");
    }

    public Key decryptKey(EncryptedKey encryptedKey, String algorithm, Key kek) throws DecryptionException {
        org.apache.xml.security.encryption.EncryptedKey encKey;
        XMLCipher xmlCipher;
        if (kek == null) {
            this.log.error("Data encryption key was null");
            throw new IllegalArgumentException("Data encryption key may not be null");
        }
        if (DatatypeHelper.isEmpty(algorithm)) {
            this.log.error("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
            throw new DecryptionException("Algorithm of encrypted key not supplied, key decryption cannot proceed.");
        }
        try {
            this.checkAndMarshall(encryptedKey);
        }
        catch (DecryptionException e) {
            this.log.error("Error marshalling EncryptedKey for decryption", (Throwable)e);
            throw e;
        }
        this.preProcessEncryptedKey(encryptedKey, algorithm, kek);
        Element targetElement = encryptedKey.getDOM();
        try {
            xmlCipher = this.getJCAProviderName() != null ? XMLCipher.getProviderInstance((String)this.getJCAProviderName()) : XMLCipher.getInstance();
            xmlCipher.init(4, kek);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error initialzing cipher instance on key decryption", (Throwable)e);
            throw new DecryptionException("Error initialzing cipher instance on key decryption", (Exception)((Object)e));
        }
        try {
            encKey = xmlCipher.loadEncryptedKey(targetElement.getOwnerDocument(), targetElement);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error when loading library native encrypted key representation", (Throwable)e);
            throw new DecryptionException("Error when loading library native encrypted key representation", (Exception)((Object)e));
        }
        Key key = null;
        try {
            key = xmlCipher.decryptKey(encKey, algorithm);
        }
        catch (XMLEncryptionException e) {
            this.log.error("Error decrypting encrypted key", (Throwable)e);
            throw new DecryptionException("Error decrypting encrypted key", (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new DecryptionException("Probable runtime exception on decryption:" + e.getMessage(), e);
        }
        if (key == null) {
            throw new DecryptionException("Key could not be decrypted");
        }
        return key;
    }

    protected void preProcessEncryptedKey(EncryptedKey encryptedKey, String algorithm, Key kek) throws DecryptionException {
        DigestMethod dm;
        List<XMLObject> digestMethods;
        String keyTransportAlgorithm = encryptedKey.getEncryptionMethod().getAlgorithm();
        if ("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p".equals(keyTransportAlgorithm) && !(digestMethods = encryptedKey.getEncryptionMethod().getUnknownXMLObjects(DigestMethod.DEFAULT_ELEMENT_NAME)).isEmpty() && !"http://www.w3.org/2000/09/xmldsig#sha1".equals(DatatypeHelper.safeTrimOrNullString((dm = (DigestMethod)digestMethods.get(0)).getAlgorithm()))) {
            this.log.error("EncryptedKey/EncryptionMethod/DigestMethod contains unsupported algorithm URI: {}", (Object)dm.getAlgorithm());
            throw new DecryptionException("EncryptedKey/EncryptionMethod/DigestMethod contains unsupported algorithm URI");
        }
    }

    private DocumentFragment decryptUsingResolvedKey(EncryptedData encryptedData) {
        if (this.resolver != null) {
            CriteriaSet criteriaSet = this.buildCredentialCriteria(encryptedData, this.resolverCriteria);
            try {
                for (Credential cred : this.resolver.resolve(criteriaSet)) {
                    try {
                        return this.decryptDataToDOM(encryptedData, SecurityHelper.extractDecryptionKey(cred));
                    }
                    catch (DecryptionException e) {
                        String msg = "Decryption attempt using credential from standard KeyInfo resolver failed: ";
                        this.log.debug(msg, (Throwable)e);
                    }
                }
            }
            catch (SecurityException e) {
                this.log.error("Error resolving credentials from EncryptedData KeyInfo", (Throwable)e);
            }
        }
        return null;
    }

    private DocumentFragment decryptUsingResolvedEncryptedKey(EncryptedData encryptedData, String algorithm) {
        if (this.encKeyResolver != null) {
            for (EncryptedKey encryptedKey : this.encKeyResolver.resolve(encryptedData)) {
                try {
                    Key decryptedKey = this.decryptKey(encryptedKey, algorithm);
                    return this.decryptDataToDOM(encryptedData, decryptedKey);
                }
                catch (DecryptionException e) {
                    String msg = "Attempt to decrypt EncryptedData using key extracted from EncryptedKey failed: ";
                    this.log.debug(msg, (Throwable)e);
                }
            }
        }
        return null;
    }

    private DocumentFragment parseInputStream(InputStream input, Document owningDocument) throws DecryptionException {
        Document newDocument = null;
        try {
            newDocument = this.parserPool.parse(input);
        }
        catch (XMLParserException e) {
            this.log.error("Error parsing decrypted input stream", (Throwable)e);
            throw new DecryptionException("Error parsing input stream", e);
        }
        Element element = newDocument.getDocumentElement();
        owningDocument.adoptNode(element);
        DocumentFragment container = owningDocument.createDocumentFragment();
        container.appendChild(element);
        return container;
    }

    private CriteriaSet buildCredentialCriteria(EncryptedType encryptedType, CriteriaSet staticCriteria) {
        CriteriaSet newCriteriaSet = new CriteriaSet();
        newCriteriaSet.add(new KeyInfoCriteria(encryptedType.getKeyInfo()));
        Set<Criteria> keyCriteria = this.buildKeyCriteria(encryptedType);
        if (keyCriteria != null && !keyCriteria.isEmpty()) {
            newCriteriaSet.addAll(keyCriteria);
        }
        if (staticCriteria != null && !staticCriteria.isEmpty()) {
            newCriteriaSet.addAll(staticCriteria);
        }
        if (!newCriteriaSet.contains(UsageCriteria.class)) {
            newCriteriaSet.add(new UsageCriteria(UsageType.ENCRYPTION));
        }
        return newCriteriaSet;
    }

    private Set<Criteria> buildKeyCriteria(EncryptedType encryptedType) {
        KeyLengthCriteria lengthCrit;
        EncryptionMethod encMethod = encryptedType.getEncryptionMethod();
        if (encMethod == null) {
            return Collections.emptySet();
        }
        String encAlgorithmURI = DatatypeHelper.safeTrimOrNullString(encMethod.getAlgorithm());
        if (encAlgorithmURI == null) {
            return Collections.emptySet();
        }
        HashSet<Criteria> critSet = new HashSet<Criteria>(2);
        KeyAlgorithmCriteria algoCrit = this.buildKeyAlgorithmCriteria(encAlgorithmURI);
        if (algoCrit != null) {
            critSet.add(algoCrit);
            this.log.debug("Added decryption key algorithm criteria: {}", (Object)algoCrit.getKeyAlgorithm());
        }
        if ((lengthCrit = this.buildKeyLengthCriteria(encAlgorithmURI)) != null) {
            critSet.add(lengthCrit);
            this.log.debug("Added decryption key length criteria from EncryptionMethod algorithm URI: {}", (Object)lengthCrit.getKeyLength());
        } else if (encMethod.getKeySize() != null && encMethod.getKeySize().getValue() != null) {
            lengthCrit = new KeyLengthCriteria(encMethod.getKeySize().getValue());
            critSet.add(lengthCrit);
            this.log.debug("Added decryption key length criteria from EncryptionMethod/KeySize: {}", (Object)lengthCrit.getKeyLength());
        }
        return critSet;
    }

    private KeyAlgorithmCriteria buildKeyAlgorithmCriteria(String encAlgorithmURI) {
        if (DatatypeHelper.isEmpty(encAlgorithmURI)) {
            return null;
        }
        String jcaKeyAlgorithm = SecurityHelper.getKeyAlgorithmFromURI(encAlgorithmURI);
        if (!DatatypeHelper.isEmpty(jcaKeyAlgorithm)) {
            return new KeyAlgorithmCriteria(jcaKeyAlgorithm);
        }
        return null;
    }

    private KeyLengthCriteria buildKeyLengthCriteria(String encAlgorithmURI) {
        if (!DatatypeHelper.isEmpty(encAlgorithmURI)) {
            return null;
        }
        Integer keyLength = SecurityHelper.getKeyLengthFromURI(encAlgorithmURI);
        if (keyLength != null) {
            return new KeyLengthCriteria(keyLength);
        }
        return null;
    }

    protected void checkAndMarshall(XMLObject xmlObject) throws DecryptionException {
        Element targetElement = xmlObject.getDOM();
        if (targetElement == null) {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(xmlObject);
            if (marshaller == null && (marshaller = Configuration.getMarshallerFactory().getMarshaller(Configuration.getDefaultProviderQName())) == null) {
                String errorMsg = "No marshaller available for " + xmlObject.getElementQName();
                this.log.error(errorMsg);
                throw new DecryptionException(errorMsg);
            }
            try {
                targetElement = marshaller.marshall(xmlObject);
            }
            catch (MarshallingException e) {
                this.log.error("Error marshalling target XMLObject", (Throwable)e);
                throw new DecryptionException("Error marshalling target XMLObject", e);
            }
        }
    }

    protected ParserPool buildParserPool() {
        StaticBasicParserPool pp = new StaticBasicParserPool();
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        pp.setNamespaceAware(true);
        features.put("http://apache.org/xml/features/dom/defer-node-expansion", Boolean.FALSE);
        pp.setExpandEntityReferences(false);
        features.put("http://javax.xml.XMLConstants/feature/secure-processing", true);
        features.put("http://apache.org/xml/features/disallow-doctype-decl", true);
        pp.setBuilderFeatures(features);
        try {
            pp.initialize();
            return pp;
        }
        catch (XMLParserException e) {
            throw new XMLRuntimeException("Problem initializing Decrypter internal ParserPool", e);
        }
    }

    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

