/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.RoleType;
import java.util.Map;

public class RolePair {
    private RoleType userRole;
    private InstitutionRoleType institutionRole;
    private static Map<RolePair, Boolean> rolePairMap = Maps.newHashMap();

    public static Map<RolePair, Boolean> getRolePairMap() {
        return rolePairMap;
    }

    public RolePair(RoleType userRole, InstitutionRoleType institutionRole) {
        this.userRole = userRole;
        this.institutionRole = institutionRole;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RolePair rolePair = (RolePair)o;
        if (this.institutionRole != rolePair.institutionRole) {
            return false;
        }
        return this.userRole == rolePair.userRole;
    }

    public int hashCode() {
        int result = this.userRole != null ? this.userRole.hashCode() : 0;
        result = 31 * result + (this.institutionRole != null ? this.institutionRole.hashCode() : 0);
        return result;
    }

    static {
        rolePairMap.put(new RolePair(RoleType.ROLE_NURSE_MANAGER_DIRECTOR, InstitutionRoleType.ROLE_SUPER_ADMIN), true);
        rolePairMap.put(new RolePair(RoleType.ROLE_NUTRITION_MANAGER, InstitutionRoleType.ROLE_SUPER_ADMIN), true);
        rolePairMap.put(new RolePair(RoleType.ROLE_ADMINISTRATIVE_DIRECTOR, InstitutionRoleType.ROLE_SUPER_ADMIN), true);
        rolePairMap.put(new RolePair(RoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_SUPER_ADMIN), true);
        rolePairMap.put(new RolePair(RoleType.ROLE_NUTRITION_MANAGER, InstitutionRoleType.ROLE_RESOURCE_MANAGER), true);
        rolePairMap.put(new RolePair(RoleType.ROLE_NURSE_MANAGER_DIRECTOR, InstitutionRoleType.ROLE_RESOURCE_MANAGER), true);
        rolePairMap.put(new RolePair(RoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_SCHEDULER), true);
    }
}

