/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import edu.harvard.catalyst.scheduler.dto.AddStudyMembersDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.TemplateApprovalHistoryDTO;
import edu.harvard.catalyst.scheduler.dto.VisitDTO;
import edu.harvard.catalyst.scheduler.dto.request.BooleanRequest;
import edu.harvard.catalyst.scheduler.dto.request.VisitTemplatesRequest;
import edu.harvard.catalyst.scheduler.dto.response.GetStudiesResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudySubjectsResponse;
import edu.harvard.catalyst.scheduler.dto.response.StudyDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.StudyDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.UserDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitApprovalModelResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitCommentsResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplateDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplatesResponse;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.StudyUser;
import edu.harvard.catalyst.scheduler.entity.TemplateApprovalHistory;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.StudyService;
import edu.harvard.catalyst.scheduler.web.SecuredResource;
import java.util.List;
import java.util.Optional;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/study")
@Singleton
@Component
public class StudyResource
extends SecuredResource {
    StudyService service;

    @Autowired
    public StudyResource(StudyService service) {
        this.service = service;
    }

    StudyResource() {
    }

    @GET
    @Path(value="/getNonClosedStudiesList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getNonClosedStudiesList() {
        int userId = this.getUser().getId();
        GetStudiesResponse studies = this.getSubjectStudiesList(userId);
        return this.gson.toJson((Object)studies);
    }

    public GetStudiesResponse getSubjectStudiesList(int userId) {
        return this.service.getSubjectStudies(userId);
    }

    @GET
    @Path(value="/getTemplatesToApprove")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String getTemplatesToApprove(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        List<VisitTemplatesResponse> approvalTemplates = this.templateApprovalList(sortBy, orderBy, page, maxResults, this.getUser().getId(), this.getRemoteHost());
        return this.gson.toJson(approvalTemplates);
    }

    List<VisitTemplatesResponse> templateApprovalList(String sortBy, String orderBy, int page, int maxResults, int user, String ipAddress) {
        return this.service.getTemplatesToApprove(sortBy, orderBy, page, maxResults, user, ipAddress);
    }

    @GET
    @Path(value="/getVisitApprovals")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getVisitApprovals(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="visit") int visitId) {
        List<VisitApprovalModelResponseDTO.VisitApproval> templateApprovers = this.getVisitApprovalsList(sortBy, orderBy, page, maxResults, visitId);
        return this.gson.toJson(templateApprovers);
    }

    List<VisitApprovalModelResponseDTO.VisitApproval> getVisitApprovalsList(String sortBy, String orderBy, int page, int maxResults, int visitId) {
        return this.service.getVisitApprovals(visitId, sortBy, orderBy, page, maxResults);
    }

    @GET
    @Path(value="/getStudyMembersList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudyMembersList(@QueryParam(value="studyId") int studyId) {
        List<StudyUser> studyMembers = this.service.getStudyMembers(studyId);
        return this.gson.toJson(studyMembers);
    }

    @POST
    @Path(value="/addStudyMember")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String addStudyMember(@FormParam(value="data") String data, @Context ServletContext context) {
        AddStudyMembersDTO assignStudyMembersDTO = (AddStudyMembersDTO)this.gson.fromJson(data, AddStudyMembersDTO.class);
        BooleanResultDTO result = this.service.assignStudyMembers(assignStudyMembersDTO, this.getUser(), this.getRemoteHost(), context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/createStudy")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String createStudy(@FormParam(value="data") String data) {
        StudyDTO s = (StudyDTO)this.gson.fromJson(data, StudyDTO.class);
        s = this.service.createStudy(s, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)s);
    }

    @POST
    @Path(value="/editstudy")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String editstudy(@FormParam(value="data") String data) {
        StudyDTO s = (StudyDTO)this.gson.fromJson(data, StudyDTO.class);
        s = this.service.updateStudy(s, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)s);
    }

    @POST
    @Path(value="/commentVisitTemplate")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String commentVisitTemplate(@FormParam(value="data") String data) {
        TemplateApprovalHistoryDTO v = (TemplateApprovalHistoryDTO)this.gson.fromJson(data, TemplateApprovalHistoryDTO.class);
        TemplateApprovalHistory visit = this.service.commentVisitTemplate(v, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/approveVisitTemplate")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String approveVisitTemplate(@FormParam(value="data") String data, @Context ServletContext context) {
        TemplateApprovalHistoryDTO v = (TemplateApprovalHistoryDTO)this.gson.fromJson(data, TemplateApprovalHistoryDTO.class);
        TemplateApprovalHistory visit = this.service.approveVisitTemplate(v, this.getUser(), this.getRemoteHost(), context.getRealPath("/WEB-INF"));
        return this.gson.toJson((Object)visit);
    }

    @GET
    @Path(value="/getVisitTemplateData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getVisitTemplateData(@QueryParam(value="visit") int visitId) {
        VisitTemplateDetailResponse visit = this.loadVisitData(visitId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    VisitTemplateDetailResponse loadVisitData(int visitId, User user, String ipAddress) {
        VisitTemplateDetailResponse visitTemplateDetailResponse = this.service.getVisitTemplateData(visitId, user, ipAddress);
        return visitTemplateDetailResponse;
    }

    @GET
    @Path(value="/getStudyData")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudyData(@QueryParam(value="study") int studyId) {
        StudyDetailResponse study = this.loadStudyData(studyId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)study);
    }

    StudyDetailResponse loadStudyData(int studyId, User user, String ipAddress) {
        return this.service.getStudyData(studyId, user, ipAddress);
    }

    @POST
    @Path(value="/changeVisitTemplateStatus")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER})
    public String changeVisitTemplateStatus(@FormParam(value="data") String data, @QueryParam(value="activate") boolean activate) {
        VisitTemplatesRequest visitTemplatesRequest = (VisitTemplatesRequest)this.gson.fromJson(data, VisitTemplatesRequest.class);
        BooleanResultDTO result = this.service.changeVisitTemplateStatus(visitTemplatesRequest, activate, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @POST
    @Path(value="/createVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String createVisit(@FormParam(value="data") String data) {
        VisitDTO visitData = (VisitDTO)this.gson.fromJson(data, VisitDTO.class);
        VisitTemplate visit = this.service.createVisit(visitData, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/editVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_FRONT_DESK})
    public String editVisit(@FormParam(value="data") String data) {
        VisitDTO visitData = (VisitDTO)this.gson.fromJson(data, VisitDTO.class);
        VisitTemplate visit = this.service.updateVisit(visitData, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @POST
    @Path(value="/copyVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER})
    public String copyVisit(@FormParam(value="data") String data) {
        VisitDTO visitData = (VisitDTO)this.gson.fromJson(data, VisitDTO.class);
        VisitTemplate visit = this.service.copyVisit(visitData, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)visit);
    }

    @GET
    @Path(value="/getOpenStudies")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getOpenStudies(@QueryParam(value="filterString") String filterString, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults) {
        GetStudiesResponse result = this.getOpenStudiesList(filterString, sortBy, orderBy, page, maxResults, this.getUser());
        return this.gson.toJson((Object)result);
    }

    public GetStudiesResponse getOpenStudiesList(String filterString, String sortBy, String orderBy, int page, int maxResults, User user) {
        return this.service.getOpenStudies(filterString, sortBy, orderBy, page, maxResults, user);
    }

    @GET
    @Path(value="/getStudyList")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudyList(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="search") String search) {
        SearchDTO searchDTO = (SearchDTO)this.gson.fromJson(search, SearchDTO.class);
        List<StudyDataResponse> studies = this.getStudyDataResponses(sortBy, orderBy, page, maxResults, this.getUser(), searchDTO);
        return this.gson.toJson(studies);
    }

    List<StudyDataResponse> getStudyDataResponses(String sortBy, String orderBy, int page, int maxResults, User user, SearchDTO searchDTO) {
        return this.service.getStudiesList(sortBy, orderBy, page, maxResults, user, searchDTO);
    }

    @GET
    @Path(value="/getStudySubjects")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudySubjects(@QueryParam(value="filterString") String filterString, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="study") int studyId, @QueryParam(value="inactive") boolean wantAll, @QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="search") String search) {
        SearchDTO searchDTO = (SearchDTO)this.gson.fromJson(search, SearchDTO.class);
        GetStudySubjectsResponse result = this.getStudySubjectsResponse(filterString, page, maxResults, studyId, wantAll, sortBy, orderBy, this.getUser(), searchDTO);
        return this.gson.toJson((Object)result);
    }

    GetStudySubjectsResponse getStudySubjectsResponse(String filterString, int page, int maxResults, int studyId, boolean wantAll, String sortBy, String orderBy, User user, SearchDTO searchDTO) {
        return this.service.getStudySubjects(Optional.ofNullable(filterString), page, maxResults, Optional.of(studyId), sortBy, orderBy, wantAll, Optional.of(user), searchDTO);
    }

    @GET
    @Path(value="/changeStudySubjectStatus")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String changeStudySubjectStatus(@QueryParam(value="studySubjectId") int studySubjectId) {
        BooleanRequest result = this.service.changeStudySubjectStatus(studySubjectId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getStudyMembers")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getStudyMembers(@QueryParam(value="sortBy") String sortBy, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="page") int page, @QueryParam(value="maxResults") int maxResults, @QueryParam(value="study") int studyId, @QueryParam(value="search") String searchJson) {
        SearchDTO searchDTO = (SearchDTO)this.gson.fromJson(searchJson, SearchDTO.class);
        List<UserDataResponse> studyMembers = this.service.getStudyMembersList(studyId, sortBy, orderBy, page, maxResults, searchDTO);
        return this.gson.toJson(studyMembers);
    }

    @GET
    @Path(value="/changeStudyMemberStatus")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String changeStudyMemberStatus(@QueryParam(value="studyMemberId") int studyMemberId) {
        BooleanRequest result = this.service.changeStudyMemberStatus(studyMemberId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/deleteVisit")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String deleteVisit(@QueryParam(value="visitId") int visitId) {
        BooleanRequest result = this.service.deleteVisit(visitId, this.getUser(), this.getRemoteHost());
        return this.gson.toJson((Object)result);
    }

    @GET
    @Path(value="/getVisitComments")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN, InstitutionRoleType.ROLE_RESOURCE_MANAGER, InstitutionRoleType.ROLE_SCHEDULER, InstitutionRoleType.ROLE_STUDY_STAFF, InstitutionRoleType.ROLE_FRONT_DESK})
    public String getVisitComments(@QueryParam(value="id") int visitId) {
        List<Comments> visitTemplateComments = this.service.getVisitTemplateComments(visitId);
        List<VisitCommentsResponse.VisitComment> comments = VisitCommentsResponse.fromTemplateApprovalHistoryList(visitTemplateComments);
        return this.gson.toJson(comments);
    }
}

