/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.Pairs;
import edu.harvard.catalyst.scheduler.dto.ReportDTO;
import edu.harvard.catalyst.scheduler.dto.WorkloadAndResourceResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.CancellationsReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataReportResponseDTO;
import edu.harvard.catalyst.scheduler.dto.statics.StudyStatusFilter;
import edu.harvard.catalyst.scheduler.entity.Report;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.persistence.ReportDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReportService {
    private final ReportDAO reportDAO;
    private final AuditService auditService;
    private final List<Report> allReports;
    private final Map<String, String> reportNameToTitle;
    private volatile Map<String, Function<ReportDTO, List<?>>> reportListStrategies = null;

    @Autowired
    public ReportService(ReportDAO reportDAO, AuditService auditService) {
        this.reportDAO = reportDAO;
        this.auditService = auditService;
        this.reportNameToTitle = new HashMap<String, String>();
        this.allReports = reportDAO.getReports();
        for (Report report : this.allReports) {
            String name = report.getName();
            String title = report.getTitle();
            this.reportNameToTitle.put(name, title);
        }
    }

    ReportService() {
        this(null, null);
    }

    public List<Report> getReports(ReportDTO reportDTO) {
        return this.allReports;
    }

    public Report getReportData(User user, String ipAddress, int id) {
        this.logViewReports(user, ipAddress, "Reports Screen View");
        return this.reportDAO.getReportDataById(id);
    }

    public void logViewReports(User user, String ipAddress, String action) {
        this.auditService.logUserActivity(ipAddress, null, user, action, null, null);
    }

    void logReportExecuted(List<?> list, User user, String remoteHost, String reportTitle) {
        if (list != null) {
            if (list.size() > 0) {
                this.auditService.logUserActivity(remoteHost, null, user, "Report Displayed - " + reportTitle, null, null);
            } else {
                this.auditService.logUserActivity(remoteHost, null, user, reportTitle + " Report - No relevant data found in the specified date range.", null, null);
            }
        }
    }

    public List<?> getReport(ReportDTO reportDTO, User user, String remoteHost) {
        String reportName = reportDTO.getName();
        String reportTitle = this.reportNameToTitle.get(reportName);
        String timeSpanString = reportDTO.getTimeSpanString();
        this.auditService.logUserActivity(remoteHost, null, user, "Launch - " + reportTitle + " query " + timeSpanString, null, null);
        List<?> reportResultList = this.determineReportResultList(reportDTO, user, reportName);
        this.logReportExecuted(reportResultList, user, remoteHost, reportTitle);
        return reportResultList;
    }

    private synchronized Map<String, Function<ReportDTO, List<?>>> getReportListStrategies(User user) {
        if (this.reportListStrategies == null) {
            Pair[] pairArray = new Pair[35];
            pairArray[0] = Pair.pair((Object)"user_data", this.reportDAO::getUserDataReport);
            pairArray[1] = Pair.pair((Object)"proto_by_nurse", this.reportDAO::getProtoNurseAndNutritionReport);
            pairArray[2] = Pair.pair((Object)"proto_nutritionist", this.reportDAO::getProtoNurseAndNutritionReport);
            pairArray[3] = Pair.pair((Object)"staff_audit_subject_views", dto -> this.reportDAO.getStaffAuditSubjectViewsReport((ReportDTO)dto, user));
            pairArray[4] = Pair.pair((Object)"subject_audit_staff_views", dto -> this.reportDAO.getSubjectAuditStaffViewsReport((ReportDTO)dto));
            pairArray[5] = Pair.pair((Object)"override", this.reportDAO::getOverrideReport);
            pairArray[6] = Pair.pair((Object)"subject_purge", dto -> this.reportDAO.getSubjectPurgeReport((ReportDTO)dto));
            pairArray[7] = Pair.pair((Object)"off_unit", this.reportDAO::getOffUnitReport);
            pairArray[8] = Pair.pair((Object)"daily_overview", dto -> this.reportDAO.getDailyOverviewReport((ReportDTO)dto));
            pairArray[9] = Pair.pair((Object)"export_daily_overview", this.reportDAO::getExportDailyOverviewReport);
            pairArray[10] = Pair.pair((Object)"weekly_pharm", this.reportDAO::getWeeklyPharmReport);
            pairArray[11] = Pair.pair((Object)"study_visit_location", this.reportDAO::getStudyVisitLocationReport);
            pairArray[12] = Pair.pair((Object)"billable_resources", this.reportDAO::getBillableResourcesReport);
            pairArray[13] = Pair.pair((Object)"transactions", this.reportDAO::getTransactionsReport);
            pairArray[14] = Pair.pair((Object)"daily_resource", dto -> this.reportDAO.getDailyResourceReport((ReportDTO)dto, false));
            pairArray[15] = Pair.pair((Object)"export_daily_resource", dto -> this.reportDAO.getDailyResourceReport((ReportDTO)dto, true));
            pairArray[16] = Pair.pair((Object)"daily_adm", this.reportDAO::getDailyAdmReport);
            pairArray[17] = Pair.pair((Object)"meta_kitchen", dto -> this.reportDAO.getMetaKitchenReport((ReportDTO)dto));
            pairArray[18] = Pair.pair((Object)"meta_kitchen_by_time", dto -> this.reportDAO.getMetaKitchenReport((ReportDTO)dto));
            pairArray[19] = Pair.pair((Object)"meta_kitchen_flat", dto -> this.reportDAO.getMetaKitchenReport((ReportDTO)dto));
            pairArray[20] = Pair.pair((Object)"dept_and_pi", this.reportDAO::getDeptAndPiReport);
            pairArray[21] = Pair.pair((Object)"billing", dto -> this.reportDAO.getBillingReport((ReportDTO)dto));
            pairArray[22] = Pair.pair((Object)"billing_by_investigator", dto -> this.reportDAO.getBillingByInvestigatorReport((ReportDTO)dto));
            pairArray[23] = Pair.pair((Object)"census", this.reportDAO::getCensusReport);
            pairArray[24] = Pair.pair((Object)"level_of_service", this.reportDAO::getLevelOfServiceReport);
            pairArray[25] = Pair.pair((Object)"study_subject_visit", this.reportDAO::getStudySubjectVisitReport);
            pairArray[26] = Pair.pair((Object)"study_status_change", this.reportDAO::getStudyStatusChangeReport);
            pairArray[27] = Pair.pair((Object)"subject_visit_history", this.reportDAO::getSubjectVisitHistoryReport);
            pairArray[28] = Pair.pair((Object)"crc_availability", this.reportDAO::getCRCAvailabilityReport);
            pairArray[29] = Pair.pair((Object)"resource_level_of_service", this.reportDAO::getResourceLevelOfServiceReport);
            pairArray[30] = Pair.pair((Object)"visit_template_data", this.reportDAO::getVisitTemplateReport);
            pairArray[31] = Pair.pair((Object)"visit_duration_by_visit_type", this.reportDAO::getVisitDurationByVisitTypeReport);
            pairArray[32] = Pair.pair((Object)"booked_visit_service_level_by_visit_type", this.reportDAO::getBookedVisitServiceLevelByVisitTypeReport);
            pairArray[33] = Pair.pair((Object)"ancillary_only_by_protocol", this.reportDAO::getAncillaryOnlyByProtocolReport);
            pairArray[34] = Pair.pair((Object)"visits_flagged_edit", dto -> this.reportDAO.getVisitsFlaggedForEditReport((ReportDTO)dto));
            this.reportListStrategies = Pairs.toMap((Pair[])pairArray);
        }
        return this.reportListStrategies;
    }

    private List<?> determineReportResultList(ReportDTO reportDTO, User user, String reportName) {
        String key = reportName.toLowerCase();
        Map<String, Function<ReportDTO, List<?>>> mapping = this.getReportListStrategies(user);
        if (mapping.containsKey(key)) {
            return mapping.get(key).apply(reportDTO);
        }
        return null;
    }

    public List<ResourceType> getResourceTypes() {
        return this.reportDAO.getResourceTypes();
    }

    public List<Sublocation> getSublocations() {
        return this.reportDAO.getSublocations();
    }

    void launchAudit(String reportName, Date startTime, Date endTime, User user, String remoteHost) {
        String reportTitle = this.reportNameToTitle.get(reportName);
        Object timeSpanString = startTime != null && endTime != null ? "for: '" + startTime + "' to '" + endTime + "'" : "";
        this.auditService.logUserActivity(remoteHost, null, user, "Launch - " + reportTitle + " query " + (String)timeSpanString, null, null);
    }

    void returnAudit(String reportName, User user, String remoteHost, int resultSize) {
        String reportTitle = this.reportNameToTitle.get(reportName);
        this.auditService.logUserActivity(remoteHost, null, user, "Report query for - " + reportTitle + " - returned " + resultSize + " result(s)", null, null);
    }

    public List<StudyDataReportResponseDTO> getStudyDataReport(Optional<User> ofUser, Optional<String> ofHost, Optional<String> nullableLocalId, Optional<String> nullableName, Optional<String> nullableFundingSource, Optional<StudyStatusFilter> nullableStudyStatus, Optional<String> nullableSortDirection) {
        String reportName = "study_data";
        User user = ofUser.get();
        String host = ofHost.get();
        this.launchAudit("study_data", null, null, user, host);
        List<StudyDataReportResponseDTO> result = this.reportDAO.getStudyDataReport(nullableLocalId, nullableName, nullableFundingSource, nullableStudyStatus, nullableSortDirection);
        this.returnAudit("study_data", user, host, result.size());
        return result;
    }

    public List<CancellationsReportResponseDTO> getCancellationsReport(Optional<User> ofUser, Optional<String> ofHost, Optional<Date> ofStartTime, Optional<Date> ofEndTime, Optional<String> nullableLocalId, Optional<String> nullableName, Optional<String> nullableType, Optional<String> nullableReason, Optional<String> nullableNoApprove, Optional<String> nullableSortDirection) {
        String institution = ofUser.get().getInstitution().getName();
        String reportName = "cancellations";
        Date startTime = ofStartTime.get();
        Date endTime = ofEndTime.get();
        User user = ofUser.get();
        String remoteHost = ofHost.get();
        this.launchAudit("cancellations", startTime, endTime, user, remoteHost);
        List<CancellationsReportResponseDTO> result = this.reportDAO.getCancellationsReport(nullableLocalId, nullableName, nullableType, nullableReason, nullableNoApprove, nullableSortDirection, startTime, endTime);
        this.returnAudit("cancellations", user, remoteHost, result.size());
        return result;
    }

    public List<WorkloadAndResourceResponseDTO> getResourceLevelOfServiceReport(ReportDTO dto, Optional<User> ofUser, Optional<String> ofHost) {
        String reportName = "resource_level_of_service";
        User user = ofUser.get();
        String remoteHost = ofHost.get();
        this.launchAudit("resource_level_of_service", null, null, user, remoteHost);
        List<WorkloadAndResourceResponseDTO> result = this.reportDAO.getResourceLevelOfServiceReport(dto);
        this.returnAudit("resource_level_of_service", user, remoteHost, result.size());
        return result;
    }
}

