/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Pair;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.hccrc.core.util.ScalaFunctionWrappers;
import edu.harvard.catalyst.hccrc.core.util.ScalaIteratorAdapter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import scala.Function1;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.Set;

public final class RichIterator<A> {
    private final Iterator<A> delegate;

    RichIterator(Iterator<A> delegate) {
        this.delegate = delegate;
    }

    public static <A> RichIterator<A> enrich(java.util.Iterator<A> javaIterator) {
        return new RichIterator<A>(new JavaIteratorAdapter<A>(javaIterator));
    }

    Iterator<A> getDelegate() {
        return this.delegate;
    }

    public java.util.Iterator<A> asJava() {
        return RichIterator.asJava(this.delegate);
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public A next() {
        return (A)this.delegate.next();
    }

    public RichIterator<A> take(int howMany) {
        return new RichIterator<A>(this.delegate.take(howMany));
    }

    public RichIterator<A> drop(int howMany) {
        return new RichIterator<A>(this.delegate.drop(howMany));
    }

    public <B> RichIterator<B> map(Function<? super A, ? extends B> f) {
        return new RichIterator<A>(this.delegate.map(ScalaFunctionWrappers.asScalaFunction(f)));
    }

    public <B> RichIterator<B> flatMap(Function<? super A, ? extends RichIterator<B>> f) {
        return new RichIterator<A>(this.delegate.flatMap(ScalaFunctionWrappers.asScalaFunction(a -> ((RichIterator)f.apply((Object)a)).getDelegate())));
    }

    public RichIterator<A> filter(Predicate<? super A> p) {
        Function1<Object, Object> wrappedFunc = ScalaFunctionWrappers.asScalaFunction(p::test);
        return new RichIterator<A>(this.delegate.filter(wrappedFunc));
    }

    public void forEach(Consumer<? super A> f) {
        this.asJava().forEachRemaining(f);
    }

    public List<A> toList() {
        return (List)JavaConverters.seqAsJavaListConverter((Seq)this.delegate.toIndexedSeq()).asJava();
    }

    public RichList<A> toRichList() {
        return ListUtils.enrich(this.toList());
    }

    public java.util.Set<A> toSet() {
        return (java.util.Set)JavaConverters.setAsJavaSetConverter((Set)this.delegate.toSet()).asJava();
    }

    public RichIterator<Pair<A, Integer>> zipWithIndex() {
        Counter counter = new Counter();
        return this.map(a -> Pair.pair(a, counter.next()));
    }

    private static final <A> java.util.Iterator<A> asJava(Iterator<A> scalaIterator) {
        return new ScalaIteratorAdapter<A>(scalaIterator);
    }

    private static final class JavaIteratorAdapter<A>
    extends AbstractIterator<A> {
        private final java.util.Iterator<A> javaIterator;

        JavaIteratorAdapter(java.util.Iterator<A> javaIterator) {
            this.javaIterator = javaIterator;
        }

        public boolean hasNext() {
            return this.javaIterator.hasNext();
        }

        public A next() {
            return this.javaIterator.next();
        }
    }

    private static final class Counter {
        private int count = 0;

        private Counter() {
        }

        int next() {
            try {
                int n = this.count;
                return n;
            }
            finally {
                ++this.count;
            }
        }
    }
}

