/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="activity_log")
public class ActivityLog
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private User performingUser;
    private String actionPerformed;
    private Date date;
    private String ipAddress;
    private User affectedUser;
    private Resource affectedResource;
    private Sublocation affectedSublocation;
    private Subject affectedSubject;
    private SubjectMrn affectedSubjectMrn;
    private Study affectedStudy;
    private VisitTemplate affectedVisit;
    private String changesDetailRequiredField;
    private String changesDetail;
    private AppointmentOverrideReason appointmentOverrideReason;
    private BookedVisit bookedVisit;

    public ActivityLog() {
        super(null);
    }

    @Column(name="action_performed")
    public String getActionPerformed() {
        return this.actionPerformed;
    }

    public void setActionPerformed(String action) {
        if (((String)action).length() > 255) {
            action = ((String)action).substring(0, 252) + "...";
        }
        this.actionPerformed = action;
    }

    @Column(name="date")
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @JoinColumn(name="booked_visit", referencedColumnName="id")
    @ManyToOne(optional=true)
    public BookedVisit getBookedVisit() {
        return this.bookedVisit;
    }

    public void setBookedVisit(BookedVisit bookedVisit) {
        this.bookedVisit = bookedVisit;
    }

    @Column(name="ip_address")
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Column(name="changes_detail")
    public String getChangesDetail() {
        return this.changesDetail;
    }

    public void setChangesDetail(String changesDetail) {
        this.changesDetail = changesDetail;
    }

    @Column(name="changes_detail_required_field")
    public String getChangesDetailRequiredField() {
        return this.changesDetailRequiredField;
    }

    public void setChangesDetailRequiredField(String changesDetailRequiredField) {
        this.changesDetailRequiredField = changesDetailRequiredField;
    }

    @JoinColumn(name="appointment_override_reason", referencedColumnName="id")
    @ManyToOne(optional=true)
    public AppointmentOverrideReason getAppointmentOverrideReason() {
        return this.appointmentOverrideReason;
    }

    public void setAppointmentOverrideReason(AppointmentOverrideReason appointmentOverrideReason) {
        this.appointmentOverrideReason = appointmentOverrideReason;
    }

    @JoinColumn(name="performing_user", referencedColumnName="id")
    @ManyToOne(optional=true)
    public User getPerformingUser() {
        return this.performingUser;
    }

    public void setPerformingUser(User performingUser) {
        this.performingUser = performingUser;
    }

    @JoinColumn(name="affected_user", referencedColumnName="id")
    @ManyToOne(optional=true)
    public User getAffectedUser() {
        return this.affectedUser;
    }

    public void setAffectedUser(User affectedUser) {
        this.affectedUser = affectedUser;
    }

    @JoinColumn(name="affected_resource", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Resource getAffectedResource() {
        return this.affectedResource;
    }

    public void setAffectedResource(Resource affectedResource) {
        this.affectedResource = affectedResource;
    }

    @JoinColumn(name="affected_sublocation", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Sublocation getAffectedSublocation() {
        return this.affectedSublocation;
    }

    public void setAffectedSublocation(Sublocation affectedSublocation) {
        this.affectedSublocation = affectedSublocation;
    }

    @JoinColumn(name="affected_study", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Study getAffectedStudy() {
        return this.affectedStudy;
    }

    public void setAffectedStudy(Study affectedStudy) {
        this.affectedStudy = affectedStudy;
    }

    @JoinColumn(name="affected_visit", referencedColumnName="id")
    @ManyToOne(optional=true)
    public VisitTemplate getAffectedVisit() {
        return this.affectedVisit;
    }

    public void setAffectedVisit(VisitTemplate affectedVisit) {
        this.affectedVisit = affectedVisit;
    }

    @JoinColumn(name="affected_subject", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Subject getAffectedSubject() {
        return this.affectedSubject;
    }

    public void setAffectedSubject(Subject affectedSubject) {
        this.affectedSubject = affectedSubject;
    }

    @JoinColumn(name="affected_subject_mrn", referencedColumnName="id")
    @ManyToOne(optional=true)
    public SubjectMrn getAffectedSubjectMrn() {
        return this.affectedSubjectMrn;
    }

    public void setAffectedSubjectMrn(SubjectMrn affectedSubjectMrn) {
        this.affectedSubjectMrn = affectedSubjectMrn;
    }

    public String toString() {
        return "ActivityLog [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

