/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.util.DateUtility;
import java.util.List;
import java.util.stream.Collectors;

public class GanttResourceInfoDTO {
    private long totalTimeOfRelevantStintsOfThisResource;
    private long totalTimeOfStintsOfThisResourceInVisit;
    private int totalRelevantTrStintsOfThisResource;
    private int totalTrStintsOfThisResourceInVisit;

    public GanttResourceInfoDTO(List<TemplateResource> relevantTrs, int dayOffset) {
        List relevantStintsMinusUnconsummatedFloatRegions = relevantTrs.stream().filter(tr -> DateUtility.dateIntervalOverlapsDayOffset(tr.getStartDate(), tr.getEndDate(), dayOffset)).collect(Collectors.toList());
        this.totalTrStintsOfThisResourceInVisit = relevantTrs.size();
        this.totalTimeOfStintsOfThisResourceInVisit = relevantTrs.stream().mapToLong(TemplateResource::getDuration).sum();
        this.totalRelevantTrStintsOfThisResource = relevantStintsMinusUnconsummatedFloatRegions.size();
        this.totalTimeOfRelevantStintsOfThisResource = relevantTrs.stream().mapToLong(tr -> tr.getOneDayDuration(dayOffset)).sum();
    }
}

