/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.entity.Resource;
import java.util.List;

public final class UnassignedResourcesResponse {
    private final List<UnassignedResources> resources;

    public UnassignedResourcesResponse(List<UnassignedResources> resourceList) {
        this.resources = resourceList;
    }

    public static UnassignedResourcesResponse fromResourcesList(List<Resource> resources) {
        List resourceList = RichList.enrich(resources).map(resource -> new UnassignedResources((Resource)resource)).toList();
        return new UnassignedResourcesResponse(resourceList);
    }

    public static final class UnassignedResources {
        private final Integer id;
        private final String name;

        public UnassignedResources(Resource resource) {
            if (resource == null) {
                SchedulerRuntimeException.logAndThrow("resource parameter should be non-null");
            }
            this.id = resource.getId();
            this.name = resource.getName();
        }
    }
}

