/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.Country;
import edu.harvard.catalyst.scheduler.entity.Ethnicity;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.Race;
import edu.harvard.catalyst.scheduler.entity.State;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="subject")
public class Subject
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String mrn;
    private String firstName;
    private String middleName;
    private String lastName;
    private String fullName;
    private Ethnicity ethnicity;
    private Date birthdate;
    private Race race;
    private Gender gender;
    private String streetAddress1;
    private String streetAddress2;
    private String city;
    private State state;
    private String zip;
    private String comment;
    private String subjectSchedulerId;
    private Country country;
    private String primaryContactNumber;
    private String secondaryContactNumber;
    private Date createdDate;
    private boolean secure;
    private boolean active;

    public static Subject defensiveCopy(Subject original) {
        Subject copy = new Subject();
        copy.id = original.id;
        copy.mrn = original.mrn;
        copy.firstName = original.firstName;
        copy.middleName = original.middleName;
        copy.lastName = original.lastName;
        copy.fullName = original.fullName;
        copy.ethnicity = original.ethnicity;
        copy.birthdate = original.birthdate;
        copy.race = original.race;
        copy.gender = original.gender;
        copy.streetAddress1 = original.streetAddress1;
        copy.streetAddress2 = original.streetAddress2;
        copy.city = original.city;
        copy.state = original.state;
        copy.zip = original.zip;
        copy.comment = original.comment;
        copy.subjectSchedulerId = original.subjectSchedulerId;
        copy.country = original.country;
        copy.primaryContactNumber = original.primaryContactNumber;
        copy.secondaryContactNumber = original.secondaryContactNumber;
        copy.createdDate = original.createdDate;
        copy.secure = original.secure;
        copy.active = original.active;
        return copy;
    }

    @Column(name="mrn")
    @Basic(optional=false)
    public String getMrn() {
        return this.mrn;
    }

    public void setMrn(String mrn) {
        this.mrn = mrn;
    }

    @Column(name="first_name")
    @Basic(optional=false)
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="middle_name")
    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    @Column(name="last_name")
    @Basic(optional=false)
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="full_name")
    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Column(name="birthdate")
    @Basic(optional=false)
    public Date getBirthdate() {
        return this.birthdate;
    }

    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    @JoinColumn(name="ethnicity", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Ethnicity getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(Ethnicity ethnicity) {
        this.ethnicity = ethnicity;
    }

    @JoinColumn(name="gender", referencedColumnName="id")
    @ManyToOne(optional=false)
    @Basic(optional=false)
    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @JoinColumn(name="race", referencedColumnName="id")
    @ManyToOne(optional=false)
    public Race getRace() {
        return this.race;
    }

    public void setRace(Race race) {
        this.race = race;
    }

    @Column(name="primary_contact_number")
    @Basic(optional=false)
    public String getPrimaryContactNumber() {
        return this.primaryContactNumber;
    }

    public void setPrimaryContactNumber(String primaryContactNumber) {
        this.primaryContactNumber = primaryContactNumber;
    }

    @Column(name="secondary_contact_number")
    public String getSecondaryContactNumber() {
        return this.secondaryContactNumber;
    }

    public void setSecondaryContactNumber(String secondaryContactNumber) {
        this.secondaryContactNumber = secondaryContactNumber;
    }

    @Column(name="street_address1")
    public String getStreetAddress1() {
        return this.streetAddress1;
    }

    public void setStreetAddress1(String streetAddress1) {
        this.streetAddress1 = streetAddress1;
    }

    @Column(name="street_address2")
    public String getStreetAddress2() {
        return this.streetAddress2;
    }

    public void setStreetAddress2(String streetAddress2) {
        this.streetAddress2 = streetAddress2;
    }

    @Column(name="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @JoinColumn(name="state", referencedColumnName="id")
    @ManyToOne(optional=true)
    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    @Column(name="zip")
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    @JoinColumn(name="country", referencedColumnName="id")
    @ManyToOne(optional=true)
    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    @Column(name="created_date")
    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Column(name="secure")
    public boolean getSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Column(name="active")
    public boolean getActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="comment")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Column(name="subject_scheduler_id")
    public String getSubjectSchedulerId() {
        return this.subjectSchedulerId;
    }

    public void setSubjectSchedulerId(String subjectSchedulerId) {
        this.subjectSchedulerId = subjectSchedulerId;
    }

    public String toString() {
        return "Subject [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

