/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import java.io.UnsupportedEncodingException;
import org.glassfish.grizzly.http.util.DataChunk;

public final class Method {
    public static final Method OPTIONS = new Method("OPTIONS");
    public static final Method GET = new Method("GET");
    public static final Method HEAD = new Method("HEAD");
    public static final Method POST = new Method("POST");
    public static final Method PUT = new Method("PUT");
    public static final Method DELETE = new Method("DELETE");
    public static final Method TRACE = new Method("TRACE");
    public static final Method CONNECT = new Method("CONNECT");
    public static final Method PATCH = new Method("PATCH");
    private final String methodString;
    private byte[] methodBytes;

    public static Method CUSTOM(String methodName) {
        return new Method(methodName);
    }

    public static Method parseDataChunk(DataChunk methodC) {
        return Method.valueOf(methodC);
    }

    public static Method valueOf(DataChunk methodC) {
        if (methodC.equals(GET.getMethodString())) {
            return GET;
        }
        if (methodC.equals(POST.getMethodString())) {
            return POST;
        }
        if (methodC.equals(HEAD.getMethodString())) {
            return HEAD;
        }
        if (methodC.equals(PUT.getMethodString())) {
            return PUT;
        }
        if (methodC.equals(DELETE.getMethodString())) {
            return DELETE;
        }
        if (methodC.equals(TRACE.getMethodString())) {
            return TRACE;
        }
        if (methodC.equals(CONNECT.getMethodString())) {
            return CONNECT;
        }
        if (methodC.equals(OPTIONS.getMethodString())) {
            return OPTIONS;
        }
        if (methodC.equals(PATCH.getMethodString())) {
            return PATCH;
        }
        return Method.CUSTOM(methodC.toString());
    }

    public static Method valueOf(String method) {
        if (method.equals(GET.getMethodString())) {
            return GET;
        }
        if (method.equals(POST.getMethodString())) {
            return POST;
        }
        if (method.equals(HEAD.getMethodString())) {
            return HEAD;
        }
        if (method.equals(PUT.getMethodString())) {
            return PUT;
        }
        if (method.equals(DELETE.getMethodString())) {
            return DELETE;
        }
        if (method.equals(TRACE.getMethodString())) {
            return TRACE;
        }
        if (method.equals(CONNECT.getMethodString())) {
            return CONNECT;
        }
        if (method.equals(OPTIONS.getMethodString())) {
            return OPTIONS;
        }
        if (method.equals(PATCH.getMethodString())) {
            return PATCH;
        }
        return Method.CUSTOM(method.toString());
    }

    private Method(String methodString) {
        this.methodString = methodString;
        try {
            this.methodBytes = methodString.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ignored) {
            this.methodBytes = methodString.getBytes();
        }
    }

    public String getMethodString() {
        return this.methodString;
    }

    public byte[] getMethodBytes() {
        return this.methodBytes;
    }

    public String toString() {
        return this.methodString;
    }

    public boolean matchesMethod(String method) {
        return this.methodString.equals(method);
    }
}

