/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.BookedVisitGraph;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.CommonGraph;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.Graph;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.StudyAndVisitTemplateGraph;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="report_template")
public class ReportTemplate
extends BaseEntity
implements Serializable {
    private static Map<CommonGraph.GraphType, Graph> graphMap = new HashMap<CommonGraph.GraphType, Graph>();
    private String displayName;
    private TemplateType type;
    private Boolean dateBound;
    private CommonGraph.GraphType graphType;

    public ReportTemplate() {
    }

    public ReportTemplate(Integer id, String displayName, TemplateType type, Boolean dateBound, CommonGraph.GraphType graphType) {
        super(id);
        this.displayName = displayName;
        this.type = type;
        this.dateBound = dateBound;
        this.graphType = graphType;
    }

    @Column(name="display_name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Column(name="type")
    @Enumerated(value=EnumType.STRING)
    public TemplateType getType() {
        return this.type;
    }

    public void setType(TemplateType type) {
        this.type = type;
    }

    @Column(name="date_bound")
    public Boolean getDateBound() {
        return this.dateBound;
    }

    public void setDateBound(Boolean dateBound) {
        this.dateBound = dateBound;
    }

    @Column(name="graph_type")
    @Enumerated(value=EnumType.STRING)
    public CommonGraph.GraphType getGraphType() {
        return this.graphType;
    }

    public void setGraphType(CommonGraph.GraphType graphType) {
        this.graphType = graphType;
    }

    @Transient
    public Graph getGraph() {
        return graphMap.get((Object)this.graphType);
    }

    static {
        graphMap.put(CommonGraph.GraphType.BookedVisit, BookedVisitGraph.getInstance());
        graphMap.put(CommonGraph.GraphType.StudyAndVisitTemplate, StudyAndVisitTemplateGraph.getInstance());
    }

    public static enum TemplateType {
        Administrative,
        Operational;

    }
}

