/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.decrypter;

import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.security.Key;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class SubjectDecrypter {
    private final SubjectDAO subjectDAO;
    private final DataSource dataSource;

    @Autowired
    public SubjectDecrypter(SubjectDAO subjectDAO, DataSource dataSource, @Qualifier(value="encryptionKeySubjectDecrypter") Key key) {
        this.subjectDAO = subjectDAO;
        this.dataSource = dataSource;
        SubjectDataEncryptor.setEncryptionKey((Key)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        System.out.println("Running with subjectDAO " + this.subjectDAO);
        Connection connection = null;
        PreparedStatement statement = null;
        int numDecrypted = 0;
        try {
            connection = this.dataSource.getConnection();
            statement = connection.prepareStatement("truncate table decrypted_subject");
            statement.execute();
            String createDecryptedSubjectString = "insert into decrypted_subject ( id, mrn, first_name, middle_name, last_name, full_name, ethnicity, birthdate, race, gender, street_address1, street_address2, city, state, zip, comment, subject_scheduler_id, country, primary_contact_number, secondary_contact_number, created_date, secure, active )  values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            statement = connection.prepareStatement(createDecryptedSubjectString);
            List subjects = this.subjectDAO.findAllSubjectsHql();
            int numSubjects = subjects.size();
            System.out.println("There are " + numSubjects + " subjects to deal with");
            for (Subject subject : subjects) {
                Subject decryptedSubject = SubjectDataEncryptor.decryptSubject((Subject)subject);
                this.insertQuery(decryptedSubject, statement);
                ++numDecrypted;
            }
        }
        catch (SQLException se) {
            System.out.println("SQL Failure! " + se.getMessage());
        }
        finally {
            System.out.println("Succeeded to decrypt and store " + numDecrypted + " subjects");
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                System.out.println("SQL Failure while trying to close up shop! " + se.getMessage());
            }
        }
    }

    private void setPrimitiveIntOrNull(int position, Integer value, PreparedStatement statement) throws SQLException {
        if (value != null) {
            statement.setInt(position, value);
        } else {
            statement.setNull(position, 4);
        }
    }

    private void setPrimitiveBoolOrNull(int position, Boolean value, PreparedStatement statement) throws SQLException {
        if (value != null) {
            statement.setBoolean(position, value);
        } else {
            statement.setNull(position, 16);
        }
    }

    private void insertQuery(Subject entity, PreparedStatement statement) throws SQLException {
        Timestamp birthStamp = entity.getBirthdate() == null ? null : new Timestamp(entity.getBirthdate().getTime());
        Timestamp createStamp = entity.getCreatedDate() == null ? null : new Timestamp(entity.getCreatedDate().getTime());
        Integer ethnicity = entity.getEthnicity() == null ? null : entity.getEthnicity().getId();
        Integer race = entity.getRace() == null ? null : entity.getRace().getId();
        Integer gender = entity.getGender() == null ? null : entity.getGender().getId();
        Integer state = entity.getState() == null ? null : entity.getState().getId();
        Integer country = entity.getCountry() == null ? null : entity.getCountry().getId();
        this.setPrimitiveIntOrNull(1, entity.getId(), statement);
        statement.setString(2, entity.getMrn());
        statement.setString(3, entity.getFirstName());
        statement.setString(4, entity.getMiddleName());
        statement.setString(5, entity.getLastName());
        statement.setString(6, entity.getFullName());
        this.setPrimitiveIntOrNull(7, ethnicity, statement);
        statement.setTimestamp(8, birthStamp);
        this.setPrimitiveIntOrNull(9, race, statement);
        this.setPrimitiveIntOrNull(10, gender, statement);
        statement.setString(11, entity.getStreetAddress1());
        statement.setString(12, entity.getStreetAddress2());
        statement.setString(13, entity.getCity());
        this.setPrimitiveIntOrNull(14, state, statement);
        statement.setString(15, entity.getZip());
        statement.setString(16, entity.getComment());
        statement.setString(17, entity.getSubjectSchedulerId());
        this.setPrimitiveIntOrNull(18, country, statement);
        statement.setString(19, entity.getPrimaryContactNumber());
        statement.setString(20, entity.getSecondaryContactNumber());
        statement.setTimestamp(21, createStamp);
        this.setPrimitiveBoolOrNull(22, entity.getSecure(), statement);
        this.setPrimitiveBoolOrNull(23, entity.getActive(), statement);
        statement.executeUpdate();
    }

    private static Options constructOptions() {
        Options options = new Options();
        options.addOption("help", false, "display this message");
        return options;
    }

    public static void main(String[] args) throws ParseException {
        BasicParser parser = new BasicParser();
        Options options = SubjectDecrypter.constructOptions();
        CommandLine line = parser.parse(options, args);
        if (line.hasOption("help")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("decrypter", options);
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext("spring-decrypter.xml");
        SubjectDecrypter decrypter = (SubjectDecrypter)context.getBean("subjectDecrypter");
        decrypter.run();
    }
}

