/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.scheduler.entity.HasReportFiltersNameAndId;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.GrantedAuthority;

public enum InstitutionRoleType implements ConfigAttribute,
GrantedAuthority,
HasReportFiltersNameAndId
{
    ROLE_SUPER_ADMIN("Super Admin"),
    ROLE_RESOURCE_MANAGER("Resource Manager"),
    ROLE_SCHEDULER("Schedulers"),
    ROLE_STUDY_STAFF("Study Staff"),
    ROLE_FRONT_DESK("Front Desk"),
    ROLE_GENERAL_VIEW("General View");

    private String reportFiltersName;
    private static final Map<String, InstitutionRoleType> byHumanReadableName;

    @Override
    public int getReportFiltersId() {
        return this.ordinal();
    }

    @Override
    public String getReportFiltersName() {
        return this.reportFiltersName;
    }

    private InstitutionRoleType(String reportFiltersName) {
        this.reportFiltersName = reportFiltersName;
    }

    public String getAttribute() {
        return this.toString();
    }

    public String getAuthority() {
        return this.toString();
    }

    public static Optional<InstitutionRoleType> fromHumanReadableName(String humanReadableName) {
        if (humanReadableName == null) {
            return Optional.absent();
        }
        String lowercaseName = humanReadableName.toLowerCase();
        return Optional.fromNullable((Object)byHumanReadableName.get(lowercaseName));
    }

    private static Map<String, InstitutionRoleType> makeByHumanReadableNameMap() {
        HashMap result = Maps.newHashMap();
        result.put("super admin", ROLE_SUPER_ADMIN);
        result.put("resource manager", ROLE_RESOURCE_MANAGER);
        result.put("schedulers", ROLE_SCHEDULER);
        result.put("study staff", ROLE_STUDY_STAFF);
        result.put("front desk", ROLE_FRONT_DESK);
        result.put("general view", ROLE_GENERAL_VIEW);
        return result;
    }

    static {
        byHumanReadableName = InstitutionRoleType.makeByHumanReadableNameMap();
    }
}

