/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.entity.HasId;
import edu.harvard.catalyst.scheduler.entity.HasName;
import edu.harvard.catalyst.scheduler.entity.HasReportFiltersNameAndId;
import java.io.Serializable;
import java.util.Optional;

public enum VisitType implements HasId,
HasName,
Serializable,
HasReportFiltersNameAndId
{
    OutpatientCRC(1, "Outpatient CRC"),
    OutpatientNonCRC(2, "Outpatient Non CRC"),
    OutpatientOffInstitution(3, "Outpatient Off Institution"),
    InpatientCRC(4, "Inpatient CRC"),
    InpatientNonCRC(5, "Inpatient Non CRC"),
    InpatientOffInstitution(6, "Inpatient Off Institution");

    private final int id;
    private final String humanReadableName;

    private VisitType(int id, String humanReadableName) {
        this.id = id;
        this.humanReadableName = humanReadableName;
    }

    @Override
    public int getReportFiltersId() {
        return this.ordinal();
    }

    @Override
    public String getReportFiltersName() {
        return this.humanReadableName;
    }

    public boolean isOutpatient() {
        return this == OutpatientCRC || this == OutpatientNonCRC || this == OutpatientOffInstitution;
    }

    public boolean isInpatient() {
        return this == InpatientCRC || this == InpatientNonCRC || this == InpatientOffInstitution;
    }

    @Override
    public String getName() {
        return this.humanReadableName;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public static Optional<VisitType> findById(Integer id) {
        if (id == null) {
            return Optional.empty();
        }
        return ListUtils.enrich((Object[])VisitType.values()).find(vt -> id.equals(vt.getId()));
    }

    public static Optional<VisitType> findByPrettyName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return ListUtils.enrich((Object[])VisitType.values()).find(vt -> name.equals(vt.getName()));
    }

    public Jsonable toJsonable() {
        return new Jsonable(this);
    }

    public static final class Jsonable
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final Integer id;
        public final String name;

        public Jsonable(VisitType visitType) {
            this.id = visitType.getId();
            this.name = visitType.getName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Jsonable other = (Jsonable)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }
}

