/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.entity.reporttemplate;

import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.ReportTemplate;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateCategoryField;
import edu.harvard.catalyst.scheduler.entity.reporttemplate.TemplateUserSelection;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="template_user")
public class TemplateUser
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ReportTemplate reportTemplate;
    private User user;
    private String name;
    private Date lastUpdateTime;
    Set<TemplateUserSelection> userSelections;

    public TemplateUser() {
    }

    public TemplateUser(ReportTemplate reportTemplate, User user, String name) {
        this.reportTemplate = reportTemplate;
        this.user = user;
        this.name = name;
        this.lastUpdateTime = Calendar.getInstance().getTime();
    }

    @JoinColumn(name="report_template_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    public ReportTemplate getReportTemplate() {
        return this.reportTemplate;
    }

    public void setReportTemplate(ReportTemplate reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    @JoinColumn(name="user_id", referencedColumnName="id")
    @ManyToOne(optional=false)
    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    @Column(name="name")
    @Basic(optional=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="last_update_time")
    @Basic(optional=false)
    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="templateUser")
    public Set<TemplateUserSelection> getUserSelections() {
        return this.userSelections;
    }

    @Transient
    public Set<TemplateCategoryField> getSelectedTcfs() {
        return this.userSelections.stream().map(r -> r.getTcf()).collect(Collectors.toSet());
    }

    public void setUserSelections(Set<TemplateUserSelection> userSelections) {
        this.userSelections = userSelections;
    }

    public String toString() {
        return "TemplateUser [id=" + this.id + ", getId()=" + this.getId() + "]";
    }
}

