/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.spi.resource.Singleton;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.PasswordResetDTO;
import edu.harvard.catalyst.scheduler.dto.UserDTO;
import edu.harvard.catalyst.scheduler.dto.VersionInfo;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.security.AuthorizedRoles;
import edu.harvard.catalyst.scheduler.service.AppService;
import edu.harvard.catalyst.scheduler.service.AuthService;
import edu.harvard.catalyst.scheduler.web.BaseResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/app")
@Singleton
@Component
public class AppResource
extends BaseResource {
    private AppService appService;
    private AuthService authService;
    private String subjectMode;
    private static final Logger log = Logger.getLogger(AppResource.class);

    @Autowired
    public AppResource(AppService appService, AuthService authService, @Qualifier(value="subjectMode") String subjectMode) {
        this.appService = appService;
        this.authService = authService;
        this.subjectMode = subjectMode;
    }

    AppResource() {
    }

    @GET
    @Path(value="/versionInfo")
    public String getVersionInfo() {
        VersionInfo versionInfo = new VersionInfo();
        InputStream propsFile = this.getClass().getClassLoader().getResourceAsStream("build-number.properties");
        Properties schedulerProps = new Properties();
        try {
            schedulerProps.load(propsFile);
        }
        catch (IOException ioe) {
            SchedulerRuntimeException.logAndThrow("Problem loading 'build-number.properties'", ioe);
        }
        versionInfo.setBuildDate(schedulerProps.getProperty("buildDate", "UNKNOWN"));
        versionInfo.setScmBranch(schedulerProps.getProperty("scmBranch", "UNKNOWN"));
        versionInfo.setScmRevision(schedulerProps.getProperty("scmRevision", "UNKNOWN"));
        versionInfo.setVersion(schedulerProps.getProperty("version", "UNKNOWN"));
        versionInfo.setSubjectMode(this.subjectMode);
        return this.gson.toJson((Object)versionInfo);
    }

    @GET
    @Path(value="/getStaticLists")
    public String getStaticLists() {
        return this.appService.getStaticLists();
    }

    @POST
    @Path(value="/registerUser")
    public String registerUser(@FormParam(value="data") String data) {
        HashMap<String, String> map = new HashMap<String, String>();
        Gson gson = new GsonBuilder().registerTypeAdapter(UserDTO.class, (Object)new UserDTO()).create();
        UserDTO dto = (UserDTO)gson.fromJson(data, UserDTO.class);
        if (!(dto = this.authService.doRegisterUser(dto, this.getContextPath(), this.getRemoteHost(), this.getServerName(), this.getServerPort())).isResult()) {
            map.put("errorMsg", dto.getErrorMsg());
        }
        return gson.toJson((Object)dto);
    }

    @POST
    @Path(value="/unAuthenticatedPasswordReset")
    public String unAuthenticatedPasswordReset(@FormParam(value="data") String data) {
        PasswordResetDTO passwordResetDTO = (PasswordResetDTO)this.gson.fromJson(data, PasswordResetDTO.class);
        boolean result = this.authService.doPasswordReset(passwordResetDTO);
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(result);
        return this.gson.toJson((Object)booleanResultDTO);
    }

    @GET
    @Path(value="/logMessage")
    @AuthorizedRoles(value={InstitutionRoleType.ROLE_SUPER_ADMIN})
    public String logMessage(@QueryParam(value="m") String message) {
        log.warn((Object)("\n===================> " + message));
        return message;
    }
}

