/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.hccrc.core.util;

import edu.harvard.catalyst.hccrc.core.util.ScalaFunctionWrappers;
import edu.harvard.catalyst.hccrc.core.util.ScalaIteratorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import scala.Function1;
import scala.Option;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.WrappedArray;

public final class LazyList<A>
implements Iterable<A> {
    private final Stream<A> delegate;
    private static final LazyList<?> EMPTY = new LazyList(LazyList.scalaCompanion().empty());

    public LazyList(Seq<A> delegate) {
        this(LazyList.scalaCompanion().apply(delegate));
    }

    public LazyList(Stream<A> delegate) {
        this.delegate = delegate;
    }

    Stream<A> getDelegate() {
        return this.delegate;
    }

    public static final <A> LazyList<A> empty() {
        return EMPTY;
    }

    @SafeVarargs
    public static final <A> LazyList<A> of(A ... ts) {
        Seq wrappedArray = new WrappedArray.ofRef((Object[])ts).toSeq();
        return new LazyList<A>(wrappedArray);
    }

    public static final <A> LazyList<A> lazy(List<A> javaList) {
        return LazyList.from(javaList);
    }

    public static final <A> LazyList<A> from(List<A> javaList) {
        ArrayList<A> defensiveCopy = new ArrayList<A>(javaList);
        Seq scalaSeq = (Seq)JavaConverters.asScalaBufferConverter(defensiveCopy).asScala();
        return new LazyList<A>(scalaSeq);
    }

    public List<A> toList() {
        Collection javaView = JavaConverters.asJavaCollectionConverter(this.delegate).asJavaCollection();
        return new ArrayList(javaView);
    }

    public <B> LazyList<B> map(Function<? super A, ? extends B> f) {
        Function1<? super A, ? extends B> wrappedFunc = ScalaFunctionWrappers.asScalaFunction(f);
        Stream result = (Stream)this.delegate.map(wrappedFunc, this.cbf());
        return new LazyList<A>(result);
    }

    public <B> LazyList<B> flatMap(Function<? super A, ? extends LazyList<B>> f) {
        Function1<Object, GenTraversableOnce> wrappedFunc = ScalaFunctionWrappers.asScalaFunction(a -> ((LazyList)f.apply((Object)a)).getDelegate());
        Stream result = (Stream)this.delegate.flatMap(wrappedFunc, this.cbf());
        return new LazyList<A>(result);
    }

    public LazyList<A> filter(Predicate<? super A> p) {
        Function1<Object, Object> wrappedFunc = ScalaFunctionWrappers.asScalaFunction(p::test);
        Stream result = this.delegate.filter(wrappedFunc);
        return new LazyList<A>(result);
    }

    public boolean exists(Predicate<? super A> p) {
        Function1<Object, Object> wrappedFunc = ScalaFunctionWrappers.asScalaFunction(a -> p.test((Object)a));
        return this.delegate.exists(wrappedFunc);
    }

    public Optional<A> find(Predicate<? super A> p) {
        Function1<Object, Object> wrappedFunc = ScalaFunctionWrappers.asScalaFunction(a -> p.test((Object)a));
        Option result = this.delegate.find(wrappedFunc);
        if (result.isDefined()) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    @Override
    public Iterator<A> iterator() {
        return new ScalaIteratorAdapter(this.delegate.iterator());
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public int size() {
        return this.delegate.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LazyList other = (LazyList)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate));
    }

    public String toString() {
        return "LazySeq [delegate=" + this.delegate.force() + "]";
    }

    private final <B> CanBuildFrom<Stream<A>, B, Stream<B>> cbf() {
        final CanBuildFrom builder = LazyList.scalaCompanion().canBuildFrom();
        return new CanBuildFrom<Stream<A>, B, Stream<B>>(){

            public Builder<B, Stream<B>> apply() {
                return builder.apply();
            }

            public Builder<B, Stream<B>> apply(Stream<A> from) {
                return builder.apply(from);
            }
        };
    }

    private static Stream$ scalaCompanion() {
        return Stream$.MODULE$;
    }
}

