/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.dto.response;

import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;

public class ResourcesResponse {
    private int id;
    private Long totalCount;
    private int resourceId;
    private String resource;
    private String resourceType;
    private int sublocationId;
    private String sublocation;
    private Boolean active;
    private Integer sharedResourceId;
    private String sharedResourceNotes;

    public ResourcesResponse(int id, int resourceId, String resourceName, String resourceTypeName, int sublocationId, String sublocationName, Boolean active, Long total) {
        this.id = id;
        this.resourceId = resourceId;
        this.resource = resourceName;
        this.resourceType = resourceTypeName;
        this.sublocation = sublocationName;
        this.sublocationId = sublocationId;
        this.active = active;
        this.totalCount = total;
        this.sharedResourceId = null;
        this.sharedResourceNotes = null;
    }

    public ResourcesResponse(int id, int resourceId, String resourceName, String resourceTypeName, int sublocationId, String sublocationName, Boolean active, Integer sharedResourceId, String sharedResourceNotes, Long total) {
        this.id = id;
        this.resourceId = resourceId;
        this.resource = resourceName;
        this.resourceType = resourceTypeName;
        this.sublocation = sublocationName;
        this.sublocationId = sublocationId;
        this.active = active;
        this.totalCount = total;
        this.resourceId = resourceId;
        this.sharedResourceId = sharedResourceId;
        this.sharedResourceNotes = sharedResourceNotes;
    }

    public ResourcesResponse(ResourceSublocation resourceSublocation) {
        this.id = resourceSublocation.getId();
        this.resourceId = resourceSublocation.getResource().getId();
        this.resource = resourceSublocation.getResource().getName();
        this.resourceType = resourceSublocation.getResource().getResourceType().getName();
        this.sublocation = resourceSublocation.getSublocation().getName();
        this.sublocationId = resourceSublocation.getSublocation().getId();
        this.active = resourceSublocation.isActive();
    }

    public Long getTotalCount() {
        return this.totalCount;
    }
}

