/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.security.SchedulerUserDetails;
import edu.harvard.catalyst.scheduler.service.AuthService;
import edu.harvard.catalyst.scheduler.util.OneWayPasswordEncoder;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class SchedulerDbAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private final AuthService authService;

    public SchedulerDbAuthenticationProvider(AuthService authService) {
        this.authService = authService;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken) {
        SchedulerUserDetails user = (SchedulerUserDetails)userDetails;
        String encodedPassword = SchedulerDbAuthenticationProvider.encodePassword(usernamePasswordAuthenticationToken, user);
        if (!userDetails.getPassword().equals(encodedPassword)) {
            SchedulerRuntimeException.logAndThrow("Credentials don't match");
        }
    }

    protected UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken) {
        WebAuthenticationDetails authenticationDetails = (WebAuthenticationDetails)usernamePasswordAuthenticationToken.getDetails();
        SchedulerUserDetails userDetails = this.authService.authenticateUser(username, SchedulerDbAuthenticationProvider.toPassword(usernamePasswordAuthenticationToken), authenticationDetails.getSessionId(), authenticationDetails.getRemoteAddress());
        if (userDetails == null) {
            SchedulerRuntimeException.logAndThrow("Unable to authenticate user");
        }
        return userDetails;
    }

    static String encodePassword(UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken, SchedulerUserDetails user) {
        OneWayPasswordEncoder encoder = OneWayPasswordEncoder.getInstance();
        String password = SchedulerDbAuthenticationProvider.toPassword(usernamePasswordAuthenticationToken);
        return encoder.encode(password, user.getSalt());
    }

    static String toPassword(UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken) {
        return usernamePasswordAuthenticationToken.getCredentials().toString();
    }
}

