/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.service;

import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.hccrc.core.util.Range;
import edu.harvard.catalyst.hccrc.core.util.RichList;
import edu.harvard.catalyst.scheduler.core.SchedulerRuntimeException;
import edu.harvard.catalyst.scheduler.dto.AddStudyMembersDTO;
import edu.harvard.catalyst.scheduler.dto.BooleanResultDTO;
import edu.harvard.catalyst.scheduler.dto.TemplateApprovalHistoryDTO;
import edu.harvard.catalyst.scheduler.dto.VisitDTO;
import edu.harvard.catalyst.scheduler.dto.request.BooleanRequest;
import edu.harvard.catalyst.scheduler.dto.request.VisitTemplatesRequest;
import edu.harvard.catalyst.scheduler.dto.response.FundingSourceInfo;
import edu.harvard.catalyst.scheduler.dto.response.GetStudiesResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudySubjectsResponse;
import edu.harvard.catalyst.scheduler.dto.response.StudyDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.StudyDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithTraListDTO;
import edu.harvard.catalyst.scheduler.dto.response.UserDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitApprovalModelResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplateDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplatesResponse;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.CentersAndInstitutions;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.FundingSource;
import edu.harvard.catalyst.scheduler.entity.HasId;
import edu.harvard.catalyst.scheduler.entity.IRBInstitution;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.RolePair;
import edu.harvard.catalyst.scheduler.entity.RoleType;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudyFundingSource;
import edu.harvard.catalyst.scheduler.entity.StudyStatus;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.StudyUser;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.TemplateApprovalHistory;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.AuthDAO;
import edu.harvard.catalyst.scheduler.persistence.StudyDAO;
import edu.harvard.catalyst.scheduler.persistence.SubjectDAO;
import edu.harvard.catalyst.scheduler.service.AuditService;
import edu.harvard.catalyst.scheduler.util.MailHandler;
import edu.harvard.catalyst.scheduler.util.MailMessageBuilder;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Component
public class StudyService {
    private final MailHandler mailHandler;
    private final StudyDAO studyDAO;
    private final AuthDAO authDAO;
    private final AuditService auditService;
    private final SubjectDAO subjectDAO;
    private static final String NULL = " NULL ";
    private static final String SPACE = " ";
    private static final String TO = " to ";
    private static final String COMMA = ", ";

    @Autowired
    public StudyService(AuditService auditService, StudyDAO studyDAO, AuthDAO authDAO, MailHandler mailHandler, SubjectDAO subjectDAO) {
        this.auditService = auditService;
        this.studyDAO = studyDAO;
        this.authDAO = authDAO;
        this.mailHandler = mailHandler;
        this.subjectDAO = subjectDAO;
    }

    StudyService() {
        this(null, null, null, null, null);
    }

    public GetStudiesResponse getSubjectStudies(int userId) {
        User user = this.authDAO.findUserById(userId);
        if (user.isStudyStaff()) {
            return this.studyDAO.findSubjectStudyListByPerson(user);
        }
        return this.studyDAO.getNonClosedStudies();
    }

    public GetStudiesResponse getOpenStudies(String filterString, String sortBy, String orderBy, int page, int maxResults, User user) {
        if (user.isStudyStaff()) {
            return this.studyDAO.findOpenStudyListByPerson(user, filterString, sortBy, orderBy, page, maxResults);
        }
        return this.studyDAO.getOpenStudies(filterString, sortBy, orderBy, page, maxResults);
    }

    public StudyDTO createStudy(StudyDTO dto, User user, String ipAddress) {
        if (!this.studyDAO.checkLocalId(dto.getLocalId())) {
            dto.setResult(false);
            dto.setErrorMsg("Local Id already exists");
            return dto;
        }
        Study study = new Study();
        List<StudyFundingSource> dependentSFSs = this.setStudyData(dto, study);
        if (study.getStudyStatus().getId() == 2 || study.getStudyStatus().getId() == 3) {
            this.setSomeOtherUsers(dto, study);
        }
        this.studyDAO.createEntity(study);
        for (StudyFundingSource sfs : dependentSFSs) {
            sfs.setStudyId(study.getId());
            this.studyDAO.createEntity(sfs);
        }
        this.stampStudyAndLogStudyActivity(ipAddress, study, user, "CREATE STUDY", null, null);
        dto.setId(study.getId());
        dto.setResult(true);
        return dto;
    }

    void stampStudyAndLogStudyActivity(String ipAddress, Study study, User user, String action, String requiredFieldPreviousData, String previousData) {
        study.setStatusChange(new Date());
        this.studyDAO.updateEntity(study);
        this.auditService.logStudyActivity(ipAddress, study, user, action, requiredFieldPreviousData, previousData);
    }

    private void wipePreviousSFSs(Study study) {
        Set<StudyFundingSource> studyFundingSources = study.getStudyFundingSources();
        studyFundingSources.forEach(this.studyDAO::deleteEntity);
    }

    public StudyDTO updateStudy(StudyDTO dto, User user, String ipAddress) {
        Study study = this.studyDAO.findStudyById(dto.getId());
        if (this.isUniqueLocalId(dto, study)) {
            return dto;
        }
        this.logStudyDataChange(dto, user, ipAddress, study);
        this.wipePreviousSFSs(study);
        List<StudyFundingSource> dependentSFSs = this.setStudyData(dto, study);
        this.setSomeOtherUsers(dto, study);
        this.studyDAO.updateEntity(study);
        for (StudyFundingSource sfs : dependentSFSs) {
            sfs.setStudyId(study.getId());
            this.studyDAO.createEntity(sfs);
        }
        dto.setId(study.getId());
        dto.setResult(true);
        return dto;
    }

    private List<StudyFundingSource> setStudyData(StudyDTO dto, Study s) {
        ArrayList<StudyFundingSource> result = new ArrayList<StudyFundingSource>();
        s.setName(dto.getName());
        s.setStudyStatus(this.studyDAO.findStudyStatusById(dto.getStudyStatus()));
        s.setInstitution(this.studyDAO.findByInstitutionId(dto.getInstitution()));
        boolean isIndustryInitiated = dto.getIndustryInitiated().equalsIgnoreCase("yes");
        s.setIndustryInitiated(isIndustryInitiated);
        s.setLocalId(dto.getLocalId());
        s.setPediatric(dto.getPediatric());
        s.setTotalInpatientVisits(dto.getTotalInpatientVisits());
        s.setExpectedStartDate(dto.getExpectedStartDate());
        s.setExpectedEndDate(dto.getExpectedEndDate());
        s.setTotalOutpatientVisits(dto.getTotalOutpatientVisits());
        s.setTotalSubjects(dto.getTotalSubjects());
        s.setShortTitle(dto.getShortTitle());
        s.setIrbApprovalDate(dto.getIrbApprovalDate());
        s.setIrbExpiration(dto.getIrbExpiration());
        s.setIrbRenewalDate(dto.getIrbRenewalDate());
        s.setCrcCategory(dto.getCrcCategory());
        s.setCatalystId(dto.getCatalystId());
        s.setIrb(dto.getIrb());
        s.setSpid(dto.getSpid());
        s.setIrbInstitution(this.studyDAO.findIRBInstitutionById(dto.getIrbInstitution()));
        for (FundingSourceInfo fundingInfo : dto.getFundingSourceInfoList()) {
            FundingSource fundingSource = this.studyDAO.findFundingSourceById(fundingInfo.getId());
            CentersAndInstitutions centersAndInstitutions = fundingSource.getName().equalsIgnoreCase("Federal PHS") ? this.studyDAO.findCentersAndInstitutionsById(fundingInfo.getCenterAndInstitutionId()) : null;
            StudyFundingSource sfs = new StudyFundingSource(s, fundingSource, centersAndInstitutions, fundingInfo.getOneToFour(), fundingInfo.getComment(), fundingInfo.getGrant(), fundingInfo.getCenter(), fundingInfo.getDirectAward(), fundingInfo.getIndirectAward(), fundingInfo.getStart(), fundingInfo.getEnd());
            result.add(sfs);
        }
        s.setCrcFunded(dto.getCrcFunded());
        s.setStudyAbstract(dto.getStudyAbstract());
        s.setClinicalTrial(dto.getClinicalTrial());
        s.setNewDrug(dto.getNewDrug());
        s.setDeviceExemption(dto.getDeviceExemption());
        return result;
    }

    String comparePreviousAndCurrentFundingSource(StudyFundingSource backEndStudyFundingSource, FundingSourceInfo frontEndFundingSourceInfo, int fsNumber) {
        StringBuilder diffBuilder = new StringBuilder();
        String fsNameBack = NULL;
        String fsNameFront = NULL;
        String grantIdBack = NULL;
        String grantIdFront = NULL;
        String siteCostCenterBack = NULL;
        String siteCostCenterFront = NULL;
        String totalDirectAwardBack = NULL;
        String totalDirectAwardFront = NULL;
        String totalIndirectAwardBack = NULL;
        String totalIndirectAwardFront = NULL;
        String projectStartDateBack = NULL;
        String projectStartDateFront = NULL;
        String projectEndDateBack = NULL;
        String projectEndDateFront = NULL;
        String caiNameBack = NULL;
        String caiNameFront = NULL;
        if (backEndStudyFundingSource != null) {
            fsNameBack = backEndStudyFundingSource.getFundingSource().getName();
            grantIdBack = backEndStudyFundingSource.getGrantId();
            siteCostCenterBack = backEndStudyFundingSource.getSiteCostCenter();
            totalDirectAwardBack = String.valueOf(backEndStudyFundingSource.getTotalDirectAward());
            totalIndirectAwardBack = String.valueOf(backEndStudyFundingSource.getTotalIndirectAward());
            projectStartDateBack = String.valueOf(backEndStudyFundingSource.getProjectStartDate());
            projectEndDateBack = String.valueOf(backEndStudyFundingSource.getProjectEndDate());
            CentersAndInstitutions cai = backEndStudyFundingSource.getCentersAndInstitutions();
            if (cai != null) {
                caiNameBack = cai.getName();
            }
        }
        if (frontEndFundingSourceInfo != null) {
            fsNameFront = frontEndFundingSourceInfo.getName();
            grantIdFront = frontEndFundingSourceInfo.getGrant();
            siteCostCenterFront = frontEndFundingSourceInfo.getCenter();
            totalDirectAwardFront = String.valueOf(frontEndFundingSourceInfo.getDirectAward());
            totalIndirectAwardFront = String.valueOf(frontEndFundingSourceInfo.getIndirectAward());
            projectStartDateFront = String.valueOf(frontEndFundingSourceInfo.getStart());
            projectEndDateFront = String.valueOf(frontEndFundingSourceInfo.getEnd());
            caiNameFront = frontEndFundingSourceInfo.getCenterAndInstitutionName();
        }
        diffBuilder.append(" Funding Source : ").append(fsNumber).append(SPACE);
        diffBuilder.append(fsNameBack).append(TO).append(fsNameFront).append(COMMA);
        diffBuilder.append(" Funding Source GrantId: ").append(fsNumber).append(SPACE);
        diffBuilder.append(grantIdBack).append(TO).append(grantIdFront).append(COMMA);
        diffBuilder.append(" Funding Source Site Cost Center: ").append(fsNumber).append(SPACE);
        diffBuilder.append(siteCostCenterBack).append(TO).append(siteCostCenterFront).append(COMMA);
        diffBuilder.append(" Funding Source Direct Award: ").append(fsNumber).append(SPACE);
        diffBuilder.append(totalDirectAwardBack).append(TO).append(totalDirectAwardFront).append(COMMA);
        diffBuilder.append(" Funding Source Indirect Award: ").append(fsNumber).append(SPACE);
        diffBuilder.append(totalIndirectAwardBack).append(TO).append(totalIndirectAwardFront).append(COMMA);
        diffBuilder.append(" Funding Source Project Start Date: ").append(fsNumber).append(SPACE);
        diffBuilder.append(projectStartDateBack).append(TO).append(projectStartDateFront).append(COMMA);
        diffBuilder.append(" Funding Source Project End Date: ").append(fsNumber).append(SPACE);
        diffBuilder.append(projectEndDateBack).append(TO).append(projectEndDateFront).append(COMMA);
        diffBuilder.append(" Funding Source Centers And Institutes: ").append(fsNumber).append(SPACE);
        diffBuilder.append(caiNameBack).append(TO).append(caiNameFront).append(COMMA);
        return diffBuilder.toString();
    }

    void addToBuilderIfStringsDiff(String label, StringBuilder diffBuilder, String front, String back) {
        if (!front.equals(back)) {
            diffBuilder.append(label).append(back).append(TO).append(front).append(COMMA);
        }
    }

    void addNameToBuilderIfStringsDiffEntityNonNull(String label, HasId entity, StringBuilder diffBuilder, Integer frontId, String frontValue) {
        this.addNameToBuilderIfStringsDiffEntityNonNullHelper(label, entity, diffBuilder, frontId, frontValue, false);
    }

    void addFirstNameToBuilderIfStringsDiffEntityNonNull(String label, BaseEntity entity, StringBuilder diffBuilder, Integer frontId, String frontValue) {
        this.addNameToBuilderIfStringsDiffEntityNonNullHelper(label, entity, diffBuilder, frontId, frontValue, true);
    }

    private void addNameToBuilderIfStringsDiffEntityNonNullHelper(String label, HasId entity, StringBuilder diffBuilder, Integer frontId, String frontValue, boolean first) {
        if (entity == null) {
            diffBuilder.append(label).append(NULL).append(COMMA);
        } else {
            Integer backId = entity.getId();
            if (!frontId.equals(backId)) {
                String tableName = entity.getClass().getSimpleName();
                String backValue = this.studyDAO.findNameById(tableName, backId, first);
                diffBuilder.append(label).append(backValue).append(TO).append(frontValue).append(COMMA);
            }
        }
    }

    void addToBuilderIfObjectsDiffNonNullBack(String label, StringBuilder diffBuilder, Object front, Object back) {
        if (back != null && !back.equals(front)) {
            diffBuilder.append(label).append(back).append(TO).append(front).append(COMMA);
        }
    }

    String findNameByNonZeroId(Class<?> entityClass, int id) {
        return this.findNameByNonZeroId(entityClass, id, false);
    }

    String findFirstNameByNonZeroId(Class<?> entityClass, int id) {
        return this.findNameByNonZeroId(entityClass, id, true);
    }

    String findFirstNameByNonZeroNonMinusOneId(Class<?> entityClass, int id) {
        return id == -1 ? "N/A" : this.findFirstNameByNonZeroId(entityClass, id);
    }

    private String findNameByNonZeroId(Class<?> entityClass, int id, boolean first) {
        String tableName = entityClass.getSimpleName();
        return id != 0 ? this.studyDAO.findNameById(tableName, id, first) : null;
    }

    private static <A> Map<Integer, A> makeFundingSourceMap(Collection<A> sources, Function<A, Integer> getId) {
        return sources.stream().collect(Collectors.toMap(getId, v -> v));
    }

    private void logStudyDataChange(StudyDTO dto, User user, String ipAddress, Study s) {
        StringBuilder diffBuilder = new StringBuilder();
        Map<Integer, StudyFundingSource> backEndFundingSourceMap = StudyService.makeFundingSourceMap(s.getStudyFundingSources(), StudyFundingSource::getOneToFour);
        Map<Integer, FundingSourceInfo> frontEndFundingInfoMap = StudyService.makeFundingSourceMap(dto.getFundingSourceInfoList(), FundingSourceInfo::getOneToFour);
        Range.from((int)1).to(4).inclusive().forEach(i -> {
            StudyFundingSource backEndStudyFundingSource = (StudyFundingSource)backEndFundingSourceMap.get(i);
            FundingSourceInfo frontEndFundingSourceInfo = (FundingSourceInfo)frontEndFundingInfoMap.get(i);
            diffBuilder.append(this.comparePreviousAndCurrentFundingSource(backEndStudyFundingSource, frontEndFundingSourceInfo, (int)i));
        });
        this.buildString(dto, s, diffBuilder);
        this.stampStudyAndLogStudyActivity(ipAddress, s, user, "UPDATE STUDY", diffBuilder.toString(), "");
    }

    private void buildString(StudyDTO dto, Study s, StringBuilder diffBuilder) {
        String studyStatusFrontValue = this.findNameByNonZeroId(StudyStatus.class, dto.getStudyStatus());
        String institutionFrontValue = this.findNameByNonZeroId(Institution.class, dto.getInstitution());
        String irbInstitutionFrontValue = this.findNameByNonZeroId(IRBInstitution.class, dto.getIrbInstitution());
        String investigatorFrontValue = this.findFirstNameByNonZeroId(User.class, dto.getInvestigator());
        String nurseFrontValue = this.findFirstNameByNonZeroNonMinusOneId(User.class, dto.getProtocolNurse());
        String nutritionistFrontValue = this.findFirstNameByNonZeroNonMinusOneId(User.class, dto.getProtocolNutritionist());
        String schedulerFrontValue = this.findFirstNameByNonZeroId(User.class, dto.getScheduler());
        String physicianFrontValue = this.findFirstNameByNonZeroId(User.class, dto.getPhysician());
        String physician2FrontValue = this.findFirstNameByNonZeroId(User.class, dto.getPhysician2());
        String associateNurseFrontValue = this.findFirstNameByNonZeroId(User.class, dto.getAssociateNurse());
        String associateProtocolNutritionistFrontValue = this.findFirstNameByNonZeroId(User.class, dto.getAssociateProtocolNutritionist());
        String secondarySchedulerFrontValue = this.findFirstNameByNonZeroId(User.class, dto.getSecondaryScheduler());
        String scheduler3FrontValue = this.findFirstNameByNonZeroId(User.class, dto.getScheduler3());
        this.addToBuilderIfStringsDiff(" Catalyst ID: ", diffBuilder, dto.getCatalystId(), s.getCatalystId());
        this.addToBuilderIfStringsDiff(" Local ID: ", diffBuilder, dto.getLocalId(), s.getLocalId());
        this.addToBuilderIfStringsDiff(" Study Name: ", diffBuilder, dto.getName(), s.getName());
        this.addNameToBuilderIfStringsDiffEntityNonNull(" Study Status ", s.getStudyStatus(), diffBuilder, dto.getStudyStatus(), studyStatusFrontValue);
        this.addNameToBuilderIfStringsDiffEntityNonNull(" Institution: ", s.getInstitution(), diffBuilder, dto.getInstitution(), institutionFrontValue);
        this.addNameToBuilderIfStringsDiffEntityNonNull(" IRB Institution: ", s.getIrbInstitution(), diffBuilder, dto.getIrbInstitution(), irbInstitutionFrontValue);
        this.addToBuilderIfStringsDiff(" CRC Cat: ", diffBuilder, dto.getCrcCategory(), s.getCrcCategory());
        this.addToBuilderIfStringsDiff(" Pediatric: ", diffBuilder, dto.getPediatric(), s.getPediatric());
        this.addToBuilderIfStringsDiff(" IRB: ", diffBuilder, dto.getIrb(), s.getIrb());
        this.addToBuilderIfObjectsDiffNonNullBack(" IRB Approval: ", diffBuilder, dto.getIrbApprovalDate(), s.getIrbApprovalDate());
        this.addToBuilderIfObjectsDiffNonNullBack(" IRB Expiration: ", diffBuilder, dto.getIrbExpiration(), s.getIrbExpiration());
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Protocol Nurse: ", s.getProtocolNurse(), diffBuilder, dto.getProtocolNurse(), nurseFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Protocol Nutritionist: ", s.getProtocolNutritionist(), diffBuilder, dto.getProtocolNutritionist(), nutritionistFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Scheduler: ", s.getScheduler(), diffBuilder, dto.getScheduler(), schedulerFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Investigator: ", s.getInvestigator(), diffBuilder, dto.getInvestigator(), investigatorFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Scheduler 3: ", s.getScheduler3(), diffBuilder, dto.getScheduler3(), scheduler3FrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Secondary Scheduler: ", s.getSecondaryScheduler(), diffBuilder, dto.getSecondaryScheduler(), secondarySchedulerFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Physician: ", s.getPhysician(), diffBuilder, dto.getPhysician(), physicianFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Physician 2: ", s.getPhysician2(), diffBuilder, dto.getPhysician2(), physician2FrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Associate Nurse: ", s.getAssociateNurse(), diffBuilder, dto.getAssociateNurse(), associateNurseFrontValue);
        this.addFirstNameToBuilderIfStringsDiffEntityNonNull(" Associate Protocol Nutritionist: ", s.getAssociateProtocolNutritionist(), diffBuilder, dto.getAssociateProtocolNutritionist(), associateProtocolNutritionistFrontValue);
    }

    private boolean isUniqueLocalId(StudyDTO dto, Study s) {
        if (!s.getLocalId().equals(dto.getLocalId()) && !this.studyDAO.checkLocalId(dto.getLocalId())) {
            dto.setErrorMsg("Local Id already exists");
            dto.setResult(false);
            return true;
        }
        return false;
    }

    public VisitTemplate createVisit(VisitDTO visit, User user, String ipAddress) {
        Study study = this.studyDAO.findStudyById(visit.getStudyId());
        VisitTemplate visitTemplate = new VisitTemplate.VisitTemplateBuilder().name(visit.getName()).shortName(visit.getShortName()).approved(Boolean.FALSE).relativeTime(visit.isRelativeTime()).nursing(visit.getNursing()).nutrition(visit.getNutrition()).processing(visit.getProcessing()).setup(visit.getSetup()).sublocation(this.studyDAO.findSubLocationById(visit.getSublocation())).createdDate(new Date()).visitType(this.studyDAO.findVisitTypeById(visit.getVisitType())).study(study).institutionNonCRC(visit.isInstitutionNonCRC()).nonInstitutionNonCRC(visit.isNonInstitutionNonCRC()).researchPharmacy(visit.isResearchPharmacy()).active(Boolean.TRUE).lastUpdateTime(new Date()).duration(null).create();
        this.studyDAO.createEntity(visitTemplate);
        this.auditService.logVisitActivity(ipAddress, visitTemplate, user, "CREATE VISIT", null, null);
        if (!visit.getComment().isEmpty()) {
            this.createVisitComments(visit.getComment(), user, ipAddress, visitTemplate);
        }
        return visitTemplate;
    }

    private void createVisitComments(String comment, User user, String ipAddress, VisitTemplate v) {
        Comments comments = new Comments();
        comments.setComment(comment);
        comments.setVisitTemplate(v);
        comments.setUser(user);
        comments.setDate(new Date());
        this.studyDAO.createEntity(comments);
        this.auditService.logVisitActivity(ipAddress, v, user, "CREATE VISIT COMMENT", null, null);
    }

    @Transactional
    public VisitTemplate copyVisit(VisitDTO visitDTO, User user, String ipAddress) {
        VisitTemplate oldVisit = this.studyDAO.findVisitById(visitDTO.getId());
        Sublocation sublocation = oldVisit.getSublocation();
        if (visitDTO.getSublocation() != null && visitDTO.getSublocation() != 0) {
            sublocation = this.studyDAO.findSubLocationById(visitDTO.getSublocation());
        }
        VisitType visitType = oldVisit.getVisitType();
        if (visitDTO.getVisitType() != null && visitDTO.getVisitType() != 0) {
            visitType = this.studyDAO.findVisitTypeById(visitDTO.getVisitType());
        }
        VisitTemplate newVisit = new VisitTemplate.VisitTemplateBuilder().name(visitDTO.getName()).shortName(visitDTO.getShortName()).approved(Boolean.FALSE).relativeTime(oldVisit.getRelativeTime()).nursing(oldVisit.getNursing()).nutrition(oldVisit.getNutrition()).processing(oldVisit.getProcessing()).setup(oldVisit.getSetup()).sublocation(sublocation).createdDate(new Date()).visitType(visitType).study(oldVisit.getStudy()).institutionNonCRC(oldVisit.getInstitutionNonCRC()).nonInstitutionNonCRC(oldVisit.getNonInstitutionNonCRC()).researchPharmacy(oldVisit.getResearchPharmacy()).active(oldVisit.getActive()).lastUpdateTime(new Date()).duration(oldVisit.getDuration()).create();
        this.studyDAO.createEntity(newVisit);
        if (StringUtils.hasText((String)oldVisit.getComment())) {
            this.createVisitComments(oldVisit.getComment(), user, ipAddress, newVisit);
        }
        List<TemplateResourceWithTraListDTO> templateResourceWithTraListDTOList = this.studyDAO.findTemplateResourcesAndAnnotationsByVisit(oldVisit.getId(), "");
        templateResourceWithTraListDTOList.forEach(trwalDto -> {
            TemplateResource newTemplateResource = this.createTemplateResource(newVisit, trwalDto.getTemplateResource());
            this.studyDAO.createEntity(newTemplateResource);
            List<TemplateResourceAnnotations> traList = trwalDto.getTraList();
            traList.stream().map(tra -> {
                TemplateResourceAnnotations newTra = new TemplateResourceAnnotations();
                newTra.setTemplateResource(newTemplateResource);
                newTra.setLineLevelAnnotations(tra.getLineLevelAnnotations());
                newTra.setComment(tra.getComment());
                newTra.setQuantity(tra.getQuantity());
                return newTra;
            }).forEach(this.studyDAO::createEntity);
            if (newTemplateResource.getGroupId() != null) {
                TemplateResourceGroup templateResourceGroup = new TemplateResourceGroup();
                templateResourceGroup.setGroupId(newTemplateResource.getGroupId());
                templateResourceGroup.setTemplateResource(newTemplateResource);
                templateResourceGroup.setVisit(newVisit);
                templateResourceGroup.setFlexGroup(newTemplateResource.getFlexible());
                this.studyDAO.createEntity(templateResourceGroup);
            }
        });
        this.auditService.logVisitActivity(ipAddress, newVisit, user, "COPY VISIT", null, null);
        return newVisit;
    }

    private TemplateResource createTemplateResource(VisitTemplate visitTemplate, TemplateResource oldTemplateResource) {
        TemplateResource newTemplateResource = new TemplateResource();
        Date now = new Date();
        newTemplateResource.setCreatedDate(now);
        newTemplateResource.setLastUpdateTime(now);
        newTemplateResource.setVisitTemplate(visitTemplate);
        newTemplateResource.setAlternate(oldTemplateResource.getAlternate());
        newTemplateResource.setBillable(oldTemplateResource.getBillable());
        newTemplateResource.setResource(oldTemplateResource.getResource());
        newTemplateResource.setFlexible(oldTemplateResource.getFlexible());
        newTemplateResource.setFloatable(oldTemplateResource.getFloatable());
        newTemplateResource.setFloatStart(oldTemplateResource.getFloatStart());
        newTemplateResource.setFloatEnd(oldTemplateResource.getFloatEnd());
        newTemplateResource.setStartDate(oldTemplateResource.getStartDate());
        newTemplateResource.setEndDate(oldTemplateResource.getEndDate());
        newTemplateResource.setDuration(oldTemplateResource.getDuration());
        if (oldTemplateResource.getGroupId() != null) {
            newTemplateResource.setGroupId(oldTemplateResource.getGroupId() + newTemplateResource.getVisitTemplate().getId().toString());
        }
        return newTemplateResource;
    }

    public VisitTemplate updateVisit(VisitDTO visitDTO, User user, String ipAddress) {
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(visitDTO.getId());
        StringBuilder diffBuilder = new StringBuilder();
        StringBuilder diffBuilder2 = new StringBuilder();
        String visitType = StudyService.findVisitTypeById(visitDTO).orElse(null);
        String sublocation = this.findNameByNonZeroId(Sublocation.class, visitDTO.getSublocation());
        this.addToBuilderIfObjectsDiffNonNullBack(" Institution Non CRC: ", diffBuilder2, visitDTO.isInstitutionNonCRC(), visitTemplate.getInstitutionNonCRC());
        this.addToBuilderIfObjectsDiffNonNullBack(" Non Institution Non CRC: ", diffBuilder2, visitDTO.isNonInstitutionNonCRC(), visitTemplate.getNonInstitutionNonCRC());
        this.addToBuilderIfObjectsDiffNonNullBack(" Relative Time: ", diffBuilder2, visitDTO.isRelativeTime(), visitTemplate.getRelativeTime());
        this.addToBuilderIfObjectsDiffNonNullBack(" Research Pharmacy: ", diffBuilder2, visitDTO.isResearchPharmacy(), visitTemplate.getResearchPharmacy());
        this.addToBuilderIfStringsDiff(" Visit Name: ", diffBuilder, visitDTO.getName(), visitTemplate.getName());
        this.addToBuilderIfStringsDiff(" Visit Type: ", diffBuilder, visitType, visitTemplate.getVisitType().getName());
        this.addNameToBuilderIfStringsDiffEntityNonNull(" Sub-location: ", visitTemplate.getSublocation(), diffBuilder, visitDTO.getSublocation(), sublocation);
        this.addToBuilderIfObjectsDiffNonNullBack(" Nursing: ", diffBuilder, visitDTO.getNursing(), visitTemplate.getNursing());
        this.addToBuilderIfObjectsDiffNonNullBack(" Nutrition: ", diffBuilder, visitDTO.getNutrition(), visitTemplate.getNutrition());
        this.addToBuilderIfObjectsDiffNonNullBack(" Processing: ", diffBuilder, visitDTO.getProcessing(), visitTemplate.getProcessing());
        this.addToBuilderIfObjectsDiffNonNullBack(" Set-Up: ", diffBuilder, visitDTO.getSetup(), visitTemplate.getSetup());
        visitTemplate.setInstitutionNonCRC(visitDTO.isInstitutionNonCRC());
        visitTemplate.setNonInstitutionNonCRC(visitDTO.isNonInstitutionNonCRC());
        visitTemplate.setRelativeTime(visitDTO.isRelativeTime());
        visitTemplate.setResearchPharmacy(visitDTO.isResearchPharmacy());
        visitTemplate.setName(visitDTO.getName());
        visitTemplate.setShortName(visitDTO.getShortName());
        visitTemplate.setVisitType(this.studyDAO.findVisitTypeById(visitDTO.getVisitType()));
        visitTemplate.setSublocation(this.studyDAO.findSubLocationById(visitDTO.getSublocation()));
        visitTemplate.setNursing(visitDTO.getNursing());
        visitTemplate.setNutrition(visitDTO.getNutrition());
        visitTemplate.setProcessing(visitDTO.getProcessing());
        visitTemplate.setSetup(visitDTO.getSetup());
        String comment = visitDTO.getComment();
        if (comment != null && !comment.isEmpty()) {
            this.createVisitComments(comment, user, ipAddress, visitTemplate);
            visitTemplate.setComment(comment);
        }
        visitTemplate.setLastUpdateTime(new Date());
        this.studyDAO.updateEntity(visitTemplate);
        this.auditService.logVisitActivity(ipAddress, visitTemplate, user, "UPDATE VISIT", diffBuilder.toString(), diffBuilder2.toString());
        return visitTemplate;
    }

    static Optional<String> findVisitTypeById(VisitDTO visitDTO) {
        return VisitType.findById(visitDTO.getVisitType()).map(VisitType::getName);
    }

    private void logViewVisit(int visitId, User user, String ipAddress) {
        VisitTemplate s = this.studyDAO.findVisitById(visitId);
        this.auditService.logVisitActivity(ipAddress, s, user, "VIEW VISIT", null, null);
    }

    public GetStudySubjectsResponse getStudySubjects(Optional<String> nullableFilterString, Integer ofPage, Integer ofMaxResults, Optional<Integer> ofStudyId, String ofSortBy, String ofOrderBy, Boolean ofWantAll, Optional<User> ofUser) {
        boolean isLegitStudy;
        Study study = this.studyDAO.findStudyById(ofStudyId.get());
        User user = ofUser.get();
        if (user.isStudyStaff() && !(isLegitStudy = this.studyDAO.isStudyByPersonAndStudy(user, study))) {
            return null;
        }
        List<StudySubject> resultRows = this.studyDAO.getRawStudySubjectsByStudy(study, ofWantAll);
        return this.getAllStudySubjectsByStudy(resultRows, nullableFilterString, ofPage, ofMaxResults, ofSortBy, ofOrderBy);
    }

    private GetStudySubjectsResponse getAllStudySubjectsByStudy(List<StudySubject> resultRows, Optional<String> nullableFilterString, Integer ofPage, Integer ofMaxResults, String ofSortBy, String ofOrderBy) {
        String filterString = nullableFilterString.orElse("");
        boolean filterStringIsPresent = !filterString.isEmpty();
        List<StudySubject> finalList = RichList.enrich(resultRows).map(studySubject -> {
            SubjectDataEncryptor.decryptSubjectWithinStudySubject(studySubject);
            return studySubject;
        }).filter(studySubject -> {
            Subject decryptedSubject = studySubject.getSubject();
            SubjectMrn subjectMrn = studySubject.getSubjectMrn();
            String decryptedMrn = subjectMrn != null ? SubjectDataEncryptor.decrypt(subjectMrn.getMrn()) : null;
            String decrytpedLname = decryptedSubject.getLastName();
            boolean matches = decryptedMrn != null && decryptedMrn.contains(filterString.toUpperCase()) || decrytpedLname != null && decrytpedLname.contains(filterString.toUpperCase());
            return filterStringIsPresent && matches;
        }).toList();
        List<StudySubject> resultRowsToSort = filterStringIsPresent ? finalList : resultRows;
        int total = resultRowsToSort.size();
        this.sortStudySubjectData(ofSortBy, ofOrderBy, resultRowsToSort);
        List<StudySubject> filteredRows = this.paginateStudySubjectData(ofPage, ofMaxResults, resultRowsToSort, total);
        return GetStudySubjectsResponse.createGetStudiesSubjectsResponse(filteredRows, Long.valueOf(total));
    }

    private List<StudySubject> paginateStudySubjectData(Integer ofPage, Integer ofMaxResults, List<StudySubject> resultRows, int total) {
        int offset = (ofPage - 1) * ofMaxResults;
        List<StudySubject> filteredRows = offset + ofMaxResults <= total ? resultRows.subList(offset, offset + ofMaxResults) : (offset + ofMaxResults > total ? resultRows.subList(offset, total) : new ArrayList<StudySubject>());
        return filteredRows;
    }

    private void sortStudySubjectData(String ofSortBy, String ofOrderBy, List<StudySubject> resultRows) {
        if (ofOrderBy.equalsIgnoreCase("ASC")) {
            this.sortStudySubjectAscending(ofSortBy, resultRows);
        } else if (ofOrderBy.equalsIgnoreCase("DESC")) {
            this.sortStudySubjectDescending(ofSortBy, resultRows);
        }
    }

    private void sortStudySubjectDescending(String ofSortBy, List<StudySubject> resultRows) {
        if (ofSortBy.equalsIgnoreCase("lastName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectLastNameComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("mrn")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectMRNComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("firstName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectFirstNameComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("primaryContactNumber")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectContactComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("birthdate")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectBirthdateComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("city")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectCityComparatorDesc);
        } else if (ofSortBy.equalsIgnoreCase("state")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectStateComparatorDesc);
        }
    }

    private void sortStudySubjectAscending(String ofSortBy, List<StudySubject> resultRows) {
        if (ofSortBy.equalsIgnoreCase("lastName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectLastNameComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("mrn")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectMRNComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("firstName")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectFirstNameComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("primaryContactNumber")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectContactComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("birthdate")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectBirthdateComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("city")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectCityComparatorAsc);
        } else if (ofSortBy.equalsIgnoreCase("state")) {
            Collections.sort(resultRows, GetStudySubjectsResponse.StudySubjectStateComparatorAsc);
        }
    }

    public List<StudyUser> getStudyMembers(int studyId) {
        Study study = this.studyDAO.findStudyById(studyId);
        return this.studyDAO.findStudyUserRolesByStudy(study);
    }

    public BooleanRequest deleteVisit(int visit, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(visit);
        boolean bookedVisitsHaveVisit = this.studyDAO.ifBookedVisitsHaveVisit(visitTemplate);
        if (bookedVisitsHaveVisit) {
            booleanRequest.setResult(false);
            return booleanRequest;
        }
        List<ActivityLog> activityLogs = this.studyDAO.findActivityLogByVisit(visitTemplate);
        List<TemplateApprovalHistory> templateApprovalHistories = this.studyDAO.findTemplateApprovalHistoryByVisit(visitTemplate);
        List<Comments> comments = this.studyDAO.findVisitTemplateCommentsByVisit(visitTemplate);
        String visitName = visitTemplate.getName();
        activityLogs.forEach(this.studyDAO::deleteEntity);
        templateApprovalHistories.forEach(this.studyDAO::deleteEntity);
        comments.forEach(this.studyDAO::deleteEntity);
        List<TemplateResource> templateResources = this.studyDAO.findTemplateResourcesByVisit(visitTemplate);
        templateResources.forEach(tr -> this.deleteTemplateResource(visitTemplate, (TemplateResource)tr));
        this.studyDAO.deleteEntity(visitTemplate);
        this.auditService.logDeleteVisitActivity(ipAddress, visitName, user, "DELETE VISIT", null, null);
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    private void deleteTemplateResource(VisitTemplate visitTemplate, TemplateResource templateResource) {
        List<TemplateResourceAnnotations> templateResourceAnnotations = this.studyDAO.findTemplateResourceAnnotationsByTemplateResource(templateResource);
        List<TemplateResourceGroup> templateResourceGroups = this.studyDAO.findTemplateResourceGroupByVisitAndTemplate(visitTemplate, templateResource);
        if (templateResourceGroups != null) {
            templateResourceGroups.forEach(this.studyDAO::deleteEntity);
        }
        templateResourceAnnotations.forEach(this.studyDAO::deleteEntity);
        this.studyDAO.deleteEntity(templateResource);
    }

    public BooleanResultDTO changeVisitTemplateStatus(VisitTemplatesRequest visits, boolean activate, User user, String ipAddress) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        if (!visits.getVisitTemplatesId().isEmpty()) {
            Range.from((int)0).to(visits.getVisitTemplatesId().size()).forEach(i -> {
                String logStatus;
                VisitTemplate s = this.studyDAO.findVisitById(visits.getVisitTemplatesId().get((int)i));
                if (activate) {
                    logStatus = "ACTIVATE VISIT";
                    s.setActive(Boolean.TRUE);
                } else {
                    logStatus = "DEACTIVATE VISIT";
                    s.setActive(Boolean.FALSE);
                }
                s.setLastUpdateTime(new Date());
                this.studyDAO.updateEntity(s);
                this.auditService.logVisitActivity(ipAddress, s, user, logStatus, null, null);
                booleanResultDTO.setResult(true);
            });
        } else {
            booleanResultDTO.setResult(false);
        }
        return booleanResultDTO;
    }

    void stampStudyAndLogStudySubjectActivity(String ipAddress, Study study, Subject subject, User user, String action, String requiredFieldPreviousData, String previousData) {
        study.setStatusChange(new Date());
        this.studyDAO.updateEntity(study);
        this.auditService.logStudySubjectActivity(ipAddress, study, subject, user, action, requiredFieldPreviousData, previousData);
    }

    void stampStudyAndLogStudySubjectMrnActivity(String ipAddress, Study study, SubjectMrn subjectMrn, User user, String action, String requiredFieldPreviousData, String previousData) {
        study.setStatusChange(new Date());
        this.studyDAO.updateEntity(study);
        this.auditService.logStudyAndSubjectMrnActivity(ipAddress, study, subjectMrn, user, action, requiredFieldPreviousData, previousData);
    }

    void stampStudyAndLogStudyMemberActivity(String ipAddress, Study study, User studyUser, User user, String action, String requiredFieldPreviousData, String previousData) {
        study.setStatusChange(new Date());
        this.studyDAO.updateEntity(study);
        this.auditService.logStudyMemberActivity(ipAddress, study, studyUser, user, action, requiredFieldPreviousData, previousData);
    }

    public BooleanResultDTO assignStudyMembers(AddStudyMembersDTO dto, User usr, String ipAddress, String templatePath) {
        BooleanResultDTO booleanResultDTO = new BooleanResultDTO();
        booleanResultDTO.setResult(false);
        ArrayList<StudyUser> sendEmails = new ArrayList<StudyUser>();
        Study s = this.studyDAO.findStudyById(dto.getStudyId());
        for (int i = 0; i < dto.getStudyMembers().size(); ++i) {
            User user = this.studyDAO.findByStudyMemberId(dto.getStudyMembers().get(i));
            StudyUser studyUser = new StudyUser();
            studyUser.setStudy(s);
            studyUser.setUser(user);
            studyUser.setActive(Boolean.TRUE);
            try {
                this.stampStudyAndLogStudyMemberActivity(ipAddress, s, user, usr, "ADD STUDY MEMBER", null, null);
                this.studyDAO.createEntity(studyUser);
                sendEmails.add(studyUser);
                continue;
            }
            catch (ConstraintViolationException ex) {
                SchedulerRuntimeException.logDontThrow("assignStudyMembers() constraint violation", (Exception)((Object)ex));
                return booleanResultDTO;
            }
        }
        this.sendStudyMemberEmails(sendEmails, usr.getInstitution().getLongName(), templatePath);
        booleanResultDTO.setResult(true);
        return booleanResultDTO;
    }

    private void sendStudyMemberEmails(List<StudyUser> users, String institution, String templatePath) {
        String title = "You have been granted access to study. ";
        List messages = ListUtils.enrich(users).map(u -> {
            String to = u.getUser().getPreferredNotificationEmail();
            String studyname = u.getStudy().getName();
            String local = u.getStudy().getLocalId();
            String catid = u.getStudy().getCatalystId();
            String spid = u.getStudy().getSpid();
            String irb = u.getStudy().getIrb();
            StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
            StringTemplate studyMemberEmail = group.getInstanceOf("email");
            studyMemberEmail.setAttribute("institution", (Object)institution);
            studyMemberEmail.setAttribute("studyName", (Object)studyname);
            studyMemberEmail.setAttribute("local", (Object)local);
            studyMemberEmail.setAttribute("catid", (Object)catid);
            studyMemberEmail.setAttribute("spid", (Object)spid);
            studyMemberEmail.setAttribute("irb", (Object)irb);
            return Optional.of(u.getUser().getEmail()).map(email -> new MailMessageBuilder().to(to).subject("You have been granted access to study. ").text(studyMemberEmail.toString()).build());
        }).toList();
        ListUtils.flatten((List)messages).forEach(this.mailHandler::sendOptionalEmails);
    }

    public List<Comments> getVisitTemplateComments(int visitId) {
        VisitTemplate visit = this.studyDAO.findVisitById(visitId);
        return this.studyDAO.findVisitTemplateCommentsByVisit(visit);
    }

    public TemplateApprovalHistory approveVisitTemplate(TemplateApprovalHistoryDTO visit, User user, String ipAddress, String templatePath) {
        TemplateApprovalHistory history;
        VisitTemplate visitTemplate = this.studyDAO.findVisitById(visit.getVisitTemplate());
        User u = this.authDAO.findUserById(visit.getUser().getId());
        TemplateApprovalHistory approvalUser = this.studyDAO.findTemplateApprovalHistoryByVisitAndUser(visitTemplate, user);
        if (approvalUser != null) {
            history = this.studyDAO.findTemplateApprovalHistoryByVisitAndUser(visitTemplate, visit.getUser());
            history.setVisitTemplate(visitTemplate);
            history.setComment(visit.getComment());
            history.setApproved(Boolean.TRUE);
            if (u.getRole() != null && u.getRole().getType() == RoleType.ROLE_FINAL_APPROVER) {
                visitTemplate.setApproved(Boolean.TRUE);
                this.studyDAO.updateEntity(visitTemplate);
            }
            history.setUser(visit.getUser());
            history.setStatusChangeTime(new Date());
            visitTemplate.setLastUpdateTime(new Date());
            this.studyDAO.updateEntity(visitTemplate);
            this.studyDAO.updateEntity(history);
        } else {
            history = new TemplateApprovalHistory(visit.getUser(), null, null, null, Boolean.TRUE, visit.getComment(), new Date(), visitTemplate, null, null);
            if (u.getRole() != null && u.getRole().getType() == RoleType.ROLE_FINAL_APPROVER) {
                visitTemplate.setApproved(Boolean.TRUE);
                this.studyDAO.updateEntity(visitTemplate);
            }
            visitTemplate.setLastUpdateTime(new Date());
            this.studyDAO.updateEntity(visitTemplate);
            this.studyDAO.createEntity(history);
        }
        this.auditService.logVisitActivity(ipAddress, visitTemplate, user, "APPROVED VISIT TEMPLATE", null, null);
        this.sendVisitApprovalEmail(visitTemplate, u, ipAddress, user.getInstitution().getLongName(), templatePath);
        return history;
    }

    private void sendVisitApprovalEmail(VisitTemplate visitTemplate, User user, String ipAddress, String institution, String templatePath) {
        String studyName = visitTemplate.getStudy().getName();
        String userRole = user.getRole().getName();
        String visitName = visitTemplate.getName();
        String localId = visitTemplate.getStudy().getLocalId();
        String catid = visitTemplate.getStudy().getCatalystId();
        String spid = visitTemplate.getStudy().getSpid();
        String irb = visitTemplate.getStudy().getIrb();
        String title = "Visit Template is Approved. ";
        StringTemplateGroup group = new StringTemplateGroup("underwebinf", templatePath, DefaultTemplateLexer.class);
        StringTemplate userEmail = group.getInstanceOf("visitApprovalEmail");
        userEmail.setAttribute("institution", (Object)institution);
        userEmail.setAttribute("userRole", (Object)userRole);
        userEmail.setAttribute("visitName", (Object)visitName);
        userEmail.setAttribute("studyName", (Object)studyName);
        userEmail.setAttribute("local", (Object)localId);
        userEmail.setAttribute("catid", (Object)catid);
        userEmail.setAttribute("spid", (Object)spid);
        userEmail.setAttribute("irb", (Object)irb);
        User protocolNutritionist = visitTemplate.getStudy().getProtocolNutritionist();
        User protocolNurse = visitTemplate.getStudy().getProtocolNurse();
        User scheduler = visitTemplate.getStudy().getScheduler();
        RoleType roleType = user.getRole().getType();
        if (roleType == RoleType.ROLE_FINAL_APPROVER) {
            this.sentVisitApprovalEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, scheduler);
            this.sentVisitApprovalEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, protocolNutritionist);
            this.sentVisitApprovalEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, protocolNurse);
        } else if (roleType == RoleType.ROLE_ADMINISTRATIVE_DIRECTOR) {
            List<User> usersList = this.authDAO.findFinalApproverByRole();
            this.sendUserEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, usersList);
        } else if (roleType == RoleType.ROLE_SCHEDULER) {
            List<User> nurseList = this.authDAO.findNurseManagerUserByRole();
            List<User> nutritionList = this.authDAO.findNutritionManagerUserByRole();
            this.sentVisitApprovalEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, protocolNutritionist);
            this.sentVisitApprovalEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, protocolNurse);
            this.sendUserEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, nurseList);
            this.sendUserEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, nutritionList);
        } else if (roleType == RoleType.ROLE_PROTOCOL_NURSE || roleType == RoleType.ROLE_PROTOCOL_NUTRITIONIST) {
            List<User> usersList = this.authDAO.findAdminDirectorUserByRole();
            this.sendUserEmails(visitTemplate, user, ipAddress, "Visit Template is Approved. ", userEmail, usersList);
        }
    }

    private void sendUserEmails(VisitTemplate v, User u, String ipAddress, String title, StringTemplate userEmail, List<User> users) {
        if (!users.isEmpty()) {
            for (User user : users) {
                this.sentVisitApprovalEmails(v, u, ipAddress, title, userEmail, user);
            }
        }
    }

    private void sentVisitApprovalEmails(VisitTemplate v, User u, String ipAddress, String title, StringTemplate userEmail, User user) {
        if (user != null) {
            this.mailHandler.sendOptionalEmails(new MailMessageBuilder().to(user.getPreferredNotificationEmail()).subject(title).text(userEmail.toString()).build());
            String previousData = " Email : " + user.getEmail() + " and Role : " + user.getRole().getName();
            this.auditService.logVisitApprovalActivity(ipAddress, v, u, user, "APPROVED VISIT TEMPLATE EMAIL SENT", previousData, null);
        }
    }

    public TemplateApprovalHistory commentVisitTemplate(TemplateApprovalHistoryDTO visit, User user, String ipAddress) {
        TemplateApprovalHistory history;
        VisitTemplate visits = this.studyDAO.findVisitById(visit.getVisitTemplate());
        User u = this.authDAO.findUserById(visit.getUser().getId());
        TemplateApprovalHistory approvalUser = this.studyDAO.findTemplateApprovalHistoryByVisitAndUser(visits, user);
        if (approvalUser != null) {
            history = this.studyDAO.findTemplateApprovalHistoryByVisitAndUser(visits, visit.getUser());
            history.setVisitTemplate(visits);
            history.setComment(visit.getComment());
            history.setApproved(Boolean.FALSE);
            history.setUser(visit.getUser());
            history.setStatusChangeTime(new Date());
            this.studyDAO.updateEntity(history);
        } else {
            history = new TemplateApprovalHistory(visit.getUser(), null, null, null, Boolean.FALSE, visit.getComment(), new Date(), visits, null, null);
            this.studyDAO.createEntity(history);
        }
        if (u.getRole() != null && u.getRole().getType() == RoleType.ROLE_FINAL_APPROVER) {
            visits.setApproved(Boolean.FALSE);
        }
        visits.setLastUpdateTime(new Date());
        this.studyDAO.updateEntity(visits);
        this.auditService.logVisitActivity(ipAddress, visits, user, "COMMENT VISIT TEMPLATE", null, null);
        return history;
    }

    public List<VisitApprovalModelResponseDTO.VisitApproval> getVisitApprovals(int visitId, String sortBy, String orderBy, int page, int maxResults) {
        return this.studyDAO.getVisitApprovals(visitId, sortBy, orderBy, page, maxResults);
    }

    List<VisitTemplatesResponse> adjustVisitsPerPageAndMaxResults(int page, int maxResults, List<VisitTemplatesResponse> visitsParam) {
        ArrayList<VisitTemplatesResponse> visitsResult = new ArrayList<VisitTemplatesResponse>(visitsParam);
        int grandTotal = visitsResult.size();
        for (VisitTemplatesResponse visit : visitsResult) {
            visit.setTotalCount(grandTotal);
        }
        int start = (page - 1) * maxResults;
        if (start + maxResults <= grandTotal) {
            return visitsResult.subList(start, start + maxResults);
        }
        if (start + maxResults > grandTotal) {
            return visitsResult.subList(start, grandTotal);
        }
        return visitsResult;
    }

    boolean seeAllUnapprovedExceptUserApproved(RoleType userRole, InstitutionRoleType institutionRole) {
        Map<RolePair, Boolean> rolePairMap = RolePair.getRolePairMap();
        return rolePairMap.get(new RolePair(userRole, institutionRole)) != null;
    }

    boolean seeAllUnapproved(RoleType userRole, InstitutionRoleType institutionRole) {
        return userRole == RoleType.ROLE_FINAL_APPROVER && institutionRole == InstitutionRoleType.ROLE_SUPER_ADMIN;
    }

    public List<VisitTemplatesResponse> getTemplatesToApprove(String sortBy, String orderBy, int page, int maxResults, int userId, String ipAddress) {
        User user = this.authDAO.findUserById(userId);
        RoleType userRole = user.getRole().getType();
        InstitutionRoleType institutionRole = user.getInstitutionRole().getType();
        this.auditService.logViewActivity(ipAddress, user, "HOME SCREEN -Template Approval View.");
        if (this.seeAllUnapproved(userRole, institutionRole)) {
            return this.studyDAO.getNotApprovedVisits(sortBy, orderBy, page, maxResults);
        }
        if (this.seeAllUnapprovedExceptUserApproved(userRole, institutionRole)) {
            return this.removeApprovedVisitsByUser(user, this.studyDAO.getNotApprovedVisits(sortBy, orderBy, page, maxResults));
        }
        if (institutionRole == InstitutionRoleType.ROLE_STUDY_STAFF) {
            List<Study> studyStaffStudies = this.studyDAO.findStudyListByPerson(user);
            List<VisitTemplatesResponse> withStudies = this.addStudysVisitToList(studyStaffStudies, Collections.emptyList(), user);
            List<VisitTemplatesResponse> withoutApprovedVisits = this.removeApprovedVisitsByUser(user, withStudies);
            return this.adjustVisitsPerPageAndMaxResults(page, maxResults, withoutApprovedVisits);
        }
        List<Study> schedulerStudies = this.studyDAO.findStudyBySchduler(user);
        List<Study> piStudies = this.studyDAO.findStudyByPI(user);
        List<Study> nurseStudies = this.studyDAO.findStudyByNurse(user);
        List<Study> nutritionistStudies = this.studyDAO.findStudyByNutritionist(user);
        List<VisitTemplatesResponse> withPiStudies = this.addStudysVisitToList(piStudies, Collections.emptyList(), user);
        List<VisitTemplatesResponse> withNurseStudies = this.addStudysVisitToList(nurseStudies, withPiStudies, user);
        List<VisitTemplatesResponse> withNutritionistStudies = this.addStudysVisitToList(nutritionistStudies, withNurseStudies, user);
        return this.addStudysVisitToList(schedulerStudies, withNutritionistStudies, user);
    }

    private List<VisitTemplatesResponse> removeApprovedVisitsByUser(User user, List<VisitTemplatesResponse> visits) {
        List<TemplateApprovalHistory> userTemplateHistory = this.studyDAO.findTemplateApprovalHistoryListByUser(user);
        List<VisitTemplatesResponse> userApprovedTemplates = this.getUserApprovedTemplates(userTemplateHistory);
        ArrayList<VisitTemplatesResponse> result = new ArrayList<VisitTemplatesResponse>(visits);
        result.removeAll(userApprovedTemplates);
        return result;
    }

    List<VisitTemplatesResponse> addStudysVisitToList(List<Study> studyList, List<VisitTemplatesResponse> visitTemplateListParam, User user) {
        if (studyList == null || studyList.isEmpty()) {
            return visitTemplateListParam;
        }
        List<TemplateApprovalHistory> userTemplateHistory = this.studyDAO.findTemplateApprovalHistoryListByUser(user);
        List<VisitTemplatesResponse> userApprovedTemplates = this.getUserApprovedTemplates(userTemplateHistory);
        ArrayList<VisitTemplatesResponse> accumulator = new ArrayList<VisitTemplatesResponse>(visitTemplateListParam);
        for (Study study : studyList) {
            List<VisitTemplate> visitTemplateList = this.studyDAO.findVisitTemplateByStudy(study);
            long total = visitTemplateList.size();
            for (VisitTemplate visitTemplate : visitTemplateList) {
                List<TemplateApprovalHistory> history = this.studyDAO.findTemplateApprovalHistoryListByVisitAndUser(visitTemplate, user);
                if (history != null && !history.isEmpty()) {
                    for (TemplateApprovalHistory vi : history) {
                        total = history.size();
                        VisitTemplatesResponse visitDetail = this.studyDAO.setVisitTemplateData(total, vi.getVisitTemplate());
                        accumulator.add(visitDetail);
                    }
                    accumulator.removeAll(userApprovedTemplates);
                    continue;
                }
                VisitTemplatesResponse visitDetail = this.studyDAO.setVisitTemplateData(total, visitTemplate);
                accumulator.add(visitDetail);
            }
        }
        return accumulator;
    }

    private List<VisitTemplatesResponse> getUserApprovedTemplates(List<TemplateApprovalHistory> userTemplateHistory) {
        return userTemplateHistory.stream().map(th -> {
            long total = userTemplateHistory.size();
            VisitTemplate visitTemplate = th.getVisitTemplate();
            return this.studyDAO.setVisitTemplateData(total, visitTemplate);
        }).collect(Collectors.toList());
    }

    public void sendStudyInformation() {
        List<Study> studies = this.studyDAO.getStudies();
        if (!studies.isEmpty()) {
            for (Study study : studies) {
                Date irbDate;
                long irbTime;
                LocalDateTime fourteenDaysFromToday = LocalDateTime.now().plusDays(14L);
                long diffTime = StudyService.toDate(fourteenDaysFromToday).getTime();
                if (study.getIrbExpiration() == null || diffTime != (irbTime = (irbDate = study.getIrbExpiration()).getTime())) continue;
                String subject = "Study expiring on " + irbDate;
                String content = this.makeEmailContents(study, irbDate, subject);
                List<User> finalApprovers = this.authDAO.findFinalApproverByRole();
                List<User> adminDirectors = this.authDAO.findAdminDirectorUserByRole();
                List<User> crcAdmin = this.authDAO.findCRCAdminByRole();
                List<Object> recipients = study.getStudyStatus().getId().equals(1) ? finalApprovers : (study.getStudyStatus().getId().equals(2) ? ListUtils.concat(finalApprovers, (List[])new List[]{adminDirectors, crcAdmin}) : Collections.emptyList());
                recipients.stream().map(StudyService.toMessageFromUser(subject, content)).forEach(this.mailHandler::sendOptionalEmails);
            }
        }
    }

    private static Date toDate(LocalDateTime fourteenDaysFromToday) {
        return Date.from(fourteenDaysFromToday.atZone(ZoneId.systemDefault()).toInstant());
    }

    private String makeEmailContents(Study study, Date irbDate, String subject) {
        StringBuilder content = new StringBuilder();
        content.append("\n<html><head><title>").append(subject).append("</title><style></style>\n").append("</head>\n").append("<body>");
        String dearString = study.getStudyStatus().getName().equalsIgnoreCase("Open") ? "Dear Study Team Member/Final Approver" : "Dear Final Approver";
        content.append("<p><strong>").append(dearString).append("</strong></p>\n").append("<p>This is an automatic email notification that the IRB approval for the study ").append(study.getName()).append(SPACE).append(" is scheduled to expire on ").append(irbDate).append(study.getStudyStatus().getName().equalsIgnoreCase("Open") ? ". Please contact your local administrator for information regarding submission for renewal." : "").append("</p>\n<p>Thank you</p>\n").append("<p>NOTE: This is an automatic email, please do not reply..</p>\n").append("</body>\n").append("</html>\n");
        return content.toString();
    }

    private static Function<User, SimpleMailMessage> toMessageFromUser(String subject, String content) {
        return u -> new MailMessageBuilder().to(u.getEmail()).subject(subject).text(content).build();
    }

    User nullForZeroFindUserForNonZeroId(int id) {
        if (id != 0) {
            return this.authDAO.findUserById(id);
        }
        return null;
    }

    void setSomeOtherUsers(StudyDTO studyDTO, Study study) {
        study.setInvestigator(this.authDAO.findUserById(studyDTO.getInvestigator()));
        study.setScheduler(this.authDAO.findUserById(studyDTO.getScheduler()));
        study.setPhysician(this.nullForZeroFindUserForNonZeroId(studyDTO.getPhysician()));
        study.setPhysician2(this.nullForZeroFindUserForNonZeroId(studyDTO.getPhysician2()));
        study.setAssociateNurse(this.nullForZeroFindUserForNonZeroId(studyDTO.getAssociateNurse()));
        study.setAssociateProtocolNutritionist(this.nullForZeroFindUserForNonZeroId(studyDTO.getAssociateProtocolNutritionist()));
        study.setSecondaryScheduler(this.nullForZeroFindUserForNonZeroId(studyDTO.getSecondaryScheduler()));
        study.setScheduler3(this.nullForZeroFindUserForNonZeroId(studyDTO.getScheduler3()));
        if (studyDTO.getProtocolNurse() == -1) {
            study.setProtocolNurseString("N/A");
            study.setProtocolNurse(null);
        } else {
            study.setProtocolNurse(this.authDAO.findUserById(studyDTO.getProtocolNurse()));
            study.setProtocolNurseString(null);
        }
        if (studyDTO.getProtocolNutritionist() == -1) {
            study.setProtocolNutritionistString("N/A");
            study.setProtocolNutritionist(null);
        } else {
            study.setProtocolNutritionist(this.authDAO.findUserById(studyDTO.getProtocolNutritionist()));
            study.setProtocolNutritionistString(null);
        }
    }

    public VisitTemplateDetailResponse getVisitTemplateData(int visitId, User user, String ipAddress) {
        this.logViewVisit(visitId, user, ipAddress);
        return this.studyDAO.getVisitDataById(visitId);
    }

    public List<StudyDataResponse> getStudiesList(String filterString, String sortBy, String orderBy, int page, int maxResults, User user) {
        if (user.isStudyStaff()) {
            return this.studyDAO.getStudyListByPerson(filterString, sortBy, orderBy, page, maxResults, user);
        }
        return this.studyDAO.getStudyList(filterString, sortBy, orderBy, page, maxResults);
    }

    public StudyDetailResponse getStudyData(int studyId, User user, String ipAddress) {
        Study s = this.studyDAO.findStudyById(studyId);
        this.stampStudyAndLogStudyActivity(ipAddress, s, user, "VIEW STUDY", null, null);
        return this.studyDAO.getStudyDataById(studyId);
    }

    public BooleanRequest changeStudySubjectStatus(int studySubject, User user, String ipAddress) {
        BooleanRequest booleanRequest = new BooleanRequest();
        StudySubject s = this.subjectDAO.findStudySubjectById(studySubject);
        if (s.getActive()) {
            s.setActive(false);
            this.studyDAO.updateEntity(s);
            this.deactivateStudySubject(user, ipAddress, s);
        } else {
            s.setActive(true);
            this.studyDAO.updateEntity(s);
            this.activateStudySubject(user, ipAddress, s);
        }
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    public List<UserDataResponse> getStudyMembersList(int studyId, String sortBy, String orderBy, int page, int maxResults) {
        Study study = this.studyDAO.findStudyById(studyId);
        return this.studyDAO.getStudyUserRolesByStudy(study, sortBy, orderBy, page, maxResults);
    }

    public BooleanRequest changeStudyMemberStatus(int studyMember, User user, String ipAddress) {
        StudyUser studyUser = this.studyDAO.findStudyUserRoleById(studyMember);
        if (studyUser.getActive()) {
            studyUser.setActive(false);
            this.studyDAO.updateEntity(studyUser);
            this.deactivateStudyMember(user, ipAddress, studyUser);
        } else {
            studyUser.setActive(true);
            this.studyDAO.updateEntity(studyUser);
            this.activateStudyMember(user, ipAddress, studyUser);
        }
        BooleanRequest booleanRequest = new BooleanRequest();
        booleanRequest.setResult(true);
        return booleanRequest;
    }

    private void deactivateStudySubject(User user, String ipAddress, StudySubject s) {
        this.manipulateStudySubject(user, ipAddress, s, "DEACTIVATE STUDY SUBJECT");
    }

    private void activateStudySubject(User user, String ipAddress, StudySubject s) {
        this.manipulateStudySubject(user, ipAddress, s, "ACTIVATE STUDY SUBJECT");
    }

    private void deactivateStudyMember(User user, String ipAddress, StudyUser s) {
        this.manipulateStudyMember(user, ipAddress, s, "DEACTIVATE STUDY SUBJECT");
    }

    private void activateStudyMember(User user, String ipAddress, StudyUser s) {
        this.manipulateStudyMember(user, ipAddress, s, "ACTIVATE STUDY SUBJECT");
    }

    private void manipulateStudySubject(User user, String ipAddress, StudySubject s, String action) {
        this.stampStudyAndLogStudySubjectActivity(user, ipAddress, s, action, StudySubject::getStudy, StudySubject::getSubject);
    }

    private void manipulateStudyMember(User user, String ipAddress, StudyUser s, String action) {
        this.stampStudyAndLogStudyMemberActivity(user, ipAddress, s, action, StudyUser::getStudy, StudyUser::getUser);
    }

    private <S> void stampStudyAndLogStudySubjectActivity(User user, String ipAddress, S s, String action, Function<S, Study> getStudy, Function<S, Subject> getSubject) {
        this.stampStudyAndLogStudySubjectActivity(ipAddress, getStudy.apply(s), getSubject.apply(s), user, action, null, null);
    }

    private <S> void stampStudyAndLogStudyMemberActivity(User user, String ipAddress, S s, String action, Function<S, Study> getStudy, Function<S, User> getUser) {
        this.stampStudyAndLogStudyMemberActivity(ipAddress, getStudy.apply(s), getUser.apply(s), user, action, null, null);
    }
}

