/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

public class MiscUtil {
    public static final int HASH_MODULUS = 200;

    public static boolean differentObjects(Object one, Object two) {
        boolean result = true;
        if (one == null && two == null) {
            result = false;
        } else if (one != null && one.equals(two)) {
            result = false;
        } else if (two != null && two.equals(one)) {
            result = false;
        }
        return result;
    }

    public static boolean differentStringsIgnoreCase(String one, String two) {
        if (one != null) {
            one = one.toUpperCase();
        }
        if (two != null) {
            two = two.toUpperCase();
        }
        return MiscUtil.differentObjects(one, two);
    }

    public static String throwableInfoForLog(Throwable t) {
        String result = " -- " + t.getClass().getSimpleName() + " -- " + t.getMessage();
        return result;
    }

    public static String throwableToStackTraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String applyCodeToXX(String input, String code) {
        String result = input;
        if (code != null) {
            result = result.replaceAll("XX", code);
        }
        return result;
    }

    public static boolean neitherNullNorEmpty(List<?> list) {
        return list != null && !list.isEmpty();
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static StringBuilder appendIfDifferentStrings(StringBuilder builder, String oldOne, String newOne, String label) {
        builder.append(label).append(": ");
        if (MiscUtil.differentStringsIgnoreCase(oldOne, newOne)) {
            builder.append(oldOne).append(" --> ").append(newOne);
        } else {
            builder.append(oldOne).append(" (no change)");
        }
        builder.append(". ");
        return builder;
    }
}

