/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.persistence;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import edu.harvard.catalyst.hccrc.core.util.ListUtils;
import edu.harvard.catalyst.scheduler.dto.SearchDTO;
import edu.harvard.catalyst.scheduler.dto.response.FundingSourceInfo;
import edu.harvard.catalyst.scheduler.dto.response.GetSearchVisitResourceResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudiesResponse;
import edu.harvard.catalyst.scheduler.dto.response.GetStudyVisitsResponse;
import edu.harvard.catalyst.scheduler.dto.response.ResourceTimeBoundsAndCountResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.StudyDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.StudyDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.TemplateResourceWithTraListDTO;
import edu.harvard.catalyst.scheduler.dto.response.UserDataResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitApprovalModelResponseDTO;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplateDetailResponse;
import edu.harvard.catalyst.scheduler.dto.response.VisitTemplatesResponse;
import edu.harvard.catalyst.scheduler.entity.ActivityLog;
import edu.harvard.catalyst.scheduler.entity.AppointmentOverrideReason;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatus;
import edu.harvard.catalyst.scheduler.entity.AppointmentStatusReason;
import edu.harvard.catalyst.scheduler.entity.BaseEntity;
import edu.harvard.catalyst.scheduler.entity.BookedResource;
import edu.harvard.catalyst.scheduler.entity.BookedVisit;
import edu.harvard.catalyst.scheduler.entity.CancellationStatus;
import edu.harvard.catalyst.scheduler.entity.CentersAndInstitutions;
import edu.harvard.catalyst.scheduler.entity.Comments;
import edu.harvard.catalyst.scheduler.entity.FundingSource;
import edu.harvard.catalyst.scheduler.entity.Gender;
import edu.harvard.catalyst.scheduler.entity.IRBInstitution;
import edu.harvard.catalyst.scheduler.entity.Institution;
import edu.harvard.catalyst.scheduler.entity.InstitutionRole;
import edu.harvard.catalyst.scheduler.entity.InstitutionRoleType;
import edu.harvard.catalyst.scheduler.entity.Resource;
import edu.harvard.catalyst.scheduler.entity.ResourceSublocation;
import edu.harvard.catalyst.scheduler.entity.ResourceType;
import edu.harvard.catalyst.scheduler.entity.Role;
import edu.harvard.catalyst.scheduler.entity.Study;
import edu.harvard.catalyst.scheduler.entity.StudyStatus;
import edu.harvard.catalyst.scheduler.entity.StudySubject;
import edu.harvard.catalyst.scheduler.entity.StudyUser;
import edu.harvard.catalyst.scheduler.entity.Subject;
import edu.harvard.catalyst.scheduler.entity.SubjectMrn;
import edu.harvard.catalyst.scheduler.entity.Sublocation;
import edu.harvard.catalyst.scheduler.entity.TemplateApprovalHistory;
import edu.harvard.catalyst.scheduler.entity.TemplateResource;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceAnnotations;
import edu.harvard.catalyst.scheduler.entity.TemplateResourceGroup;
import edu.harvard.catalyst.scheduler.entity.User;
import edu.harvard.catalyst.scheduler.entity.VisitTemplate;
import edu.harvard.catalyst.scheduler.entity.VisitType;
import edu.harvard.catalyst.scheduler.persistence.HqlClauses;
import edu.harvard.catalyst.scheduler.persistence.SiteDAO;
import edu.harvard.catalyst.scheduler.util.SubjectDataEncryptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class StudyDAO
extends SiteDAO {
    private static final Integer CHECKOUT_ID = 3;
    private static final Integer CANCEL_ID = 4;

    public List<VisitType> getVisitTypes() {
        return Arrays.asList(VisitType.values());
    }

    public List<Role> getRoles() {
        return this.findAll(Role.class);
    }

    public List<InstitutionRole> getInstitutionRoles() {
        return this.findAll(InstitutionRole.class);
    }

    public List<StudyStatus> getStudyStatuses() {
        return this.findAll(StudyStatus.class);
    }

    public List<AppointmentOverrideReason> getOverrideReasons() {
        return this.findAll(AppointmentOverrideReason.class);
    }

    public List<AppointmentStatusReason> getCheckOutReasons() {
        AppointmentStatus checkOutStatus = this.findAppointmentStatusById(CHECKOUT_ID);
        return this.findAppointmentStatusReasonByStatus(checkOutStatus);
    }

    public List<AppointmentStatusReason> findAppointmentStatusReasonByStatus(AppointmentStatus appointmentStatus) {
        Criteria crit = this.newCriteria(AppointmentStatusReason.class);
        crit.add((Criterion)Restrictions.eq((String)"appointmentStatus", (Object)appointmentStatus));
        crit.addOrder(Order.asc((String)"name"));
        return crit.list();
    }

    public List<AppointmentStatusReason> getCancellationReasons() {
        AppointmentStatus cancelStatus = this.findAppointmentStatusById(CANCEL_ID);
        return this.findAppointmentStatusReasonByStatus(cancelStatus);
    }

    public List<AppointmentStatus> getAppointmentStatuses() {
        return this.findAll(AppointmentStatus.class);
    }

    public List<CancellationStatus> getVisitCancelStatuses() {
        Criteria crit = this.newCriteria(CancellationStatus.class);
        return crit.list();
    }

    public List<IRBInstitution> getIRBInstitutions() {
        return this.findAll(IRBInstitution.class);
    }

    public List<Study> getStudies() {
        return this.findAll(Study.class);
    }

    public GetStudiesResponse getNonClosedStudies() {
        String findStudy = "Select a from Study a WHERE a.studyStatus in (1,2) ";
        Query query = this.newQuery("Select a from Study a WHERE a.studyStatus in (1,2) ");
        List resultList = query.list();
        long total = resultList.size();
        return GetStudiesResponse.createGetStudiesResponse(resultList, total);
    }

    public GetStudiesResponse findSubjectStudyListByPerson(User studyPerson) {
        Query query = this.newQuery("select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and s.studyStatus != 3");
        query.setParameter("user", (Object)studyPerson);
        List resultList = query.list();
        long total = resultList.size();
        return GetStudiesResponse.createGetStudiesResponse(resultList, total);
    }

    public List<Study> findStudyListByPerson(User studyPerson) {
        String hql = "select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and s.studyStatus != 3";
        Query query = this.newQuery("select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and s.studyStatus != 3").setParameter("user", (Object)studyPerson);
        return query.list();
    }

    public boolean isStudyByPersonAndStudy(User studyPerson, Study study) {
        String hql = "select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.study= :study and su.active=true";
        Query query = this.newQuery("select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.study= :study and su.active=true").setParameter("user", (Object)studyPerson).setParameter("study", (Object)study);
        List studyList = query.list();
        return !studyList.isEmpty();
    }

    public List<Study> findStudyListByPersonAndLocalID(User user, String localId) {
        String studyStaffSuffix = user.isStudyStaff() ? " and su.user = :user " : "";
        String findStudy = "select distinct s from Study s, StudyUser su where s.id = su.study and su.active=true and lower(s.localId) LIKE :localId" + studyStaffSuffix;
        Query query = this.newQuery(findStudy).setParameter("localId", (Object)("%" + localId.toLowerCase() + "%"));
        if (user.isStudyStaff()) {
            query.setParameter("user", (Object)user);
        }
        return query.list();
    }

    public List<Study> findStudyStaffFilterStudyListByPI(User studyPerson, String filterString) {
        String hql = "select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and lower(s.investigator.lastName) = :filterString";
        Query query = this.newQuery("select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and lower(s.investigator.lastName) = :filterString").setParameter("user", (Object)studyPerson).setParameter("filterString", (Object)filterString.toLowerCase());
        return query.list();
    }

    public List<Study> getStudyStaffFilterStudiesByLocalId(User studyPerson, String filterString) {
        String hql = "select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and lower(s.localId) = :localId";
        Query query = this.newQuery("select distinct s from Study s, StudyUser su where s.id = su.study and su.user = :user and su.active=true and lower(s.localId) = :localId").setParameter("user", (Object)studyPerson).setParameter("localId", (Object)filterString.toLowerCase());
        return query.list();
    }

    public boolean ifBookedVisitsHaveVisit(VisitTemplate visit) {
        String hql = "select bv from BookedVisit bv where bv.visitTemplate = :visit";
        Query query = this.newQuery("select bv from BookedVisit bv where bv.visitTemplate = :visit").setParameter("visit", (Object)visit);
        List bv = query.list();
        return !bv.isEmpty();
    }

    public List<Study> findStudyByName(String study) {
        Criteria crit = this.newCriteria(Study.class);
        crit.add((Criterion)Restrictions.like((String)"localId", (String)study, (MatchMode)MatchMode.ANYWHERE));
        return crit.list();
    }

    public Study findStudyDataById(int id) {
        String hql = "select s, min(bv.scheduledStartTime), max(bv.scheduledStartTime) from BookedVisit bv right outer join bv.study s where s.id =:id";
        Query query = this.newQuery("select s, min(bv.scheduledStartTime), max(bv.scheduledStartTime) from BookedVisit bv right outer join bv.study s where s.id =:id").setParameter("id", (Object)id);
        Object[] resultRows = (Object[])query.uniqueResult();
        Study study = (Study)resultRows[0];
        Date firstVisitDate = (Date)resultRows[1];
        Date lastVisitDate = (Date)resultRows[2];
        study.setFirstVisitDate(firstVisitDate);
        study.setLastScheduledVisitDate(lastVisitDate);
        return study;
    }

    public User findByStudyMemberId(Integer id) {
        return this.findById(User.class, id);
    }

    public Gender findGenderById(Integer id) {
        return this.findById(Gender.class, id);
    }

    public StudySubject findStudySubjectById(Integer id) {
        return this.findById(StudySubject.class, id);
    }

    public Role findRoleById(int id) {
        return this.findById(Role.class, id);
    }

    public IRBInstitution findIRBInstitutionById(int id) {
        return this.findById(IRBInstitution.class, id);
    }

    public StudyUser findStudyUserRoleById(int id) {
        return this.findById(StudyUser.class, id);
    }

    public FundingSource findFundingSourceById(int id) {
        return this.findById(FundingSource.class, id);
    }

    public CentersAndInstitutions findCentersAndInstitutionsById(int id) {
        return this.findById(CentersAndInstitutions.class, id);
    }

    public StudyStatus findStudyStatusById(Integer id) {
        return this.findById(StudyStatus.class, id);
    }

    public InstitutionRole findInstitutionRoleByType(InstitutionRoleType type) {
        Criteria criteria = this.newCriteria(InstitutionRole.class).add((Criterion)Restrictions.eq((String)"type", (Object)type));
        return (InstitutionRole)criteria.uniqueResult();
    }

    public Institution findByInstitutionId(Integer id) {
        return this.findById(Institution.class, id);
    }

    public Study findStudyById(int id) {
        return this.findById(Study.class, id);
    }

    public VisitTemplate findVisitById(int id) {
        return this.findById(VisitTemplate.class, id);
    }

    public VisitTemplateDetailResponse getVisitDataById(int id) {
        VisitTemplate visit = this.findVisitById(id);
        return new VisitTemplateDetailResponse(visit);
    }

    public StudyDetailResponse getStudyDataById(int id) {
        Study study = this.findStudyDataById(id);
        List<FundingSourceInfo> studyFundingSourceInfoList = this.getFundingSourceInfoList(id);
        return new StudyDetailResponse(study, studyFundingSourceInfoList);
    }

    public List<TemplateResource> findTemplateResourcesByVisitAndResource(Integer visitTemplate, Integer rId) {
        String hql = "select tr from TemplateResource tr where tr.visitTemplate.id = :visitTemplate and tr.resource.id = :rId";
        Query query = this.newQuery("select tr from TemplateResource tr where tr.visitTemplate.id = :visitTemplate and tr.resource.id = :rId").setParameter("visitTemplate", (Object)visitTemplate).setParameter("rId", (Object)rId);
        List result = query.list();
        return result;
    }

    private StudyFundingSourceRow arrayToStudyFundingSourceRow(Object[] resultRow) {
        String name = (String)resultRow[1];
        Integer sfsId = (Integer)resultRow[10];
        Optional<CentersAndInstitutions> centerAndInstitution = Optional.ofNullable(name).filter("Federal PHS"::equalsIgnoreCase).flatMap(n2 -> Optional.ofNullable(this.getCenterAndInstitution(sfsId)));
        return new StudyFundingSourceRow((Integer)resultRow[0], name, (String)resultRow[2], (Integer)resultRow[3], (String)resultRow[4], (String)resultRow[5], (Double)resultRow[6], (Double)resultRow[7], (Date)resultRow[8], (Date)resultRow[9], centerAndInstitution);
    }

    List<FundingSourceInfo> getFundingSourceInfoList(int studyId) {
        String hql = "select fs.id,        fs.name,        sfs.comment,        sfs.oneToFour,        sfs.grantId,        sfs.siteCostCenter,        sfs.totalDirectAward,        sfs.totalIndirectAward,        sfs.projectStartDate,        sfs.projectEndDate,        sfs.id   from StudyFundingSource sfs, FundingSource fs  where sfs.studyId = :id    and fs.id = sfs.fundingSource.id ";
        Query query = this.newQuery("select fs.id,        fs.name,        sfs.comment,        sfs.oneToFour,        sfs.grantId,        sfs.siteCostCenter,        sfs.totalDirectAward,        sfs.totalIndirectAward,        sfs.projectStartDate,        sfs.projectEndDate,        sfs.id   from StudyFundingSource sfs, FundingSource fs  where sfs.studyId = :id    and fs.id = sfs.fundingSource.id ").setParameter("id", (Object)studyId);
        List resultSet = query.list();
        return ListUtils.enrich((List)resultSet).map(this::arrayToStudyFundingSourceRow).map(StudyFundingSourceRow::toFundingSourceInfo).toList();
    }

    CentersAndInstitutions getCenterAndInstitution(int sfsId) {
        String hql = "select sfs.centersAndInstitutions   from StudyFundingSource sfs  where sfs.id = :id ";
        Query query = this.newQuery("select sfs.centersAndInstitutions   from StudyFundingSource sfs  where sfs.id = :id ").setParameter("id", (Object)sfsId);
        return (CentersAndInstitutions)query.uniqueResult();
    }

    public VisitType findVisitTypeById(int id) {
        return VisitType.findById(id).orElse(null);
    }

    public VisitTemplate findVisitTemplateById(int id) {
        return this.findById(VisitTemplate.class, id);
    }

    public Sublocation findSubLocationById(int id) {
        return this.findById(Sublocation.class, id);
    }

    public ResourceSublocation findSublocationByResource(Resource r) {
        Criteria crit = this.newCriteria(ResourceSublocation.class).add((Criterion)Restrictions.eq((String)"resource", (Object)r));
        return (ResourceSublocation)crit.uniqueResult();
    }

    public List<StudySubject> findStudySubjectBySubjectListAndStudyList(List<Subject> subjectList, List<Study> studyList) {
        Criteria crit = this.newCriteria(StudySubject.class);
        if (subjectList != null) {
            crit.add(Restrictions.in((String)"subject", subjectList));
        }
        if (studyList != null) {
            crit.add(Restrictions.in((String)"study", studyList));
        }
        return crit.list();
    }

    public List<FundingSource> getFundingSources() {
        return this.findAll(FundingSource.class);
    }

    public List<VisitTemplatesResponse> getNotApprovedVisits(String sortBy, String orderBy, int page, int maxResults) {
        Object[] columnsArray = new String[]{"user.last_name", "user.first_name", "visit_template.id", "visit_template.name", "visit_template.approved", "visit_template.type", "visit_template.last_update_time", "sublocation.name", "study.local_id", "study.id"};
        String columnSqlList = Joiner.on((String)", ").join(columnsArray);
        String findVisitsSql = "SELECT " + columnSqlList + " " + "FROM " + "visit_template, " + "sublocation, " + "study LEFT OUTER JOIN user ON user.id = study.principal_investigator " + "WHERE " + "visit_template.study = study.id and " + "visit_template.sublocation = sublocation.id and " + "visit_template.approved = false and visit_template.active = true " + "order by " + sortBy + " " + orderBy;
        int offset = (page - 1) * maxResults;
        SQLQuery query = this.newSqlQuery(findVisitsSql);
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        for (Object column : columnsArray) {
            query.addScalar((String)column);
        }
        List resultRows = query.list();
        Long total = this.findNotApprovedVisitTemplateCount();
        return ListUtils.enrich((List)resultRows).map(VisitTemplateRow::fromArray).map(row -> row.toVisitTemplatesResponse(total)).toList();
    }

    Long findNotApprovedVisitTemplateCount() {
        String findCount = "SELECT count(v) from VisitTemplate v WHERE v.approved = false and v.active = true";
        Query query = this.newQuery("SELECT count(v) from VisitTemplate v WHERE v.approved = false and v.active = true");
        return (Long)query.uniqueResult();
    }

    public List<StudyUser> findStudyUserRolesByStudy(Study study) {
        String findStudyUsers = "SELECT su from StudyUser su WHERE su.study = :study and su.active = true";
        Query query = this.newQuery("SELECT su from StudyUser su WHERE su.study = :study and su.active = true").setParameter("study", (Object)study);
        return query.list();
    }

    public List<TemplateResource> getTemplateResourcesUsedOnDay(int vtId, Date selectedDateStartOfDay, Date nextDateStartOfDay) {
        String hql = "SELECT tr FROM TemplateResource tr  INNER JOIN tr.visitTemplate vt WHERE vt.id = :vtId AND (tr.startDate >= :selectedDateStartOfDay)AND (tr.endDate < :nextDateStartOfDay)";
        Query hqlQuery = this.newQuery("SELECT tr FROM TemplateResource tr  INNER JOIN tr.visitTemplate vt WHERE vt.id = :vtId AND (tr.startDate >= :selectedDateStartOfDay)AND (tr.endDate < :nextDateStartOfDay)").setParameter("vtId", (Object)vtId).setParameter("selectedDateStartOfDay", (Object)selectedDateStartOfDay).setParameter("nextDateStartOfDay", (Object)nextDateStartOfDay);
        List templateResourceList = hqlQuery.list();
        return templateResourceList;
    }

    public List<TemplateResource> findTemplateResourcesByVisit(VisitTemplate visit) {
        return this.findTemplateResourcesByVisit(visit, "");
    }

    public List<TemplateResource> findTemplateResourcesByVisitAndBillable(VisitTemplate visit, boolean isBillable, String sortBy, String orderBy, int page, int maxResults) {
        String sortExpression = " order by " + sortBy + " " + orderBy;
        String queryString = "select tr from TemplateResource tr where tr.visitTemplate = :visit and tr.billable = :isBillable " + sortExpression;
        Query query = this.newQuery(queryString);
        query.setParameter("visit", (Object)visit);
        query.setParameter("isBillable", (Object)isBillable);
        List templateResourceList = query.list();
        return templateResourceList;
    }

    public List<TemplateResource> findTemplateResourcesByVisit(VisitTemplate visit, String sortExpression) {
        String queryString = "select tr from TemplateResource tr where tr.visitTemplate = :visit " + sortExpression;
        Query query = this.newQuery(queryString).setParameter("visit", (Object)visit);
        List templateResourceList = query.list();
        return templateResourceList;
    }

    public List<TemplateResourceWithTraListDTO> findTemplateResourcesAndAnnotationsByVisit(Integer visitId, String sortExpression) {
        String queryString = "select tr, tra from TemplateResourceAnnotations tra right join tra.templateResource tr where tr.visitTemplate.id = :visitId " + sortExpression;
        Query query = this.newQuery(queryString).setParameter("visitId", (Object)visitId);
        List queryResultRowList = query.list();
        HashMap dtoMap = Maps.newHashMap();
        ArrayList resultList = Lists.newArrayList();
        for (Object[] queryResultRow : queryResultRowList) {
            TemplateResource tr = (TemplateResource)queryResultRow[0];
            TemplateResourceAnnotations tra = (TemplateResourceAnnotations)queryResultRow[1];
            TemplateResourceWithTraListDTO associatedTrwalDto = (TemplateResourceWithTraListDTO)dtoMap.get(tr);
            if (associatedTrwalDto == null) {
                associatedTrwalDto = new TemplateResourceWithTraListDTO(tr);
                dtoMap.put(tr, associatedTrwalDto);
                resultList.add(associatedTrwalDto);
            }
            TemplateResourceWithTraListDTO trwalDto = (TemplateResourceWithTraListDTO)dtoMap.get(tr);
            if (tra == null) continue;
            trwalDto.getTraList().add(tra);
        }
        return resultList;
    }

    public GetSearchVisitResourceResponse findTemplateResourcesByVisit(Integer visitId, String sortByParam, String orderBy, Integer page, Integer maxResults) {
        String sortBy = sortByParam.equalsIgnoreCase("tr.startDate") ? " tr.startDate " + orderBy + ", tr.endDate " : (sortByParam.equalsIgnoreCase("tr.endDate") ? " tr.endDate " + orderBy + ", tr.startDate " : sortByParam);
        VisitTemplate visitTemplate = this.findVisitById(visitId);
        String whereClause = HqlClauses.whereBuilder().equalTo(Optional.of("r.id"), "tr.resource").equalTo(Optional.of(":vt"), "tr.visitTemplate").build();
        String simpleHql = "select tr from TemplateResource tr, Resource r " + whereClause + " order by " + sortBy + " " + orderBy;
        Query mainQuery = this.newQuery(simpleHql).setParameter("vt", (Object)visitTemplate);
        long total = mainQuery.list().size();
        int offset = (page - 1) * maxResults;
        mainQuery.setFirstResult(offset);
        mainQuery.setMaxResults(maxResults.intValue());
        List resultRows = mainQuery.list();
        return GetSearchVisitResourceResponse.createGetSearchVisitsResponse(resultRows, total);
    }

    public List<Comments> findVisitTemplateCommentsByVisit(VisitTemplate visit) {
        Criteria criteria = this.newCriteria(Comments.class).add((Criterion)Restrictions.eq((String)"visitTemplate", (Object)visit));
        return criteria.list();
    }

    public Long findNumVisitTemplateCommentsByVisit(int visitId) {
        String findCount = "SELECT count(c) from Comments c WHERE c.visitTemplate.id = :visitId ";
        Query query = this.newQuery("SELECT count(c) from Comments c WHERE c.visitTemplate.id = :visitId ");
        query.setParameter("visitId", (Object)visitId);
        return (Long)query.uniqueResult();
    }

    public List<TemplateResourceAnnotations> findTemplateResourceAnnotationsByTemplateResource(TemplateResource tr) {
        Criteria criteria = this.newCriteria(TemplateResourceAnnotations.class).add((Criterion)Restrictions.eq((String)"templateResource", (Object)tr));
        return criteria.list();
    }

    public TemplateResource findTemplateResourceLowest(VisitTemplate visitTemplate) {
        String findTemplateResource = "SELECT a FROM TemplateResource a WHERE  a.visitTemplate = :visitTemplate order by a.startDate ASC";
        Query query = this.newQuery("SELECT a FROM TemplateResource a WHERE  a.visitTemplate = :visitTemplate order by a.startDate ASC").setParameter("visitTemplate", (Object)visitTemplate).setFirstResult(0).setMaxResults(1);
        List brs = query.list();
        return (TemplateResource)brs.get(0);
    }

    public BookedResource findBookedResourceLowest(BookedVisit bookedVisit) {
        String findTemplateResource = "SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime ASC";
        Query query = this.newQuery("SELECT a FROM BookedResource a WHERE  a.bookedVisit = :bookedVisit order by a.scheduledStartTime ASC").setParameter("bookedVisit", (Object)bookedVisit).setFirstResult(0).setMaxResults(1);
        List brs = query.list();
        return (BookedResource)brs.get(0);
    }

    public ResourceTimeBoundsAndCountResponseDTO findTemplateResourceCountEarliestLatest(int visitTemplate) {
        String findTemplateResource = "SELECT min(startDate), max(endDate), count(id) FROM TemplateResource a WHERE a.visitTemplate.id = :visitTemplate";
        Query query = this.newQuery("SELECT min(startDate), max(endDate), count(id) FROM TemplateResource a WHERE a.visitTemplate.id = :visitTemplate").setParameter("visitTemplate", (Object)visitTemplate);
        List resultRows = query.list();
        Object[] row0 = (Object[])resultRows.get(0);
        Date earliestStartDate = (Date)row0[0];
        Date latestEndDate = (Date)row0[1];
        Long count = (Long)row0[2];
        return ResourceTimeBoundsAndCountResponseDTO.fromTriple(count, earliestStartDate, latestEndDate);
    }

    public List<TemplateResource> findRoomTemplateResourcesByVisit(VisitTemplate visitTemplate) {
        String findTemplateResource = "SELECT tr FROM TemplateResource tr, Resource r WHERE  tr.visitTemplate = :visitTemplate and tr.resource = r.id and r.resourceType = :resourceType";
        Query query = this.newQuery("SELECT tr FROM TemplateResource tr, Resource r WHERE  tr.visitTemplate = :visitTemplate and tr.resource = r.id and r.resourceType = :resourceType").setParameter("visitTemplate", (Object)visitTemplate).setParameter("resourceType", (Object)ResourceType.Room);
        return query.list();
    }

    public List<TemplateResource> findFixedTemplateResourcesByVisit(VisitTemplate visit) {
        Criteria criteria = this.newCriteria(TemplateResource.class);
        criteria.add((Criterion)Restrictions.eq((String)"visitTemplate", (Object)visit));
        criteria.add(Restrictions.isNull((String)"groupId"));
        criteria.add((Criterion)Restrictions.eq((String)"floatable", (Object)Boolean.FALSE));
        return criteria.list();
    }

    public List<TemplateResource> findUngroupedTemplateResourcesTypeByVisit(VisitTemplate visit, String templateResourceType) {
        Criteria criteria = this.newCriteria(TemplateResource.class);
        criteria.add((Criterion)Restrictions.eq((String)"visitTemplate", (Object)visit));
        criteria.add(Restrictions.isNull((String)"groupId"));
        criteria.add((Criterion)Restrictions.eq((String)templateResourceType, (Object)Boolean.TRUE));
        return criteria.list();
    }

    public List<VisitApprovalModelResponseDTO.VisitApproval> getVisitApprovals(int id, String sortBy, String orderBy, int page, int maxResults) {
        String hql = "select v, u, tah from VisitTemplate v, User u, TemplateApprovalHistory tah where v.id =:id and v.id = tah.visitTemplate and u.id = tah.user  order by " + sortBy + " " + orderBy;
        int offset = (page - 1) * maxResults;
        Query query = this.newQuery(hql).setParameter("id", (Object)id).setFirstResult(offset).setMaxResults(maxResults);
        List resultRows = query.list();
        Function<Object[], TemplateApprovalHistory> toTemplateApprovalHistory = resultRow -> {
            VisitTemplate visitTemplate = (VisitTemplate)resultRow[0];
            User user = (User)resultRow[1];
            TemplateApprovalHistory tah = (TemplateApprovalHistory)resultRow[2];
            tah.setUserLastName(user.getLastName());
            tah.setUserFirstName(user.getFirstName());
            tah.setUserRole(user.getRole().getName());
            tah.setUserTitle(user.getInstitutionRole().getName());
            tah.setVisitCreatedDate(visitTemplate.getCreatedDate());
            return tah;
        };
        List tahList = ListUtils.enrich((List)resultRows).map(toTemplateApprovalHistory).toList();
        Long total = this.findTemplateApprovalCount(id);
        return VisitApprovalModelResponseDTO.fromTemplateApprovalHistoryList(tahList, total);
    }

    Long findTemplateApprovalCount(int id) {
        String findCount = "select v, u, tah from VisitTemplate v, User u, TemplateApprovalHistory tah where v.id =:id and v.id = tah.visitTemplate and u.id = tah.user ";
        Query query = this.newQuery("select v, u, tah from VisitTemplate v, User u, TemplateApprovalHistory tah where v.id =:id and v.id = tah.visitTemplate and u.id = tah.user ").setParameter("id", (Object)id);
        return query.list().size();
    }

    public List<TemplateApprovalHistory> findTemplateApprovalHistoryByVisit(VisitTemplate visit) {
        Criteria criteria = this.newCriteria(TemplateApprovalHistory.class).add((Criterion)Restrictions.eq((String)"visitTemplate", (Object)visit));
        return criteria.list();
    }

    public List<ActivityLog> findActivityLogByVisit(VisitTemplate visitTemplate) {
        Criteria criteria = this.newCriteria(ActivityLog.class).add((Criterion)Restrictions.eq((String)"affectedVisit", (Object)visitTemplate));
        return criteria.list();
    }

    public List<TemplateResourceGroup> findTemplateResourceGroupByVisitAndTemplate(VisitTemplate visit, TemplateResource templateResource) {
        Criteria criteria = this.newCriteria(TemplateResourceGroup.class);
        criteria.add((Criterion)Restrictions.eq((String)"templateResource", (Object)templateResource));
        criteria.add((Criterion)Restrictions.eq((String)"visit", (Object)visit));
        return criteria.list();
    }

    public TemplateApprovalHistory findTemplateApprovalHistoryByVisitAndUser(VisitTemplate visit, User user) {
        Criteria criteria = this.newCriteria(TemplateApprovalHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)"visitTemplate", (Object)visit));
        criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
        return (TemplateApprovalHistory)criteria.uniqueResult();
    }

    public List<TemplateApprovalHistory> findTemplateApprovalHistoryListByVisitAndUser(VisitTemplate visit, User user) {
        Criteria criteria = this.newCriteria(TemplateApprovalHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)"visitTemplate", (Object)visit));
        criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
        criteria.add((Criterion)Restrictions.eq((String)"approved", (Object)Boolean.FALSE));
        return criteria.list();
    }

    public List<TemplateApprovalHistory> findTemplateApprovalHistoryListByUser(User user) {
        Criteria criteria = this.newCriteria(TemplateApprovalHistory.class);
        criteria.add((Criterion)Restrictions.eq((String)"user", (Object)user));
        criteria.add((Criterion)Restrictions.eq((String)"approved", (Object)Boolean.TRUE));
        return criteria.list();
    }

    public AppointmentStatus findAppointmentStatusById(Integer id) {
        return this.findById(AppointmentStatus.class, id);
    }

    public boolean checkLocalId(String localid) {
        Criteria crit = this.newCriteria(Study.class).add((Criterion)Restrictions.eq((String)"localId", (Object)localid));
        Study localId = (Study)crit.uniqueResult();
        return localId == null;
    }

    public List<Study> findStudyBySchduler(User user) {
        Criteria criteria = this.newCriteria(Study.class).add((Criterion)Restrictions.eq((String)"scheduler", (Object)user));
        return criteria.list();
    }

    public List<Study> findStudyByPI(User user) {
        Criteria criteria = this.newCriteria(Study.class).add((Criterion)Restrictions.eq((String)"investigator", (Object)user));
        return criteria.list();
    }

    public List<Study> findStudyByNurse(User user) {
        Criteria criteria = this.newCriteria(Study.class).add((Criterion)Restrictions.eq((String)"protocolNurse", (Object)user));
        return criteria.list();
    }

    public List<Study> findStudyByNutritionist(User user) {
        Criteria criteria = this.newCriteria(Study.class).add((Criterion)Restrictions.eq((String)"protocolNutritionist", (Object)user));
        return criteria.list();
    }

    public List<VisitTemplate> findVisitTemplateByStudy(Study study) {
        Criteria criteria = this.newCriteria(VisitTemplate.class);
        criteria.add((Criterion)Restrictions.eq((String)"study", (Object)study));
        criteria.add((Criterion)Restrictions.eq((String)"approved", (Object)Boolean.FALSE));
        return criteria.list();
    }

    String flipOrderByForVisitDotApproved(String sortBy, String orderBy) {
        String result = orderBy;
        if (sortBy.equals("v.approved")) {
            result = orderBy.equals("DESC") ? "ASC" : "DESC";
        }
        return result;
    }

    public List<VisitTemplatesResponse> getStudyVisitsByStatus(int study, boolean active, String sortBy, String orderBy, int page, int maxResults, SearchDTO searchDTO) {
        String searchClause = SearchDTO.toSearchClause(searchDTO.getSearchItems(), key -> key);
        String possiblyAdjustedOrderBy = this.flipOrderByForVisitDotApproved(sortBy, orderBy);
        String findVisits = "SELECT v from VisitTemplate v, Study s WHERE v.study = s.id and s.id =:study and v.active = :active " + searchClause + " ORDER BY " + sortBy + " " + possiblyAdjustedOrderBy;
        int offset = (page - 1) * maxResults;
        Query query = this.newQuery(findVisits).setParameter("study", (Object)study).setParameter("active", (Object)active).setFirstResult(offset).setMaxResults(maxResults);
        List resultRows = query.list();
        Long total = this.findVisitTemplateCount(study, active);
        return ListUtils.enrich((List)resultRows).map(visitTemplate -> this.setVisitTemplateData(total, (VisitTemplate)visitTemplate)).toList();
    }

    public VisitTemplatesResponse setVisitTemplateData(long total, VisitTemplate visitTemplate) {
        String piName = this.getPiName(visitTemplate);
        return new VisitTemplatesResponse(visitTemplate.getId(), visitTemplate.getStudy().getId(), visitTemplate.getName(), visitTemplate.getVisitType().getName(), visitTemplate.getSublocation().getName(), visitTemplate.getApprovedString(), total, visitTemplate.getStudy().getLocalId(), visitTemplate.getLastUpdateTime(), piName);
    }

    private String getPiName(VisitTemplate visitTemplate) {
        if (visitTemplate.getStudy().getInvestigator() != null) {
            return visitTemplate.getStudy().getInvestigator().getLastName() + " " + visitTemplate.getStudy().getInvestigator().getFirstName();
        }
        return " ";
    }

    Long findVisitTemplateCount(int study, boolean active) {
        String findCount = "SELECT count(v) from VisitTemplate v, Study s WHERE v.study = s.id and s.id = :study and v.active = :active";
        Query query = this.newQuery("SELECT count(v) from VisitTemplate v, Study s WHERE v.study = s.id and s.id = :study and v.active = :active").setParameter("study", (Object)study).setParameter("active", (Object)active);
        return (Long)query.uniqueResult();
    }

    public List<StudyDataResponse> getStudyListByPerson(String filterString, String sortBy, String orderBy, int page, int maxResults, User studyPerson, List<SearchDTO.SearchItem> searchItems) {
        return this.getStudyList(filterString, sortBy, orderBy, page, maxResults, "study_user su, ", " s.id = su.study and su.user = :user and su.active=true and ", studyPerson, searchItems);
    }

    public List<StudyDataResponse> getStudyList(String filterString, String sortBy, String orderBy, int page, int maxResults, List<SearchDTO.SearchItem> searchItems) {
        return this.getStudyList(filterString, sortBy, orderBy, page, maxResults, "", "", null, searchItems);
    }

    public List<StudyDataResponse> getStudyList(String filterString, String sortBy, String orderBy, int page, int maxResults, String fromStudyUser, String whereStudyUser, User studyUser, List<SearchDTO.SearchItem> searchItems) {
        boolean filterStringIsPresent;
        StringBuffer findStudySql = new StringBuffer();
        findStudySql.append("select s.id, s.irb, s.local_id, s.name, ss.short_name, pi.first_name, pi.last_name  from study_status ss, " + fromStudyUser);
        findStudySql.append(" study s left outer join user pi on pi.id = s.principal_investigator  where " + whereStudyUser);
        boolean bl = filterStringIsPresent = !Strings.isNullOrEmpty((String)filterString);
        if (filterStringIsPresent) {
            findStudySql.append(" (lower(pi.last_name) LIKE :filterString or lower(s.local_id) LIKE :filterString)  and ");
        }
        String totalSearchClause = "";
        if (searchItems != null && !searchItems.isEmpty()) {
            totalSearchClause = SearchDTO.toSearchClause(searchItems, key -> key);
        }
        findStudySql.append(" ss.id = s.study_status" + totalSearchClause + " order by " + sortBy + " " + orderBy);
        SQLQuery query = this.newSqlQuery(findStudySql.toString());
        if (filterStringIsPresent) {
            query.setParameter("filterString", (Object)("%" + filterString.toLowerCase() + "%"));
        }
        if (studyUser != null) {
            query.setParameter("user", (Object)studyUser.getId());
        }
        List countIds = query.list();
        Long total = countIds.size();
        int offset = (page - 1) * maxResults;
        query.setFirstResult(offset);
        query.setMaxResults(maxResults);
        List resultRowList = query.list();
        Function<Object[], StudyDataResponse> toStudyDataResponse = resultRow -> new StudyDataResponse(total, (Integer)resultRow[0], (String)resultRow[1], (String)resultRow[2], (String)resultRow[3], (String)resultRow[4], (String)resultRow[5], (String)resultRow[6]);
        return ListUtils.enrich((List)resultRowList).map(toStudyDataResponse).toList();
    }

    public GetStudiesResponse findOpenStudyListByPerson(User studyPerson, String filterString, String sortBy, String orderBy, int page, int maxResults) {
        String queryString = "select distinct s from Study s, StudyUser su, VisitTemplate v where s.id = su.study and s.id = v.study and v.approved = true and su.user = :user and su.active=true and s.studyStatus =2 ";
        queryString = this.addFilterAndOrder(filterString, sortBy, orderBy, queryString);
        Query mainQuery = this.newQuery(queryString).setParameter("user", (Object)studyPerson);
        return this.getStudies(page, maxResults, mainQuery);
    }

    public GetStudiesResponse getOpenStudies(String filterString, String sortBy, String orderBy, int page, int maxResults) {
        String queryString = "select distinct s from Study s, VisitTemplate v where v.study = s.id and s.studyStatus = 2 and v.approved = true ";
        queryString = this.addFilterAndOrder(filterString, sortBy, orderBy, queryString);
        Query mainQuery = this.newQuery(queryString);
        return this.getStudies(page, maxResults, mainQuery);
    }

    String addFilterAndOrder(String filterString, String sortBy, String orderBy, String queryString) {
        if (!Strings.isNullOrEmpty((String)filterString)) {
            queryString = queryString + " and (lower(s.localId) LIKE '%" + filterString + "%' or lower(s.name) LIKE '%" + filterString + "%') ";
        }
        queryString = queryString + " order by " + sortBy + " " + orderBy;
        return queryString;
    }

    private GetStudiesResponse getStudies(int page, int maxResults, Query mainQuery) {
        long total = mainQuery.list().size();
        int offset = (page - 1) * maxResults;
        mainQuery.setFirstResult(offset);
        mainQuery.setMaxResults(maxResults);
        List resultRows = mainQuery.list();
        return GetStudiesResponse.createGetStudiesResponse(resultRows, total);
    }

    public GetStudyVisitsResponse getStudyVisits(String filterString, String ofSortBy, String ofOrderBy, Integer ofPage, Integer ofMaxResults, Integer studyId, Boolean ofApproved) {
        Study study = this.findStudyById(studyId);
        HqlClauses.WhereBuilder whereClause = HqlClauses.whereBuilder();
        whereClause.equalTo(Optional.of("v.study"), ":sid");
        if (ofApproved.booleanValue()) {
            whereClause.equalTo(Optional.of("true"), "v.active").equalTo(Optional.of("true"), "v.approved");
        }
        if (filterString != null && !filterString.isEmpty()) {
            whereClause.like(Optional.of(":filterString"), "lower(v.name) ");
        }
        String whereString = whereClause.build();
        String baseHql = "select v from VisitTemplate v " + whereString + " order by " + ofSortBy + " " + ofOrderBy;
        boolean filterStringIsPresent = !Strings.isNullOrEmpty((String)filterString);
        String simpleHql = filterStringIsPresent ? baseHql.replaceAll(":filterString", filterString.toLowerCase()) : baseHql;
        Query mainQuery = this.newQuery(simpleHql).setParameter("sid", (Object)study);
        long total = mainQuery.list().size();
        int page = ofPage;
        int maxResults = ofMaxResults;
        int offset = (page - 1) * maxResults;
        mainQuery.setFirstResult(offset);
        mainQuery.setMaxResults(maxResults);
        List resultRows = mainQuery.list();
        String investigator = this.getInvestigator(study);
        return GetStudyVisitsResponse.createGetStudyVisitsResponse(resultRows, total, study.getName(), study.getLocalId(), investigator, study.getId());
    }

    private String getInvestigator(Study study) {
        if (study.getInvestigator() != null) {
            return study.getInvestigator().getFirstName() + " " + study.getInvestigator().getLastName();
        }
        return "N/A";
    }

    public List<UserDataResponse> getStudyMembers(Study study, String sortBy, String orderBy, int page, int maxResults, SearchDTO searchDto) {
        List<SearchDTO.SearchItem> searchItems;
        StringBuffer commonQueryStringBuffer = new StringBuffer("from StudyUser su WHERE su.study = :study ");
        List<SearchDTO.SearchItem> list = searchItems = searchDto != null ? searchDto.getSearchItems() : null;
        if (searchItems != null && !searchItems.isEmpty()) {
            String totalSearchClause = SearchDTO.toSearchClause(searchItems, key -> key);
            commonQueryStringBuffer.append(totalSearchClause);
        }
        StringBuffer rowsQueryStringBuffer = new StringBuffer("SELECT su ");
        rowsQueryStringBuffer.append(commonQueryStringBuffer);
        rowsQueryStringBuffer.append(" order by " + sortBy + " " + orderBy);
        int offset = (page - 1) * maxResults;
        Query rowsQuery = this.newQuery(rowsQueryStringBuffer.toString()).setParameter("study", (Object)study);
        rowsQuery.setFirstResult(offset);
        rowsQuery.setMaxResults(maxResults);
        List resultRows = rowsQuery.list();
        StringBuffer countQueryStringBuffer = new StringBuffer("SELECT count(su.id) ");
        countQueryStringBuffer.append(commonQueryStringBuffer);
        Query countQuery = this.newQuery(countQueryStringBuffer.toString()).setParameter("study", (Object)study);
        Long total = (Long)countQuery.uniqueResult();
        return UserDataResponse.getStudyUserData(resultRows, total);
    }

    public List<StudySubject> findStudySubjectBySubjectMrn(SubjectMrn subjectMrn) {
        String queryString = "Select ss FROM StudySubject ss WHERE ss.subjectMrn = :subjectMrn";
        Query query = this.newQuery(queryString);
        query.setParameter("subjectMrn", (Object)subjectMrn);
        return query.list();
    }

    public List<StudySubject> getRawStudySubjectsByStudy(Study study, Boolean ofWantAll, List<SearchDTO.SearchItem> searchItems) {
        List<StudySubject> resultRows = this.findStudySubjectsByStudyClausically(study, ofWantAll, searchItems);
        return resultRows;
    }

    public List<StudySubject> findStudySubjectsByStudyClausically(Study study, Boolean ofWantAll, List<SearchDTO.SearchItem> searchItems) {
        StringBuilder findStudySubjects = new StringBuilder();
        findStudySubjects.append("SELECT ss FROM StudySubject ss, Subject su, SubjectMrn sm ");
        HqlClauses.WhereBuilder builder = HqlClauses.whereBuilder();
        builder.equalTo(Optional.of(":study"), "ss.study").equalTo(Optional.of("ss.subjectMrn"), "sm.id").equalTo(Optional.of("sm.subject"), "su.id").equalTo(Optional.of("true"), "su.active");
        if (!ofWantAll.booleanValue()) {
            builder.equalTo(Optional.of("true"), "ss.active");
        }
        String whereClause = builder.build();
        findStudySubjects.append(whereClause);
        findStudySubjects.append(" and su.archivalStatus IS NULL ");
        String fullSearchClauseString = "";
        if (searchItems != null) {
            HashMap itemKeyToColumn = Maps.newHashMap();
            itemKeyToColumn.put("mrn", "sm.mrn");
            itemKeyToColumn.put("lastName", "su.lastName");
            itemKeyToColumn.put("firstName", "su.firstName");
            itemKeyToColumn.put("birthdate", "su.birthdate");
            itemKeyToColumn.put("city", "su.city");
            itemKeyToColumn.put("state", "su.state.name");
            itemKeyToColumn.put("primaryContactNumber", "su.primaryContactNumber");
            Function<String, String> keyMapper = key -> (String)itemKeyToColumn.get(key);
            Function<SearchDTO.SearchItem, String> valueMapper = si -> {
                String value = "";
                value = !si.getKey().equals("state") && !si.getKey().equals("birthdate") ? SubjectDataEncryptor.encrypt(si.getValue().toUpperCase()) : si.getValue();
                return value;
            };
            fullSearchClauseString = SearchDTO.toSearchClause(searchItems, keyMapper, valueMapper);
        }
        findStudySubjects.append(fullSearchClauseString);
        Query mainQuery = this.newQuery(findStudySubjects.toString()).setParameter("study", (Object)study);
        return mainQuery.list();
    }

    private static final class VisitTemplateRow {
        private final String lastName;
        private final String firstName;
        private final Integer vId;
        private final String vName;
        private final Boolean approved;
        private final String vTypeName;
        private final Date vLastUpdateTime;
        private final String sublocName;
        private final String stLocalId;
        private final Integer stId;

        public VisitTemplateRow(String lastName, String firstName, Integer vId, String vName, Boolean approved, String vTypeName, Date vLastUpdateTime, String sublocName, String stLocalId, Integer stId) {
            this.lastName = lastName;
            this.firstName = firstName;
            this.vId = vId;
            this.vName = vName;
            this.approved = approved;
            this.vTypeName = VisitType.valueOf(vTypeName).getName();
            this.vLastUpdateTime = vLastUpdateTime;
            this.sublocName = sublocName;
            this.stLocalId = stLocalId;
            this.stId = stId;
        }

        static VisitTemplateRow fromArray(Object[] row) {
            return new VisitTemplateRow((String)row[0], (String)row[1], (Integer)row[2], (String)row[3], (Boolean)row[4], (String)row[5], (Date)row[6], (String)row[7], (String)row[8], (Integer)row[9]);
        }

        VisitTemplatesResponse toVisitTemplatesResponse(Long total) {
            String piName = this.lastName != null ? this.lastName + " " + this.firstName : " ";
            return new VisitTemplatesResponse(this.vId, this.stId, this.vName, this.vTypeName, this.sublocName, this.approved != false ? "Approved" : "Not Approved", total, this.stLocalId, this.vLastUpdateTime, piName);
        }
    }

    private static final class StudyFundingSourceRow {
        private final Integer id;
        private final String name;
        private final String comment;
        private final Integer oneToFour;
        private final String grant;
        private final String center;
        private final Double direct;
        private final Double indirect;
        private final Date start;
        private final Date end;
        private final Optional<CentersAndInstitutions> centerAndInstitution;

        StudyFundingSourceRow(Integer id, String name, String comment, Integer oneToFour, String grant, String center, Double direct, Double indirect, Date start, Date end, Optional<CentersAndInstitutions> centerAndInstitution) {
            this.id = id;
            this.name = name;
            this.comment = comment;
            this.oneToFour = oneToFour;
            this.grant = grant;
            this.center = center;
            this.direct = direct;
            this.indirect = indirect;
            this.start = start;
            this.end = end;
            this.centerAndInstitution = centerAndInstitution;
        }

        FundingSourceInfo toFundingSourceInfo() {
            Optional<Integer> centerId = this.centerAndInstitution.map(BaseEntity::getId);
            Optional<String> centerName = this.centerAndInstitution.map(CentersAndInstitutions::getName);
            return new FundingSourceInfo(this.id, this.name, this.comment, this.oneToFour, this.grant, this.center, this.direct, this.indirect, this.start, this.end, centerId.orElse(null), centerName.orElse(null));
        }
    }
}

