/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.catalyst.scheduler.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public final class KeyFactory {
    private final String keystoreLocation;
    private final String keystorePassword;
    private final String keyAlias;
    private final String keyPassword;

    public KeyFactory(String keystoreLocation, String keystorePassword, String keyAlias, String keyPassword) {
        this.keyAlias = keyAlias;
        this.keyPassword = keyPassword;
        this.keystoreLocation = keystoreLocation;
        this.keystorePassword = keystorePassword;
    }

    public Key createKey() throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        KeyStore keyStore = KeyStore.getInstance("JCEKS");
        try (FileInputStream fis = new FileInputStream(this.keystoreLocation);){
            keyStore.load(fis, this.keystorePassword.toCharArray());
            Key key = keyStore.getKey(this.keyAlias, this.keyPassword.toCharArray());
            return key;
        }
    }
}

